/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;

class ESFileStore
extends FileStore {
    final FileStore in;
    final Boolean spins;
    int majorDeviceNumber;
    int minorDeviceNumber;

    @SuppressForbidden(reason="tries to determine if disk is spinning")
    ESFileStore(FileStore in) {
        Boolean spins;
        this.in = in;
        if (Constants.LINUX) {
            try {
                spins = IOUtils.spins((Path)PathUtils.get(ESFileStore.getMountPointLinux(in), new String[0]));
            }
            catch (Exception e) {
                spins = null;
            }
            try {
                List<String> lines = Files.readAllLines(PathUtils.get("/proc/self/mountinfo", new String[0]));
                for (String line : lines) {
                    String[] fields = line.trim().split("\\s+");
                    String mountPoint = fields[4];
                    if (!mountPoint.equals(ESFileStore.getMountPointLinux(in))) continue;
                    String[] deviceNumbers = fields[2].split(":");
                    this.majorDeviceNumber = Integer.parseInt(deviceNumbers[0]);
                    this.minorDeviceNumber = Integer.parseInt(deviceNumbers[1]);
                }
            }
            catch (Exception e) {
                this.majorDeviceNumber = -1;
                this.minorDeviceNumber = -1;
            }
        } else {
            spins = null;
        }
        this.spins = spins;
    }

    private static String getMountPointLinux(FileStore store) {
        String desc = store.toString();
        int index = desc.lastIndexOf(" (");
        if (index != -1) {
            return desc.substring(0, index);
        }
        return desc;
    }

    @SuppressForbidden(reason="works around the bugs")
    static FileStore getMatchingFileStore(Path path, FileStore[] fileStores) throws IOException {
        FileStore store;
        if (Constants.WINDOWS) {
            return ESFileStore.getFileStoreWindows(path, fileStores);
        }
        try {
            store = Files.getFileStore(path);
        }
        catch (IOException unexpected) {
            if (Constants.FREE_BSD) {
                throw new IOException("Unable to retrieve mount point data for " + path + ". If you are running within a jail, set enforce_statfs=1. See jail(8)", unexpected);
            }
            throw unexpected;
        }
        try {
            String mount = ESFileStore.getMountPointLinux(store);
            FileStore sameMountPoint = null;
            for (FileStore fs : fileStores) {
                if (!mount.equals(ESFileStore.getMountPointLinux(fs))) continue;
                if (sameMountPoint == null) {
                    sameMountPoint = fs;
                    continue;
                }
                return store;
            }
            if (sameMountPoint != null) {
                return sameMountPoint;
            }
            return store;
        }
        catch (Exception exception) {
            return store;
        }
    }

    @SuppressForbidden(reason="works around https://bugs.openjdk.java.net/browse/JDK-8034057")
    static FileStore getFileStoreWindows(Path path, FileStore[] fileStores) throws IOException {
        assert (Constants.WINDOWS);
        try {
            return Files.getFileStore(path);
        }
        catch (FileSystemException possibleBug) {
            char driveLetter;
            try {
                String root = path.toRealPath(new LinkOption[0]).getRoot().toString();
                if (root.length() < 2) {
                    throw new RuntimeException("root isn't a drive letter: " + root);
                }
                driveLetter = Character.toLowerCase(root.charAt(0));
                if (!Character.isAlphabetic(driveLetter) || root.charAt(1) != ':') {
                    throw new RuntimeException("root isn't a drive letter: " + root);
                }
            }
            catch (Exception checkFailed) {
                possibleBug.addSuppressed(checkFailed);
                throw possibleBug;
            }
            try {
                for (FileStore store : fileStores) {
                    String toString = store.toString();
                    int length = toString.length();
                    if (length <= 3 || !toString.endsWith(":)") || toString.charAt(length - 4) != '(' || Character.toLowerCase(toString.charAt(length - 3)) != driveLetter) continue;
                    return store;
                }
                throw new RuntimeException("no filestores matched");
            }
            catch (Exception weTried) {
                IOException newException = new IOException("Unable to retrieve filestore for '" + path + "', tried matching against " + Arrays.toString(fileStores), weTried);
                newException.addSuppressed(possibleBug);
                throw newException;
            }
        }
    }

    @Override
    public String name() {
        return this.in.name();
    }

    @Override
    public String type() {
        return this.in.type();
    }

    @Override
    public boolean isReadOnly() {
        return this.in.isReadOnly();
    }

    @Override
    public long getTotalSpace() throws IOException {
        long result = this.in.getTotalSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public long getUsableSpace() throws IOException {
        long result = this.in.getUsableSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        long result = this.in.getUnallocatedSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return this.in.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if ("lucene".equals(name)) {
            return true;
        }
        return this.in.supportsFileAttributeView(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return this.in.getFileStoreAttributeView(type);
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        switch (attribute) {
            case "lucene:spins": {
                return this.spins;
            }
            case "lucene:major_device_number": {
                return this.majorDeviceNumber;
            }
            case "lucene:minor_device_number": {
                return this.minorDeviceNumber;
            }
        }
        return this.in.getAttribute(attribute);
    }

    public String toString() {
        return this.in.toString();
    }
}

