/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.ingest.ValueSource;

public final class SetProcessor
extends AbstractProcessor {
    public static final String TYPE = "set";
    private final boolean overrideEnabled;
    private final TemplateService.Template field;
    private final ValueSource value;

    SetProcessor(String tag, TemplateService.Template field, ValueSource value) {
        this(tag, field, value, true);
    }

    SetProcessor(String tag, TemplateService.Template field, ValueSource value, boolean overrideEnabled) {
        super(tag);
        this.overrideEnabled = overrideEnabled;
        this.field = field;
        this.value = value;
    }

    public boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public TemplateService.Template getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public void execute(IngestDocument document) {
        if (this.overrideEnabled || !document.hasField(this.field) || document.getFieldValue(this.field, Object.class) == null) {
            document.setFieldValue(this.field, this.value);
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final TemplateService templateService;

        public Factory(TemplateService templateService) {
            this.templateService = templateService;
        }

        public SetProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"field");
            Object value = ConfigurationUtils.readObject((String)SetProcessor.TYPE, (String)processorTag, config, (String)"value");
            boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"override", (boolean)true);
            TemplateService.Template compiledTemplate = ConfigurationUtils.compileTemplate((String)SetProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (TemplateService)this.templateService);
            return new SetProcessor(processorTag, compiledTemplate, ValueSource.wrap((Object)value, (TemplateService)this.templateService), overrideEnabled);
        }
    }
}

