/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AutomatonTermsEnum;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.SortedSetDocValuesTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class SortedSetDocValues {
    public static final long NO_MORE_ORDS = -1L;

    protected SortedSetDocValues() {
    }

    public abstract long nextOrd();

    public abstract void setDocument(int var1);

    public abstract BytesRef lookupOrd(long var1);

    public abstract long getValueCount();

    public long lookupTerm(BytesRef key) {
        long low = 0L;
        long high = this.getValueCount() - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public TermsEnum termsEnum() {
        return new SortedSetDocValuesTermsEnum(this);
    }

    public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
        TermsEnum in = this.termsEnum();
        switch (automaton.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return in;
            }
            case SINGLE: {
                return new SingleTermsEnum(in, automaton.term);
            }
            case NORMAL: {
                return new AutomatonTermsEnum(in, automaton);
            }
        }
        throw new RuntimeException("unhandled case");
    }
}

