/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.WorkSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Lister
extends Action {
    private WorkSet allItems;

    private long readUntilEnd(InputStream is) throws IOException {
        int r;
        byte[] buffer = new byte[5120];
        long result = 0L;
        while ((r = is.read(buffer)) != -1) {
            result += (long)r;
        }
        return result;
    }

    private void listJar(ZipInputStream zis, boolean verbose) throws IOException {
        ZipEntry entry;
        MessageFormat format = null;
        if (verbose) {
            format = new MessageFormat(" {0,date,E M dd HH:mm:ss z yyyy} {1}");
        }
        while ((entry = zis.getNextEntry()) != null) {
            if (!this.allItems.contains(entry.getName())) continue;
            if (verbose) {
                long size = this.readUntilEnd(zis);
                String s = "     " + size;
                int index = Math.min(s.length() - 5, 5);
                System.out.print(s.substring(index));
                Object[] values = new Object[]{new Date(entry.getTime()), entry.getName()};
                System.out.println(format.format(values));
                continue;
            }
            System.out.println(entry.getName());
        }
    }

    public void run(Main parameters) throws IOException {
        this.allItems = new WorkSet(parameters.entries);
        File file = parameters.archiveFile;
        ZipInputStream zis = file == null || "-".equals(file.getName()) ? new ZipInputStream(System.in) : new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.listJar(zis, parameters.verbose);
    }
}

