/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

public class ToneReproductionCurve {
    private float[] trc;
    private float gamma;
    private float[] reverseTrc;

    public ToneReproductionCurve(float gamma) {
        this.trc = null;
        this.reverseTrc = null;
        this.gamma = gamma;
    }

    public ToneReproductionCurve(float[] trcValues) {
        this.trc = new float[trcValues.length];
        System.arraycopy(trcValues, 0, this.trc, 0, trcValues.length);
        this.setupReverseTrc();
    }

    public ToneReproductionCurve(short[] trcValues) {
        this.trc = new float[trcValues.length];
        int i = 0;
        while (i < trcValues.length) {
            this.trc[i] = (float)(trcValues[i] & 0xFFFF) / 65535.0f;
            ++i;
        }
        this.setupReverseTrc();
    }

    public float lookup(float in) {
        if (this.trc == null) {
            if (in == 0.0f) {
                return 0.0f;
            }
            return (float)Math.exp((double)this.gamma * Math.log(in));
        }
        double alpha = in * (float)(this.trc.length - 1);
        int index = (int)Math.floor(alpha);
        alpha -= (double)index;
        if (index >= this.trc.length - 1) {
            return this.trc[this.trc.length - 1];
        }
        if (index <= 0) {
            return this.trc[0];
        }
        float out = (float)((double)this.trc[index] * (1.0 - alpha) + (double)this.trc[index + 1] * alpha);
        return out;
    }

    public float reverseLookup(float in) {
        if (this.trc == null) {
            if (in == 0.0f) {
                return 0.0f;
            }
            return (float)Math.exp(1.0 / (double)this.gamma * Math.log(in));
        }
        double alpha = in * (float)(this.reverseTrc.length - 1);
        int index = (int)Math.floor(alpha);
        alpha -= (double)index;
        if (index >= this.reverseTrc.length - 1) {
            return this.reverseTrc[this.reverseTrc.length - 1];
        }
        if (index <= 0) {
            return this.reverseTrc[0];
        }
        float out = (float)((double)this.reverseTrc[index] * (1.0 - alpha) + (double)this.reverseTrc[index + 1] * alpha);
        return out;
    }

    public void setupReverseTrc() {
        this.reverseTrc = new float[10000];
        int j = 0;
        int i = 0;
        while (i < 10000) {
            float n = (float)i / 10000.0f;
            while (this.trc[j + 1] < n && j < this.trc.length - 2) {
                ++j;
            }
            this.reverseTrc[i] = j == this.trc.length - 2 ? this.trc[this.trc.length - 1] : ((float)j + (n - this.trc[j]) / (this.trc[j + 1] - this.trc[j])) / (float)this.trc.length;
            ++i;
        }
    }
}

