/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.Buffers;
import gnu.java.awt.peer.gtk.CairoSurfaceGraphics;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Hashtable;

public class CairoSurface
extends WritableRaster {
    int width = -1;
    int height = -1;
    long surfacePointer;
    boolean sharedBuffer;
    static ColorModel cairoColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    static ColorModel cairoCM_pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, Buffers.smallestAppropriateTransferType(32));
    static ColorModel cairoCM_opaque = new DirectColorModel(24, 0xFF0000, 65280, 255);

    private native void create(int var1, int var2, int var3, int[] var4);

    private native void destroy(long var1, int[] var3);

    public native void nativeDrawSurface(long var1, long var3, double[] var5, double var6, int var8);

    native void syncNativeToJava(long var1, int[] var3);

    native void syncJavaToNative(long var1, int[] var3);

    native long getFlippedBuffer(long var1);

    public CairoSurface(int width, int height) {
        this(0, 0, width, height);
    }

    public CairoSurface(int x, int y, int width, int height) {
        super(CairoSurface.createCairoSampleModel(width, height), null, new Point(x, y));
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image must be at least 1x1 pixels.");
        }
        this.width = width;
        this.height = height;
        this.dataBuffer = new DataBufferInt(width * height);
        this.create(width, height, width, this.getData());
        if (this.surfacePointer == 0L) {
            throw new Error("Could not allocate bitmap.");
        }
    }

    public CairoSurface(SampleModel sm, CairoSurface parent, Rectangle bounds, Point origin) {
        super(sm, parent.dataBuffer, bounds, origin, parent);
        this.width = ((WritableRaster)this).width;
        this.height = ((WritableRaster)this).height;
        this.surfacePointer = parent.surfacePointer;
        this.sharedBuffer = parent.sharedBuffer;
        this.dataBuffer = parent.dataBuffer;
    }

    CairoSurface(GtkImage image) {
        this(image.width, image.height);
        int[] data = image.getPixels();
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < data.length) {
                int alpha = data[i] & 0xFF;
                data[i] = alpha == 0 ? 0 : data[i] >>> 8 | alpha << 24;
                ++i;
            }
        } else {
            int i = 0;
            while (i < data.length) {
                int alpha = data[i] & 0xFF000000;
                if (alpha == 0) {
                    data[i] = 0;
                } else {
                    int b = (data[i] & 0xFF0000) >> 16;
                    int g = data[i] & 0xFF00;
                    int r = (data[i] & 0xFF) << 16;
                    data[i] = alpha | r | g | b;
                }
                ++i;
            }
        }
        System.arraycopy(data, 0, this.getData(), 0, data.length);
    }

    public void dispose() {
        if (this.surfacePointer != 0L && this.parent == null) {
            this.destroy(this.surfacePointer, this.getData());
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public GtkImage getGtkImage() {
        return new GtkImage(this.width, this.height, this.getFlippedBuffer(this.surfacePointer));
    }

    public int[] getData() {
        return ((DataBufferInt)this.dataBuffer).getData();
    }

    public static BufferedImage getBufferedImage(int width, int height) {
        return CairoSurface.getBufferedImage(new CairoSurface(width, height));
    }

    public static BufferedImage getBufferedImage(GtkImage image) {
        return CairoSurface.getBufferedImage(new CairoSurface(image));
    }

    public static BufferedImage getBufferedImage(CairoSurface surface) {
        return new BufferedImage(cairoColorModel, surface, cairoColorModel.isAlphaPremultiplied(), new Hashtable());
    }

    public Graphics2D getGraphics() {
        return new CairoSurfaceGraphics(this);
    }

    native long nativeNewCairoContext(long var1);

    public long newCairoContext() {
        return this.nativeNewCairoContext(this.surfacePointer);
    }

    public void copyAreaNative(int x, int y, int width, int height, int dx, int dy, int stride) {
        this.copyAreaNative2(this.surfacePointer, x, y, width, height, dx, dy, stride);
    }

    native void copyAreaNative2(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    protected static SampleModel createCairoSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(3, w, h, new int[]{0xFF0000, 65280, 255, -16777216});
    }

    public static boolean isCompatibleColorModel(ColorModel cm) {
        return cm.equals(cairoCM_pre) || cm.equals(cairoCM_opaque) || cm.equals(cairoColorModel);
    }

    public static boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof SinglePixelPackedSampleModel && sm.getDataType() == 3 && Arrays.equals(((SinglePixelPackedSampleModel)sm).getBitMasks(), new int[]{0xFF0000, 65280, 255, -16777216});
    }

    public Raster createChild(int parentX, int parentY, int width, int height, int childMinX, int childMinY, int[] bandList) {
        return this.createWritableChild(parentX, parentY, width, height, childMinX, childMinY, bandList);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new CairoSurface(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int x, int y, int w, int h) {
        return new CairoSurface(x, y, w, h);
    }

    public Raster createTranslatedChild(int childMinX, int childMinY) {
        return this.createWritableTranslatedChild(childMinX, childMinY);
    }

    public WritableRaster createWritableChild(int parentX, int parentY, int w, int h, int childMinX, int childMinY, int[] bandList) {
        if (parentX < this.minX || parentX + w > this.minX + this.width || parentY < this.minY || parentY + h > this.minY + this.height) {
            throw new RasterFormatException("Child raster extends beyond parent");
        }
        SampleModel sm = bandList == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(bandList);
        return new CairoSurface(sm, this, new Rectangle(childMinX, childMinY, w, h), new Point(this.sampleModelTranslateX + childMinX - parentX, this.sampleModelTranslateY + childMinY - parentY));
    }

    public WritableRaster createWritableTranslatedChild(int x, int y) {
        int tcx = this.sampleModelTranslateX - this.minX + x;
        int tcy = this.sampleModelTranslateY - this.minY + y;
        return new CairoSurface(this.sampleModel, this, new Rectangle(x, y, this.width, this.height), new Point(tcx, tcy));
    }
}

