/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.channels;

import gnu.java.nio.FileLockImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class FileChannelImpl
extends FileChannel {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int APPEND = 4;
    public static final int EXCL = 8;
    public static final int SYNC = 16;
    public static final int DSYNC = 32;
    private int fd = -1;
    private long pos;
    private int mode;
    public static FileChannelImpl in;
    public static FileChannelImpl out;
    public static FileChannelImpl err;

    static {
        FileChannelImpl.init();
    }

    private static native void init();

    public FileChannelImpl() {
    }

    public static FileChannelImpl create(File file, int mode) throws FileNotFoundException {
        return new FileChannelImpl(file, mode);
    }

    private FileChannelImpl(File file, int mode) throws FileNotFoundException {
        String path = file.getPath();
        this.fd = this.open(path, mode);
        this.mode = mode;
        if (file.isDirectory()) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
            throw new FileNotFoundException(String.valueOf(path) + " is a directory");
        }
    }

    FileChannelImpl(int fd, int mode) {
        this.fd = fd;
        this.mode = mode;
    }

    private native int open(String var1, int var2) throws FileNotFoundException;

    public native int available() throws IOException;

    private native long implPosition() throws IOException;

    private native void seek(long var1) throws IOException;

    private native void implTruncate(long var1) throws IOException;

    public native void unlock(long var1, long var3) throws IOException;

    public native long size() throws IOException;

    protected native void implCloseChannel() throws IOException;

    protected void finalize() throws IOException {
        this.close();
    }

    public int read(ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[dst.remaining()];
        int result = this.read(buffer, 0, buffer.length);
        if (result > 0) {
            dst.put(buffer, 0, result);
        }
        return result;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        long oldPosition = this.implPosition();
        this.position(position);
        int result = this.read(dst);
        this.position(oldPosition);
        return result;
    }

    public native int read() throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long result = 0L;
        int i = offset;
        while (i < offset + length) {
            result += (long)this.read(dsts[i]);
            ++i;
        }
        return result;
    }

    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (src.hasArray()) {
            byte[] buffer = src.array();
            this.write(buffer, src.arrayOffset() + src.position(), len);
            src.position(src.position() + len);
        } else {
            byte[] buffer = new byte[len];
            src.get(buffer, 0, len);
            this.write(buffer, 0, len);
        }
        return len;
    }

    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long oldPosition = this.implPosition();
        this.seek(position);
        int result = this.write(src);
        this.seek(oldPosition);
        return result;
    }

    public native void write(byte[] var1, int var2, int var3) throws IOException;

    public native void write(int var1) throws IOException;

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long result = 0L;
        int i = offset;
        while (i < offset + length) {
            result += (long)this.write(srcs[i]);
            ++i;
        }
        return result;
    }

    public native MappedByteBuffer mapImpl(char var1, long var2, int var4) throws IOException;

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        char nmode = '\u0000';
        if (mode == FileChannel.MapMode.READ_ONLY) {
            nmode = 'r';
            if ((this.mode & 1) == 0) {
                throw new NonReadableChannelException();
            }
        } else if (mode == FileChannel.MapMode.READ_WRITE || mode == FileChannel.MapMode.PRIVATE) {
            char c = nmode = mode == FileChannel.MapMode.READ_WRITE ? (char)'+' : 'c';
            if ((this.mode & 3) != 3) {
                throw new NonWritableChannelException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.mapImpl(nmode, position, (int)size);
    }

    public void force(boolean metaData) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private int smallTransferTo(long position, int count, WritableByteChannel target) throws IOException {
        ByteBuffer buffer;
        try {
            buffer = this.map(FileChannel.MapMode.READ_ONLY, position, count);
        }
        catch (IOException iOException) {
            buffer = ByteBuffer.allocate(count);
            this.read(buffer, position);
            buffer.flip();
        }
        return target.write(buffer);
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        long total = 0L;
        while (count > 0L) {
            int transferred = this.smallTransferTo(position, (int)Math.min(count, 65536L), target);
            if (transferred < 0) break;
            total += (long)transferred;
            position += (long)transferred;
            count -= (long)transferred;
        }
        return total;
    }

    private int smallTransferFrom(ReadableByteChannel src, long position, int count) throws IOException {
        ByteBuffer buffer = null;
        if (src instanceof FileChannel) {
            try {
                buffer = ((FileChannel)src).map(FileChannel.MapMode.READ_ONLY, position, count);
            }
            catch (IOException iOException) {}
        }
        if (buffer == null) {
            buffer = ByteBuffer.allocate(count);
            src.read(buffer);
            buffer.flip();
        }
        return this.write(buffer, position);
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long total = 0L;
        while (count > 0L) {
            int transferred = this.smallTransferFrom(src, position, (int)Math.min(count, 65536L));
            if (transferred < 0) break;
            total += (long)transferred;
            position += (long)transferred;
            count -= (long)transferred;
        }
        return total;
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (shared && (this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        if (!shared && (this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        boolean completed = false;
        try {
            this.begin();
            boolean lockable = this.lock(position, size, shared, false);
            completed = true;
            FileLockImpl fileLockImpl = lockable ? new FileLockImpl(this, position, size, shared) : null;
            return fileLockImpl;
        }
        finally {
            this.end(completed);
        }
    }

    private native boolean lock(long var1, long var3, boolean var5, boolean var6) throws IOException;

    public FileLock lock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        boolean completed = false;
        try {
            boolean lockable = this.lock(position, size, shared, true);
            completed = true;
            FileLockImpl fileLockImpl = lockable ? new FileLockImpl(this, position, size, shared) : null;
            return fileLockImpl;
        }
        finally {
            this.end(completed);
        }
    }

    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.seek(newPosition);
        return this;
    }

    public FileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        if (size < this.size()) {
            this.implTruncate(size);
        }
        return this;
    }

    public int getNativeFD() {
        return this.fd;
    }
}

