/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.params;

import gnu.javax.crypto.jce.params.DERReader;
import gnu.javax.crypto.jce.params.DERWriter;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.logging.Logger;
import javax.crypto.spec.IvParameterSpec;

public class BlockCipherParameters
extends AlgorithmParametersSpi {
    private static final Logger log = null;
    protected BlockCipherParameterSpec cipherSpec;
    private static final String DEFAULT_FORMAT = "ASN.1";

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded(DEFAULT_FORMAT);
    }

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (!format.equalsIgnoreCase(DEFAULT_FORMAT) && !format.equalsIgnoreCase("asn1")) {
            throw new IOException("unknown format \"" + format + "\"");
        }
        DERWriter writer = new DERWriter();
        int cipherBlockSize = this.cipherSpec.getBlockSize();
        int cipherKeySize = this.cipherSpec.getKeySize();
        byte[] iv = this.cipherSpec.getIV();
        return writer.joinarrays(writer.writeBigInteger(BigInteger.valueOf(cipherBlockSize)), writer.writeBigInteger(BigInteger.valueOf(cipherKeySize)), iv != null ? writer.writeBigInteger(new BigInteger(iv)) : new byte[]{});
    }

    protected void engineInit(AlgorithmParameterSpec spec) throws InvalidParameterSpecException {
        if (!(spec instanceof BlockCipherParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        this.cipherSpec = (BlockCipherParameterSpec)spec;
    }

    protected void engineInit(byte[] encoded, String format) throws IOException {
        if (!format.equalsIgnoreCase(DEFAULT_FORMAT) && !format.equalsIgnoreCase("ASN1")) {
            throw new IOException("invalid format: only accepts ASN.1");
        }
        this.engineInit(encoded);
    }

    protected void engineInit(byte[] encoded) throws IOException {
        DERReader reader = new DERReader(encoded);
        int bs = reader.getBigInteger().intValue();
        int ks = reader.getBigInteger().intValue();
        byte[] iv = null;
        if (reader.hasMorePrimitives()) {
            iv = reader.getBigInteger().toByteArray();
        }
        this.cipherSpec = new BlockCipherParameterSpec(iv, bs, ks);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class c) throws InvalidParameterSpecException {
        if (c.isInstance(this.cipherSpec)) {
            return this.cipherSpec;
        }
        if (IvParameterSpec.class.isAssignableFrom(c)) {
            IvParameterSpec result = new IvParameterSpec(this.cipherSpec.getIV());
            return result;
        }
        throw new InvalidParameterSpecException();
    }

    protected String engineToString() {
        return this.cipherSpec.toString();
    }
}

