/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class ArithmeticExpr
extends Expr {
    static final int ADD = 0;
    static final int SUBTRACT = 1;
    static final int MULTIPLY = 2;
    static final int DIVIDE = 3;
    static final int MODULO = 4;
    final Expr lhs;
    final Expr rhs;
    final int op;

    ArithmeticExpr(Expr lhs, Expr rhs, int op) {
        this.lhs = lhs;
        this.rhs = rhs;
        switch (op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.op = op;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object evaluate(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        Object right = this.rhs.evaluate(context, pos, len);
        double ln = ArithmeticExpr._number(context, left);
        double rn = ArithmeticExpr._number(context, right);
        switch (this.op) {
            case 0: {
                return new Double(ln + rn);
            }
            case 1: {
                return new Double(ln - rn);
            }
            case 2: {
                return new Double(ln * rn);
            }
            case 3: {
                if (rn == 0.0 || rn == -0.0) {
                    if (ln == 0.0 || ln == -0.0) {
                        return new Double(Double.NaN);
                    }
                    return new Double(ln < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                return new Double(ln / rn);
            }
            case 4: {
                if (rn == 0.0 || rn == 0.0) {
                    if (ln == 0.0 || ln == -0.0) {
                        return new Double(Double.NaN);
                    }
                    return new Double(ln < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                return new Double(ln % rn);
            }
        }
        throw new IllegalStateException();
    }

    public Expr clone(Object context) {
        return new ArithmeticExpr(this.lhs.clone(context), this.rhs.clone(context), this.op);
    }

    public boolean references(QName var) {
        return this.lhs.references(var) || this.rhs.references(var);
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder();
        buf.append(this.lhs);
        buf.append(' ');
        switch (this.op) {
            case 0: {
                buf.append('+');
                break;
            }
            case 1: {
                buf.append('-');
                break;
            }
            case 2: {
                buf.append('*');
                break;
            }
            case 3: {
                buf.append("div");
                break;
            }
            case 4: {
                buf.append("mod");
            }
        }
        buf.append(' ');
        buf.append(this.rhs);
        return buf.toString();
    }
}

