/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Area
implements Shape,
Cloneable {
    private static final double EPSILON = 1.0E-11;
    private static final double RS_EPSILON = 1.0E-13;
    private static final double PE_EPSILON = 1.0E-11;
    Vector<Segment> solids = new Vector();
    Vector<Segment> holes = new Vector();
    private Vector<double[]> ccIntersections;
    private int windingRule;

    public Area() {
    }

    public Area(Shape s) {
        this();
        Vector<Segment> p = this.makeSegment(s);
        if (p == null) {
            return;
        }
        int i = 0;
        while (i < p.size()) {
            if (p.elementAt(i).getSignedArea() == 0.0) {
                p.remove(i--);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < p.size()) {
            Segment path = p.elementAt(i2);
            this.createNodesSelf(path);
            ++i2;
        }
        if (p.size() > 1) {
            i2 = 0;
            while (i2 < p.size() - 1) {
                int j = i2 + 1;
                while (j < p.size()) {
                    Segment path1 = p.elementAt(i2);
                    Segment path2 = p.elementAt(j);
                    this.createNodes(path1, path2);
                    ++j;
                }
                ++i2;
            }
        }
        Vector<Segment> segments = new Vector<Segment>();
        int i3 = 0;
        while (i3 < p.size()) {
            Segment v;
            Segment path = v = p.elementAt(i3);
            do {
                segments.add(v);
            } while ((v = v.next) != path);
            ++i3;
        }
        Vector<Segment> paths = this.weilerAtherton(segments);
        this.deleteRedundantPaths(paths);
    }

    public void add(Area area) {
        Segment path;
        Segment v;
        if (this.equals(area)) {
            return;
        }
        if (area.isEmpty()) {
            return;
        }
        Area B = (Area)area.clone();
        Vector<Segment> pathA = new Vector<Segment>();
        Vector<Segment> pathB = new Vector<Segment>();
        pathA.addAll((Collection<Segment>)this.solids);
        pathA.addAll((Collection<Segment>)this.holes);
        pathB.addAll((Collection<Segment>)B.solids);
        pathB.addAll((Collection<Segment>)B.holes);
        int i = 0;
        while (i < pathA.size()) {
            Segment a = (Segment)pathA.elementAt(i);
            int j = 0;
            while (j < pathB.size()) {
                Segment b = (Segment)pathB.elementAt(j);
                this.createNodes(a, b);
                ++j;
            }
            ++i;
        }
        Vector<Segment> paths = new Vector();
        Vector<Segment> segments = new Vector<Segment>();
        int i2 = 0;
        while (i2 < pathA.size()) {
            path = v = (Segment)pathA.elementAt(i2);
            do {
                if (!v.isSegmentOutside(area)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        i2 = 0;
        while (i2 < pathB.size()) {
            path = v = (Segment)pathB.elementAt(i2);
            do {
                if (!v.isSegmentOutside(this)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        paths = this.weilerAtherton(segments);
        this.deleteRedundantPaths(paths);
    }

    public void subtract(Area area) {
        boolean node2;
        Segment path;
        if (this.isEmpty() || area.isEmpty()) {
            return;
        }
        if (this.equals(area)) {
            this.reset();
            return;
        }
        Vector<Segment> pathA = new Vector<Segment>();
        Area B = (Area)area.clone();
        pathA.addAll((Collection<Segment>)this.solids);
        pathA.addAll((Collection<Segment>)this.holes);
        this.setDirection(B.holes, true);
        this.setDirection(B.solids, false);
        Vector<Segment> pathB = new Vector<Segment>();
        pathB.addAll((Collection<Segment>)B.solids);
        pathB.addAll((Collection<Segment>)B.holes);
        int i = 0;
        while (i < pathA.size()) {
            Segment a = (Segment)pathA.elementAt(i);
            int j = 0;
            while (j < pathB.size()) {
                Segment b = (Segment)pathB.elementAt(j);
                this.createNodes(a, b);
                ++j;
            }
            ++i;
        }
        Vector<Segment> segments = new Vector<Segment>();
        int i2 = 0;
        while (i2 < pathA.size()) {
            Segment v;
            path = v = (Segment)pathA.elementAt(i2);
            if (v.isSegmentOutside(area) && v.node == null) {
                segments.add(v);
            }
            node2 = false;
            do {
                if (v.node == null && !node2) continue;
                boolean bl = node2 = v.node != null;
                if (!v.isSegmentOutside(area)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        i2 = 0;
        while (i2 < pathB.size()) {
            Segment v;
            path = v = (Segment)pathB.elementAt(i2);
            if (!v.isSegmentOutside(this) && v.node == null) {
                segments.add(v);
            }
            v = v.next;
            node2 = false;
            do {
                if (v.node == null && !node2) continue;
                boolean bl = node2 = v.node != null;
                if (v.isSegmentOutside(this)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        Vector<Segment> paths = this.weilerAtherton(segments);
        this.deleteRedundantPaths(paths);
    }

    public void intersect(Area area) {
        boolean node2;
        Segment path;
        if (this.isEmpty() || area.isEmpty()) {
            this.reset();
            return;
        }
        if (this.equals(area)) {
            return;
        }
        Vector<Segment> pathA = new Vector<Segment>();
        Area B = (Area)area.clone();
        pathA.addAll((Collection<Segment>)this.solids);
        pathA.addAll((Collection<Segment>)this.holes);
        Vector<Segment> pathB = new Vector<Segment>();
        pathB.addAll((Collection<Segment>)B.solids);
        pathB.addAll((Collection<Segment>)B.holes);
        int i = 0;
        while (i < pathA.size()) {
            Segment a = (Segment)pathA.elementAt(i);
            int j = 0;
            while (j < pathB.size()) {
                Segment b = (Segment)pathB.elementAt(j);
                this.createNodes(a, b);
                ++j;
            }
            ++i;
        }
        Vector<Segment> segments = new Vector<Segment>();
        int i2 = 0;
        while (i2 < pathA.size()) {
            Segment v;
            path = v = (Segment)pathA.elementAt(i2);
            if (!v.isSegmentOutside(area) && v.node == null) {
                segments.add(v);
            }
            node2 = false;
            do {
                if (v.node == null && !node2) continue;
                boolean bl = node2 = v.node != null;
                if (v.isSegmentOutside(area)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        i2 = 0;
        while (i2 < pathB.size()) {
            Segment v;
            path = v = (Segment)pathB.elementAt(i2);
            if (!v.isSegmentOutside(this) && v.node == null) {
                segments.add(v);
            }
            v = v.next;
            node2 = false;
            do {
                if (v.node == null && !node2) continue;
                boolean bl = node2 = v.node != null;
                if (v.isSegmentOutside(this)) continue;
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        Vector<Segment> paths = this.weilerAtherton(segments);
        this.deleteRedundantPaths(paths);
    }

    public void exclusiveOr(Area area) {
        Segment path;
        if (area.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            Area B = (Area)area.clone();
            this.solids = B.solids;
            this.holes = B.holes;
            return;
        }
        if (this.equals(area)) {
            this.reset();
            return;
        }
        Vector<Segment> pathA = new Vector<Segment>();
        Area B = (Area)area.clone();
        Vector<Segment> pathB = new Vector<Segment>();
        pathA.addAll((Collection<Segment>)this.solids);
        pathA.addAll((Collection<Segment>)this.holes);
        this.setDirection(B.holes, true);
        this.setDirection(B.solids, false);
        pathB.addAll((Collection<Segment>)B.solids);
        pathB.addAll((Collection<Segment>)B.holes);
        int i = 0;
        while (i < pathA.size()) {
            Segment a = (Segment)pathA.elementAt(i);
            int j = 0;
            while (j < pathB.size()) {
                Segment b = (Segment)pathB.elementAt(j);
                this.createNodes(a, b);
                ++j;
            }
            ++i;
        }
        Vector<Segment> segments = new Vector<Segment>();
        int i2 = 0;
        while (i2 < pathA.size()) {
            Segment v;
            path = v = (Segment)pathA.elementAt(i2);
            do {
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        i2 = 0;
        while (i2 < pathB.size()) {
            Segment v;
            path = v = (Segment)pathB.elementAt(i2);
            do {
                segments.add(v);
            } while ((v = v.next) != path);
            ++i2;
        }
        Vector<Segment> paths = this.weilerAtherton(segments);
        this.deleteRedundantPaths(paths);
    }

    public void reset() {
        this.solids = new Vector();
        this.holes = new Vector();
    }

    public boolean isEmpty() {
        if (this.solids.size() == 0) {
            return true;
        }
        double totalArea = 0.0;
        int i = 0;
        while (i < this.solids.size()) {
            totalArea += Math.abs(this.solids.elementAt(i).getSignedArea());
            ++i;
        }
        i = 0;
        while (i < this.holes.size()) {
            totalArea -= Math.abs(this.holes.elementAt(i).getSignedArea());
            ++i;
        }
        return totalArea <= 1.0E-11;
    }

    public boolean isPolygonal() {
        int i = 0;
        while (i < this.holes.size()) {
            if (!this.holes.elementAt(i).isPolygonal()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.solids.size()) {
            if (!this.solids.elementAt(i).isPolygonal()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isRectangular() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.holes.size() != 0 || this.solids.size() != 1) {
            return false;
        }
        Segment path = this.solids.elementAt(0);
        if (!path.isPolygonal()) {
            return false;
        }
        int nCorners = 0;
        Segment s = path;
        do {
            Segment s2 = s.next;
            double d1 = (s.P2.getX() - s.P1.getX()) * (s2.P2.getX() - s2.P1.getX()) / (s.P1.distance(s.P2) * s2.P1.distance(s2.P2));
            double d2 = (s.P2.getY() - s.P1.getY()) * (s2.P2.getY() - s2.P1.getY()) / (s.P1.distance(s.P2) * s2.P1.distance(s2.P2));
            double dotproduct = d1 + d2;
            if (d1 != 0.0 && d2 != 0.0) {
                return false;
            }
            if (Math.abs(dotproduct) == 0.0) {
                ++nCorners;
                continue;
            }
            if (!(Math.abs(1.0 - dotproduct) > 0.0)) continue;
            return false;
        } while ((s = s.next) != path);
        return nCorners == 4;
    }

    public boolean isSingular() {
        return this.holes.size() == 0 && this.solids.size() <= 1;
    }

    @Override
    public Rectangle2D getBounds2D() {
        double ymax;
        double xmax;
        if (this.solids.size() == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double xmin = xmax = this.solids.elementAt((int)0).P1.getX();
        double ymin = ymax = this.solids.elementAt((int)0).P1.getY();
        int path = 0;
        while (path < this.solids.size()) {
            Rectangle2D r = this.solids.elementAt(path).getPathBounds();
            xmin = Math.min(r.getMinX(), xmin);
            ymin = Math.min(r.getMinY(), ymin);
            xmax = Math.max(r.getMaxX(), xmax);
            ymax = Math.max(r.getMaxY(), ymax);
            ++path;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Object clone() {
        try {
            Area clone = new Area();
            int i = 0;
            while (i < this.solids.size()) {
                clone.solids.add(this.solids.elementAt(i).cloneSegmentList());
                ++i;
            }
            i = 0;
            while (i < this.holes.size()) {
                clone.holes.add(this.holes.elementAt(i).cloneSegmentList());
                ++i;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public boolean equals(Area area) {
        if (area == null) {
            return false;
        }
        if (!this.getBounds2D().equals(area.getBounds2D())) {
            return false;
        }
        if (this.solids.size() != area.solids.size() || this.holes.size() != area.holes.size()) {
            return false;
        }
        Vector<Segment> pathA = new Vector<Segment>();
        pathA.addAll((Collection<Segment>)this.solids);
        pathA.addAll((Collection<Segment>)this.holes);
        Vector<Segment> pathB = new Vector<Segment>();
        pathB.addAll((Collection<Segment>)area.solids);
        pathB.addAll((Collection<Segment>)area.holes);
        int nPaths = pathA.size();
        boolean[][] match = new boolean[2][nPaths];
        int i = 0;
        while (i < nPaths) {
            int j = 0;
            while (j < nPaths) {
                Segment p1 = (Segment)pathA.elementAt(i);
                Segment p2 = (Segment)pathB.elementAt(j);
                if (!match[0][i] && !match[1][j] && p1.pathEquals(p2)) {
                    match[1][j] = true;
                    match[0][i] = true;
                }
                ++j;
            }
            ++i;
        }
        boolean result = true;
        int i2 = 0;
        while (i2 < nPaths) {
            result = result && match[0][i2] && match[1][i2];
            ++i2;
        }
        return result;
    }

    public void transform(AffineTransform at) {
        int i = 0;
        while (i < this.solids.size()) {
            this.solids.elementAt(i).transformSegmentList(at);
            ++i;
        }
        i = 0;
        while (i < this.holes.size()) {
            this.holes.elementAt(i).transformSegmentList(at);
            ++i;
        }
        if ((at.getType() & 0x40) != 0) {
            this.setDirection(this.holes, false);
            this.setDirection(this.solids, true);
        }
    }

    public Area createTransformedArea(AffineTransform at) {
        Area a = (Area)this.clone();
        a.transform(at);
        return a;
    }

    @Override
    public boolean contains(double x, double y) {
        int n = 0;
        int i = 0;
        while (i < this.solids.size()) {
            if (this.solids.elementAt(i).contains(x, y)) {
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.holes.size()) {
            if (this.holes.elementAt(i).contains(x, y)) {
                --n;
            }
            ++i;
        }
        return n != 0;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        int path;
        LineSegment[] l = new LineSegment[]{new LineSegment(x, y, x + w, y), new LineSegment(x, y + h, x + w, y + h), new LineSegment(x, y, x, y + h), new LineSegment(x + w, y, x + w, y + h)};
        int i = 0;
        while (i < 4) {
            Segment start;
            Segment v;
            path = 0;
            while (path < this.solids.size()) {
                start = v = this.solids.elementAt(path);
                do {
                    if (!l[i].hasIntersections(v)) continue;
                    return false;
                } while ((v = v.next) != start);
                ++path;
            }
            path = 0;
            while (path < this.holes.size()) {
                start = v = this.holes.elementAt(path);
                do {
                    if (!l[i].hasIntersections(v)) continue;
                    return false;
                } while ((v = v.next) != start);
                ++path;
            }
            ++i;
        }
        if (!this.contains(x, y)) {
            return false;
        }
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        path = 0;
        while (path < this.holes.size()) {
            if (!this.holes.elementAt(path).isSegmentOutside(r)) {
                return false;
            }
            ++path;
        }
        return true;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.solids.size() == 0) {
            return false;
        }
        LineSegment[] l = new LineSegment[]{new LineSegment(x, y, x + w, y), new LineSegment(x, y + h, x + w, y + h), new LineSegment(x, y, x, y + h), new LineSegment(x + w, y, x + w, y + h)};
        int i = 0;
        while (i < 4) {
            Segment start;
            Segment v;
            int path = 0;
            while (path < this.solids.size()) {
                start = v = this.solids.elementAt(path);
                do {
                    if (!l[i].hasIntersections(v)) continue;
                    return true;
                } while ((v = v.next) != start);
                ++path;
            }
            path = 0;
            while (path < this.holes.size()) {
                start = v = this.holes.elementAt(path);
                do {
                    if (!l[i].hasIntersections(v)) continue;
                    return true;
                } while ((v = v.next) != start);
                ++path;
            }
            ++i;
        }
        if (this.contains(x + w * 0.5, y + h * 0.5)) {
            return true;
        }
        Point2D p = this.solids.elementAt(0).getMidPoint();
        return new Rectangle2D.Double(x, y, w, h).contains(p);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new AreaIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    private Vector<Segment> weilerAtherton(Vector<Segment> segments) {
        Vector<Segment> paths = new Vector<Segment>();
        while (segments.size() > 0) {
            Segment start;
            Segment s = start = segments.elementAt(0);
            do {
                segments.remove(s);
                if (s.node == null) continue;
                s.next = s.node;
                s.node = null;
            } while ((s = s.next) != start);
            paths.add(start);
        }
        return paths;
    }

    private int getRecursionDepth(CubicSegment curve) {
        double x0 = curve.P1.getX();
        double y0 = curve.P1.getY();
        double x1 = curve.cp1.getX();
        double y1 = curve.cp1.getY();
        double x2 = curve.cp2.getX();
        double y2 = curve.cp2.getY();
        double x3 = curve.P2.getX();
        double y3 = curve.P2.getY();
        double L0 = Math.max(Math.max(Math.abs(x0 - 2.0 * x1 + x2), Math.abs(x1 - 2.0 * x2 + x3)), Math.max(Math.abs(y0 - 2.0 * y1 + y2), Math.abs(y1 - 2.0 * y2 + y3)));
        double f = Math.sqrt(2.0) * 6.0 * L0 / 8.0E-13;
        int r0 = (int)Math.ceil(Math.log(f) / Math.log(4.0));
        return r0;
    }

    private void recursiveSubdivide(CubicCurve2D c1, CubicCurve2D c2, int depth1, int depth2, double t1, double t2, double w1, double w2) {
        boolean flat2;
        boolean flat1 = depth1 <= 0;
        boolean bl = flat2 = depth2 <= 0;
        if (flat1 && flat2) {
            double xlk = c1.getP2().getX() - c1.getP1().getX();
            double ylk = c1.getP2().getY() - c1.getP1().getY();
            double xnm = c2.getP2().getX() - c2.getP1().getX();
            double ynm = c2.getP2().getY() - c2.getP1().getY();
            double xmk = c2.getP1().getX() - c1.getP1().getX();
            double ymk = c2.getP1().getY() - c1.getP1().getY();
            double det = xnm * ylk - ynm * xlk;
            if (det + 1.0 == 1.0) {
                return;
            }
            double detinv = 1.0 / det;
            double s = (xnm * ymk - ynm * xmk) * detinv;
            double t = (xlk * ymk - ylk * xmk) * detinv;
            if (s < 0.0 || s > 1.0 || t < 0.0 || t > 1.0) {
                return;
            }
            double[] temp = new double[]{t1 + s * w1, t2 + t * w1};
            this.ccIntersections.add(temp);
            return;
        }
        CubicCurve2D.Double c11 = new CubicCurve2D.Double();
        CubicCurve2D.Double c12 = new CubicCurve2D.Double();
        CubicCurve2D.Double c21 = new CubicCurve2D.Double();
        CubicCurve2D.Double c22 = new CubicCurve2D.Double();
        if (!flat1 && !flat2) {
            --depth1;
            --depth2;
            w1 *= 0.5;
            w2 *= 0.5;
            c1.subdivide(c11, c12);
            c2.subdivide(c21, c22);
            if (c11.getBounds2D().intersects(c21.getBounds2D())) {
                this.recursiveSubdivide(c11, c21, depth1, depth2, t1, t2, w1, w2);
            }
            if (c11.getBounds2D().intersects(c22.getBounds2D())) {
                this.recursiveSubdivide(c11, c22, depth1, depth2, t1, t2 + w2, w1, w2);
            }
            if (c12.getBounds2D().intersects(c21.getBounds2D())) {
                this.recursiveSubdivide(c12, c21, depth1, depth2, t1 + w1, t2, w1, w2);
            }
            if (c12.getBounds2D().intersects(c22.getBounds2D())) {
                this.recursiveSubdivide(c12, c22, depth1, depth2, t1 + w1, t2 + w2, w1, w2);
            }
            return;
        }
        if (!flat1) {
            --depth1;
            c1.subdivide(c11, c12);
            w1 *= 0.5;
            if (c11.getBounds2D().intersects(c2.getBounds2D())) {
                this.recursiveSubdivide(c11, c2, depth1, depth2, t1, t2, w1, w2);
            }
            if (c12.getBounds2D().intersects(c2.getBounds2D())) {
                this.recursiveSubdivide(c12, c2, depth1, depth2, t1 + w1, t2, w1, w2);
            }
            return;
        }
        --depth2;
        c2.subdivide(c21, c22);
        w2 *= 0.5;
        if (c1.getBounds2D().intersects(c21.getBounds2D())) {
            this.recursiveSubdivide(c1, c21, depth1, depth2, t1, t2, w1, w2);
        }
        if (c1.getBounds2D().intersects(c22.getBounds2D())) {
            this.recursiveSubdivide(c1, c22, depth1, depth2, t1, t2 + w2, w1, w2);
        }
    }

    Intersection[] cubicCubicIntersect(CubicSegment curve1, CubicSegment curve2) {
        Rectangle2D r2;
        Rectangle2D r1 = curve1.getBounds();
        if (!r1.intersects(r2 = curve2.getBounds())) {
            return null;
        }
        this.ccIntersections = new Vector();
        this.recursiveSubdivide(curve1.getCubicCurve2D(), curve2.getCubicCurve2D(), this.getRecursionDepth(curve1), this.getRecursionDepth(curve2), 0.0, 0.0, 1.0, 1.0);
        if (this.ccIntersections.size() == 0) {
            return null;
        }
        Intersection[] results = new Intersection[this.ccIntersections.size()];
        int i = 0;
        while (i < this.ccIntersections.size()) {
            double[] temp = this.ccIntersections.elementAt(i);
            results[i] = new Intersection(curve1.evaluatePoint(temp[0]), temp[0], temp[1]);
            ++i;
        }
        this.ccIntersections = null;
        return results;
    }

    Intersection[] lineQuadIntersect(LineSegment l, QuadSegment c) {
        double k;
        double[] y = new double[3];
        double[] x = new double[3];
        double[] r = new double[3];
        double x0 = c.P1.getX();
        double y0 = c.P1.getY();
        double x1 = c.cp.getX();
        double y1 = c.cp.getY();
        double x2 = c.P2.getX();
        double y2 = c.P2.getY();
        double lx0 = l.P1.getX();
        double ly0 = l.P1.getY();
        double lx1 = l.P2.getX();
        double ly1 = l.P2.getY();
        double dx = lx1 - lx0;
        double dy = ly1 - ly0;
        y[0] = y0;
        y[1] = 2.0 * (y1 - y0);
        y[2] = y2 - 2.0 * y1 + y0;
        x[0] = x0;
        x[1] = 2.0 * (x1 - x0);
        x[2] = x2 - 2.0 * x1 + x0;
        if (dy == 0.0 && dx == 0.0) {
            return null;
        }
        if (dx == 0.0 || dy / dx > 1.0) {
            k = dx / dy;
            x[0] = x[0] - lx0;
            y[0] = y[0] - ly0;
            y[0] = y[0] * k;
            y[1] = y[1] * k;
            y[2] = y[2] * k;
        } else {
            k = dy / dx;
            x[0] = x[0] - lx0;
            y[0] = y[0] - ly0;
            x[0] = x[0] * k;
            x[1] = x[1] * k;
            x[2] = x[2] * k;
        }
        int i = 0;
        while (i < 3) {
            r[i] = y[i] - x[i];
            ++i;
        }
        int nRoots = QuadCurve2D.solveQuadratic(r);
        if (nRoots > 0) {
            Intersection[] temp = new Intersection[nRoots];
            int intersections = 0;
            int i2 = 0;
            while (i2 < nRoots) {
                double t = r[i2];
                if (t >= 0.0 && t <= 1.0) {
                    Point2D p = c.evaluatePoint(t);
                    if (dx == 0.0) {
                        p.setLocation(lx0, p.getY());
                    }
                    if (dy == 0.0) {
                        p.setLocation(p.getX(), ly0);
                    }
                    if (p.getX() <= Math.max(lx0, lx1) && p.getX() >= Math.min(lx0, lx1) && p.getY() <= Math.max(ly0, ly1) && p.getY() >= Math.min(ly0, ly1)) {
                        double lineparameter = p.distance(l.P1) / l.P2.distance(l.P1);
                        temp[i2] = new Intersection(p, lineparameter, t);
                        ++intersections;
                    }
                } else {
                    temp[i2] = null;
                }
                ++i2;
            }
            if (intersections == 0) {
                return null;
            }
            Intersection[] rValues = new Intersection[intersections];
            int i3 = 0;
            while (i3 < nRoots) {
                if (temp[i3] != null) {
                    rValues[--intersections] = temp[i3];
                }
                ++i3;
            }
            return rValues;
        }
        return null;
    }

    Intersection[] lineCubicIntersect(LineSegment l, CubicSegment c) {
        double k;
        double[] y = new double[4];
        double[] x = new double[4];
        double[] r = new double[4];
        double x0 = c.P1.getX();
        double y0 = c.P1.getY();
        double x1 = c.cp1.getX();
        double y1 = c.cp1.getY();
        double x2 = c.cp2.getX();
        double y2 = c.cp2.getY();
        double x3 = c.P2.getX();
        double y3 = c.P2.getY();
        double lx0 = l.P1.getX();
        double ly0 = l.P1.getY();
        double lx1 = l.P2.getX();
        double ly1 = l.P2.getY();
        double dx = lx1 - lx0;
        double dy = ly1 - ly0;
        y[0] = y0;
        y[1] = 3.0 * (y1 - y0);
        y[2] = 3.0 * (y2 + y0 - 2.0 * y1);
        y[3] = y3 - 3.0 * y2 + 3.0 * y1 - y0;
        x[0] = x0;
        x[1] = 3.0 * (x1 - x0);
        x[2] = 3.0 * (x2 + x0 - 2.0 * x1);
        x[3] = x3 - 3.0 * x2 + 3.0 * x1 - x0;
        if (dy == 0.0 && dx == 0.0) {
            return null;
        }
        if (dx == 0.0 || dy / dx > 1.0) {
            k = dx / dy;
            x[0] = x[0] - lx0;
            y[0] = y[0] - ly0;
            y[0] = y[0] * k;
            y[1] = y[1] * k;
            y[2] = y[2] * k;
            y[3] = y[3] * k;
        } else {
            k = dy / dx;
            x[0] = x[0] - lx0;
            y[0] = y[0] - ly0;
            x[0] = x[0] * k;
            x[1] = x[1] * k;
            x[2] = x[2] * k;
            x[3] = x[3] * k;
        }
        int i = 0;
        while (i < 4) {
            r[i] = y[i] - x[i];
            ++i;
        }
        int nRoots = CubicCurve2D.solveCubic(r);
        if (nRoots > 0) {
            Intersection[] temp = new Intersection[nRoots];
            int intersections = 0;
            int i2 = 0;
            while (i2 < nRoots) {
                double t = r[i2];
                if (t >= 0.0 && t <= 1.0) {
                    Point2D p = c.evaluatePoint(t);
                    if (dx == 0.0) {
                        p.setLocation(lx0, p.getY());
                    }
                    if (dy == 0.0) {
                        p.setLocation(p.getX(), ly0);
                    }
                    if (p.getX() <= Math.max(lx0, lx1) && p.getX() >= Math.min(lx0, lx1) && p.getY() <= Math.max(ly0, ly1) && p.getY() >= Math.min(ly0, ly1)) {
                        double lineparameter = p.distance(l.P1) / l.P2.distance(l.P1);
                        temp[i2] = new Intersection(p, lineparameter, t);
                        ++intersections;
                    }
                } else {
                    temp[i2] = null;
                }
                ++i2;
            }
            if (intersections == 0) {
                return null;
            }
            Intersection[] rValues = new Intersection[intersections];
            int i3 = 0;
            while (i3 < nRoots) {
                if (temp[i3] != null) {
                    rValues[--intersections] = temp[i3];
                }
                ++i3;
            }
            return rValues;
        }
        return null;
    }

    Intersection linesIntersect(LineSegment a, LineSegment b) {
        Point2D P1 = a.P1;
        Point2D P2 = a.P2;
        Point2D P3 = b.P1;
        Point2D P4 = b.P2;
        if (!Line2D.linesIntersect(P1.getX(), P1.getY(), P2.getX(), P2.getY(), P3.getX(), P3.getY(), P4.getX(), P4.getY())) {
            return null;
        }
        double x1 = P1.getX();
        double y1 = P1.getY();
        double rx = P2.getX() - x1;
        double ry = P2.getY() - y1;
        double x2 = P3.getX();
        double y2 = P3.getY();
        double sx = P4.getX() - x2;
        double sy = P4.getY() - y2;
        double determinant = sx * ry - sy * rx;
        double nom = sx * (y2 - y1) + sy * (x1 - x2);
        if (Math.abs(determinant) < 1.0E-11) {
            return null;
        }
        if ((nom /= determinant) == 0.0) {
            return null;
        }
        if (nom == 1.0) {
            return null;
        }
        Point2D.Double p = new Point2D.Double(x1 + nom * rx, y1 + nom * ry);
        return new Intersection(p, p.distance(P1) / P1.distance(P2), p.distance(P3) / P3.distance(P4));
    }

    boolean pointEquals(Point2D a, Point2D b) {
        return a.equals(b) || a.distance(b) < 1.0E-11;
    }

    private Vector<Segment> makeSegment(Shape s) {
        Vector<Segment> paths = new Vector<Segment>();
        PathIterator pi = s.getPathIterator(null);
        double[] coords = new double[6];
        Segment subpath = null;
        Segment current = null;
        double subpathy = 0.0;
        double subpathx = 0.0;
        double cy = 0.0;
        double cx = 0.0;
        this.windingRule = pi.getWindingRule();
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (subpath != null) {
                        current = current.next = new LineSegment(cx, cy, subpathx, subpathy);
                        current.next = subpath;
                    }
                    subpath = null;
                    subpathx = cx = coords[0];
                    subpathy = cy = coords[1];
                    break;
                }
                case 4: {
                    if (subpath != null && (subpathx != cx || subpathy != cy)) {
                        current = current.next = new LineSegment(cx, cy, subpathx, subpathy);
                        current.next = subpath;
                        cx = subpathx;
                        cy = subpathy;
                        subpath = null;
                        break;
                    }
                    if (subpath == null) break;
                    current.next = subpath;
                    subpath = null;
                    break;
                }
                case 1: {
                    if (cx == coords[0] && cy == coords[1]) break;
                    Segment v = new LineSegment(cx, cy, coords[0], coords[1]);
                    if (subpath == null) {
                        current = v;
                        subpath = current;
                        paths.add(subpath);
                    } else {
                        current = current.next = v;
                    }
                    cx = coords[0];
                    cy = coords[1];
                    break;
                }
                case 2: {
                    Segment v = new QuadSegment(cx, cy, coords[0], coords[1], coords[2], coords[3]);
                    if (subpath == null) {
                        current = v;
                        subpath = current;
                        paths.add(subpath);
                    } else {
                        current = current.next = v;
                    }
                    cx = coords[2];
                    cy = coords[3];
                    break;
                }
                case 3: {
                    Segment v = new CubicSegment(cx, cy, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    if (subpath == null) {
                        current = v;
                        subpath = current;
                        paths.add(subpath);
                    } else {
                        current = current.next = v;
                    }
                    double[] lpts = ((CubicSegment)v).getLoop();
                    if (lpts != null) {
                        v.subdivideInsert(lpts[0]);
                        v.next.subdivideInsert((lpts[1] - lpts[0]) / (1.0 - lpts[0]));
                        CubicSegment loop = (CubicSegment)v.next;
                        v.next = loop.next;
                        loop.next = loop;
                        v.next.P1 = loop.P2 = loop.P1;
                        v.P2 = loop.P2;
                        paths.add(loop);
                        current = v.next;
                    }
                    cx = coords[4];
                    cy = coords[5];
                }
            }
            pi.next();
        }
        if (subpath != null) {
            if (subpathx != cx || subpathy != cy) {
                current = current.next = new LineSegment(cx, cy, subpathx, subpathy);
                current.next = subpath;
            } else {
                current.next = subpath;
            }
        }
        if (paths.size() == 0) {
            return null;
        }
        return paths;
    }

    private int createNodes(Segment A, Segment B) {
        int nNodes = 0;
        Segment a = A;
        Segment b = B;
        do {
            nNodes += a.splitIntersections(b);
        } while ((b = b.next) != B || (a = a.next) != A);
        return nNodes;
    }

    private int createNodesSelf(Segment A) {
        int nNodes = 0;
        Segment a = A;
        if (A.next == A) {
            return 0;
        }
        do {
            Segment b = a.next;
            do {
                if (b == a) continue;
                nNodes += a.splitIntersections(b);
            } while ((b = b.next) != A);
        } while ((a = a.next) != A);
        return nNodes;
    }

    private void deleteRedundantPaths(Vector<Segment> paths) {
        int i;
        int npaths = paths.size();
        int[][] contains = new int[npaths][npaths];
        int[][] windingNumbers = new int[npaths][2];
        Rectangle2D[] bb = new Rectangle2D[npaths];
        int neg = this.windingRule == 1 ? -1 : 1;
        int i2 = 0;
        while (i2 < npaths) {
            bb[i2] = paths.elementAt(i2).getPathBounds();
            ++i2;
        }
        i2 = 0;
        while (i2 < npaths) {
            Segment pathA = paths.elementAt(i2);
            pathA.nullNodes();
            int windingA = pathA.hasClockwiseOrientation() ? 1 : neg;
            int j = 0;
            while (j < npaths) {
                if (i2 != j) {
                    Segment pathB = paths.elementAt(j);
                    if (bb[i2].intersects(bb[j])) {
                        Segment s = pathB.next;
                        while (s.P1.getY() == s.P2.getY() && s != pathB) {
                            s = s.next;
                        }
                        Point2D p = s.getMidPoint();
                        if (pathA.contains(p.getX(), p.getY())) {
                            contains[i2][j] = windingA;
                        }
                    } else {
                        contains[i2][j] = 0;
                    }
                } else {
                    contains[i2][j] = windingA;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < npaths) {
            windingNumbers[i2][0] = 0;
            int j = 0;
            while (j < npaths) {
                int[] nArray = windingNumbers[i2];
                nArray[0] = nArray[0] + contains[j][i2];
                ++j;
            }
            windingNumbers[i2][1] = contains[i2][i2];
            ++i2;
        }
        Vector<Segment> solids = new Vector<Segment>();
        Vector<Segment> holes = new Vector<Segment>();
        if (this.windingRule == 1) {
            i = 0;
            while (i < npaths) {
                if (windingNumbers[i][0] == 0) {
                    holes.add(paths.elementAt(i));
                } else if (windingNumbers[i][0] - windingNumbers[i][1] == 0 && Math.abs(windingNumbers[i][0]) == 1) {
                    solids.add(paths.elementAt(i));
                }
                ++i;
            }
        } else {
            this.windingRule = 1;
            i = 0;
            while (i < npaths) {
                if ((windingNumbers[i][0] & 1) == 0) {
                    holes.add(paths.elementAt(i));
                } else if ((windingNumbers[i][0] & 1) == 1) {
                    solids.add(paths.elementAt(i));
                }
                ++i;
            }
        }
        this.setDirection(holes, false);
        this.setDirection(solids, true);
        this.holes = holes;
        this.solids = solids;
    }

    private void setDirection(Vector<Segment> paths, boolean clockwise) {
        int i = 0;
        while (i < paths.size()) {
            Segment v = paths.elementAt(i);
            if (clockwise != v.hasClockwiseOrientation()) {
                v.reverseAll();
            }
            ++i;
        }
    }

    private class AreaIterator
    implements PathIterator {
        private Vector<IteratorSegment> segments;
        private int index;
        private AffineTransform at;

        public AreaIterator(AffineTransform at) {
            this.at = at;
            this.index = 0;
            this.segments = new Vector();
            Vector<Segment> allpaths = new Vector<Segment>();
            allpaths.addAll((Collection<Segment>)Area.this.solids);
            allpaths.addAll((Collection<Segment>)Area.this.holes);
            int i = 0;
            while (i < allpaths.size()) {
                Segment v;
                Segment start = v = (Segment)allpaths.elementAt(i);
                IteratorSegment is = new IteratorSegment();
                is.type = 0;
                is.coords[0] = start.P1.getX();
                is.coords[1] = start.P1.getY();
                this.segments.add(is);
                do {
                    is = new IteratorSegment();
                    is.type = v.pathIteratorFormat(is.coords);
                    this.segments.add(is);
                } while ((v = v.next) != start);
                is = new IteratorSegment();
                is.type = 4;
                this.segments.add(is);
                ++i;
            }
        }

        public int currentSegment(double[] coords) {
            IteratorSegment s = this.segments.elementAt(this.index);
            if (this.at != null) {
                this.at.transform(s.coords, 0, coords, 0, 3);
            } else {
                int i = 0;
                while (i < 6) {
                    coords[i] = s.coords[i];
                    ++i;
                }
            }
            return s.type;
        }

        public int currentSegment(float[] coords) {
            IteratorSegment s = this.segments.elementAt(this.index);
            double[] d = new double[6];
            if (this.at != null) {
                this.at.transform(s.coords, 0, d, 0, 3);
                int i = 0;
                while (i < 6) {
                    coords[i] = (float)d[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 6) {
                    coords[i] = (float)s.coords[i];
                    ++i;
                }
            }
            return s.type;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index >= this.segments.size();
        }

        public void next() {
            ++this.index;
        }

        class IteratorSegment {
            int type;
            double[] coords = new double[6];

            IteratorSegment() {
            }
        }
    }

    private class CubicSegment
    extends Segment {
        Point2D cp1;
        Point2D cp2;

        public CubicSegment(double x1, double y1, double c1x, double c1y, double c2x, double c2y, double x2, double y2) {
            this.P1 = new Point2D.Double(x1, y1);
            this.P2 = new Point2D.Double(x2, y2);
            this.cp1 = new Point2D.Double(c1x, c1y);
            this.cp2 = new Point2D.Double(c2x, c2y);
        }

        public Object clone() {
            return new CubicSegment(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        }

        double curveArea() {
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp1.getX();
            double y1 = this.cp1.getY();
            double x2 = this.cp2.getX();
            double y2 = this.cp2.getY();
            double x3 = this.P2.getX();
            double y3 = this.P2.getY();
            double P = y3 - 3.0 * y2 + 3.0 * y1 - y0;
            double Q = 3.0 * (y2 + y0 - 2.0 * y1);
            double R = 3.0 * (y1 - y0);
            double A = x3 - 3.0 * x2 + 3.0 * x1 - x0;
            double B = 3.0 * (x2 + x0 - 2.0 * x1);
            double C = 3.0 * (x1 - x0);
            double area = (B * P - A * Q) / 5.0 + (C * P - A * R) / 2.0 + (C * Q - B * R) / 3.0;
            return area;
        }

        boolean equals(Segment b) {
            if (!(b instanceof CubicSegment)) {
                return false;
            }
            return this.P1.equals(b.P1) && this.cp1.equals(((CubicSegment)b).cp1) && this.cp2.equals(((CubicSegment)b).cp2) && this.P2.equals(b.P2);
        }

        Point2D evaluatePoint(double t) {
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp1.getX();
            double y1 = this.cp1.getY();
            double x2 = this.cp2.getX();
            double y2 = this.cp2.getY();
            double x3 = this.P2.getX();
            double y3 = this.P2.getY();
            return new Point2D.Double(-(t * t * t) * (x0 - 3.0 * x1 + 3.0 * x2 - x3) + 3.0 * t * t * (x0 - 2.0 * x1 + x2) + 3.0 * t * (x1 - x0) + x0, -(t * t * t) * (y0 - 3.0 * y1 + 3.0 * y2 - y3) + 3.0 * t * t * (y0 - 2.0 * y1 + y2) + 3.0 * t * (y1 - y0) + y0);
        }

        Rectangle2D getBounds() {
            double t;
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp1.getX();
            double y1 = this.cp1.getY();
            double x2 = this.cp2.getX();
            double y2 = this.cp2.getY();
            double x3 = this.P2.getX();
            double y3 = this.P2.getY();
            double[] r = new double[3];
            double xmax = Math.max(x0, x3);
            double ymax = Math.max(y0, y3);
            double xmin = Math.min(x0, x3);
            double ymin = Math.min(y0, y3);
            r[0] = 3.0 * (y1 - y0);
            r[1] = 6.0 * (y2 + y0 - 2.0 * y1);
            r[2] = 3.0 * (y3 - 3.0 * y2 + 3.0 * y1 - y0);
            int n = QuadCurve2D.solveQuadratic(r);
            int i = 0;
            while (i < n) {
                t = r[i];
                if (t > 0.0 && t < 1.0) {
                    double y = this.evaluatePoint(t).getY();
                    ymax = Math.max(y, ymax);
                    ymin = Math.min(y, ymin);
                }
                ++i;
            }
            r[0] = 3.0 * (x1 - x0);
            r[1] = 6.0 * (x2 + x0 - 2.0 * x1);
            r[2] = 3.0 * (x3 - 3.0 * x2 + 3.0 * x1 - x0);
            n = QuadCurve2D.solveQuadratic(r);
            i = 0;
            while (i < n) {
                t = r[i];
                if (t > 0.0 && t < 1.0) {
                    double x = this.evaluatePoint(t).getX();
                    xmax = Math.max(x, xmax);
                    xmin = Math.min(x, xmin);
                }
                ++i;
            }
            return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }

        CubicCurve2D getCubicCurve2D() {
            return new CubicCurve2D.Double(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        }

        double[] getLoop() {
            double k;
            double B;
            double A;
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp1.getX();
            double y1 = this.cp1.getY();
            double x2 = this.cp2.getX();
            double y2 = this.cp2.getY();
            double x3 = this.P2.getX();
            double y3 = this.P2.getY();
            double[] r = new double[4];
            double[] results = new double[2];
            double R = x3 - 3.0 * x2 + 3.0 * x1 - x0;
            double T = y3 - 3.0 * y2 + 3.0 * y1 - y0;
            if (R == 0.0 && T == 0.0) {
                return null;
            }
            if (R != 0.0 && T != 0.0) {
                A = 3.0 * (x2 + x0 - 2.0 * x1) / R;
                B = 3.0 * (x1 - x0) / R;
                double P = 3.0 * (y2 + y0 - 2.0 * y1) / T;
                double Q = 3.0 * (y1 - y0) / T;
                if (A == P || Q == B) {
                    return null;
                }
                k = (Q - B) / (A - P);
            } else if (R == 0.0) {
                k = -(3.0 * (x1 - x0)) / (3.0 * (x2 + x0 - 2.0 * x1));
                A = 3.0 * (y2 + y0 - 2.0 * y1) / T;
                B = 3.0 * (y1 - y0) / T;
            } else {
                k = -(3.0 * (y1 - y0)) / (3.0 * (y2 + y0 - 2.0 * y1));
                A = 3.0 * (x2 + x0 - 2.0 * x1) / R;
                B = 3.0 * (x1 - x0) / R;
            }
            r[0] = -k * k * k - A * k * k - B * k;
            r[1] = 3.0 * k * k + 2.0 * k * A + 2.0 * B;
            r[2] = -3.0 * k;
            r[3] = 2.0;
            int n = CubicCurve2D.solveCubic(r);
            if (n != 3) {
                return null;
            }
            int i = 0;
            while (i < 2) {
                int j = i + 1;
                while (j < 3) {
                    if (r[j] < r[i]) {
                        double t = r[i];
                        r[i] = r[j];
                        r[j] = t;
                    }
                    ++j;
                }
                ++i;
            }
            if (Math.abs(r[0] + r[2] - k) < 1.0E-13 && r[0] >= 0.0 && r[0] <= 1.0 && r[2] >= 0.0 && r[2] <= 1.0 && this.evaluatePoint(r[0]).distance(this.evaluatePoint(r[2])) < 9.999999999999999E-11) {
                results[0] = r[0];
                results[1] = r[2];
                return results;
            }
            return null;
        }

        Point2D getMidPoint() {
            return this.evaluatePoint(0.5);
        }

        int getType() {
            return 3;
        }

        int pathIteratorFormat(double[] coords) {
            coords[0] = this.cp1.getX();
            coords[1] = this.cp1.getY();
            coords[2] = this.cp2.getX();
            coords[3] = this.cp2.getY();
            coords[4] = this.P2.getX();
            coords[5] = this.P2.getY();
            return 3;
        }

        int rayCrossing(double x, double y) {
            double x0 = this.P1.getX() - x;
            double y0 = this.P1.getY() - y;
            double x1 = this.cp1.getX() - x;
            double y1 = this.cp1.getY() - y;
            double x2 = this.cp2.getX() - x;
            double y2 = this.cp2.getY() - y;
            double x3 = this.P2.getX() - x;
            double y3 = this.P2.getY() - y;
            double[] r = new double[4];
            int nCrossings = 0;
            if ((x0 > 0.0 || x1 > 0.0 || x2 > 0.0 || x3 > 0.0) && (y0 * y1 <= 0.0 || y1 * y2 <= 0.0 || y2 * y3 <= 0.0)) {
                if (y0 == 0.0) {
                    y0 -= 1.0E-11;
                }
                if (y3 == 0.0) {
                    y3 -= 1.0E-11;
                }
                r[0] = y0;
                r[1] = 3.0 * (y1 - y0);
                r[2] = 3.0 * (y2 + y0 - 2.0 * y1);
                r[3] = y3 - 3.0 * y2 + 3.0 * y1 - y0;
                int nRoots = CubicCurve2D.solveCubic(r);
                if (nRoots > 0) {
                    int i = 0;
                    while (i < nRoots) {
                        double t;
                        if (r[i] > 0.0 && r[i] < 1.0 && -((t = r[i]) * t * t) * (x0 - 3.0 * x1 + 3.0 * x2 - x3) + 3.0 * t * t * (x0 - 2.0 * x1 + x2) + 3.0 * t * (x1 - x0) + x0 > 0.0) {
                            ++nCrossings;
                        }
                        ++i;
                    }
                }
            }
            return nCrossings;
        }

        void reverseCoords() {
            Point2D p = this.P1;
            this.P1 = this.P2;
            this.P2 = p;
            p = this.cp1;
            this.cp1 = this.cp2;
            this.cp2 = p;
        }

        int splitIntersections(Segment b) {
            if (b instanceof LineSegment) {
                return b.splitIntersections(this);
            }
            Intersection[] x = null;
            if (b instanceof QuadSegment) {
                x = Area.this.cubicCubicIntersect(this, ((QuadSegment)b).getCubicSegment());
            }
            if (b instanceof CubicSegment) {
                x = Area.this.cubicCubicIntersect(this, (CubicSegment)b);
            }
            if (x == null) {
                return 0;
            }
            if (x.length == 1) {
                return this.createNode(b, x[0]);
            }
            return this.createNodes(b, x);
        }

        void subdivideInsert(double t) {
            CubicSegment s = (CubicSegment)this.clone();
            double p1x = (s.cp1.getX() - s.P1.getX()) * t + s.P1.getX();
            double p1y = (s.cp1.getY() - s.P1.getY()) * t + s.P1.getY();
            double px = (s.cp2.getX() - s.cp1.getX()) * t + s.cp1.getX();
            double py = (s.cp2.getY() - s.cp1.getY()) * t + s.cp1.getY();
            s.cp2.setLocation((s.P2.getX() - s.cp2.getX()) * t + s.cp2.getX(), (s.P2.getY() - s.cp2.getY()) * t + s.cp2.getY());
            s.cp1.setLocation((s.cp2.getX() - px) * t + px, (s.cp2.getY() - py) * t + py);
            double p2x = (px - p1x) * t + p1x;
            double p2y = (py - p1y) * t + p1y;
            double p3x = (s.cp1.getX() - p2x) * t + p2x;
            double p3y = (s.cp1.getY() - p2y) * t + p2y;
            s.P1.setLocation(p3x, p3y);
            this.insert(s);
            this.cp1.setLocation(p1x, p1y);
            this.cp2.setLocation(p2x, p2y);
            this.P2 = s.P1;
            this.next.node = this.node;
            this.node = null;
        }

        void transform(AffineTransform at) {
            this.P1 = at.transform(this.P1, null);
            this.P2 = at.transform(this.P2, null);
            this.cp1 = at.transform(this.cp1, null);
            this.cp2 = at.transform(this.cp2, null);
        }
    }

    private class Intersection {
        Point2D p;
        double ta;
        double tb;
        Segment seg;

        public Intersection(Point2D p, double ta, double tb) {
            this.p = p;
            this.ta = ta;
            this.tb = tb;
        }
    }

    private class LineSegment
    extends Segment {
        public LineSegment(double x1, double y1, double x2, double y2) {
            this.P1 = new Point2D.Double(x1, y1);
            this.P2 = new Point2D.Double(x2, y2);
        }

        public LineSegment(Point2D p1, Point2D p2) {
            this.P1 = (Point2D)p1.clone();
            this.P2 = (Point2D)p2.clone();
        }

        public Object clone() {
            return new LineSegment(this.P1, this.P2);
        }

        void transform(AffineTransform at) {
            this.P1 = at.transform(this.P1, null);
            this.P2 = at.transform(this.P2, null);
        }

        void reverseCoords() {
            Point2D p = this.P1;
            this.P1 = this.P2;
            this.P2 = p;
        }

        Point2D getMidPoint() {
            return new Point2D.Double(0.5 * (this.P1.getX() + this.P2.getX()), 0.5 * (this.P1.getY() + this.P2.getY()));
        }

        double curveArea() {
            return 0.0;
        }

        int getType() {
            return 1;
        }

        void subdivideInsert(double t) {
            Point2D.Double p = new Point2D.Double((this.P2.getX() - this.P1.getX()) * t + this.P1.getX(), (this.P2.getY() - this.P1.getY()) * t + this.P1.getY());
            this.insert(new LineSegment(p, this.P2));
            this.P2 = p;
            this.next.node = this.node;
            this.node = null;
        }

        boolean isCoLinear(LineSegment b) {
            double y4;
            double x4;
            double x1 = this.P1.getX();
            double y1 = this.P1.getY();
            double x2 = this.P2.getX();
            double y2 = this.P2.getY();
            double x3 = b.P1.getX();
            double y3 = b.P1.getY();
            if ((y1 - y3) * ((x4 = b.P2.getX()) - x3) - (x1 - x3) * ((y4 = b.P2.getY()) - y3) != 0.0) {
                return false;
            }
            return (x2 - x1) * (y4 - y3) - (y2 - y1) * (x4 - x3) == 0.0;
        }

        Segment lastCoLinear() {
            Segment prev = this;
            Segment v = this.next;
            while (v instanceof LineSegment) {
                if (this.isCoLinear((LineSegment)v)) {
                    prev = v;
                    v = v.next;
                    continue;
                }
                return prev;
            }
            return prev;
        }

        boolean equals(Segment b) {
            if (!(b instanceof LineSegment)) {
                return false;
            }
            Point2D p1 = this.P1;
            Point2D p3 = b.P1;
            if (!p1.equals(p3)) {
                return false;
            }
            Point2D p2 = this.lastCoLinear().P2;
            Point2D p4 = ((LineSegment)b).lastCoLinear().P2;
            return p2.equals(p4);
        }

        int pathIteratorFormat(double[] coords) {
            coords[0] = this.P2.getX();
            coords[1] = this.P2.getY();
            return 1;
        }

        boolean hasIntersections(Segment b) {
            if (b instanceof LineSegment) {
                return Area.this.linesIntersect(this, (LineSegment)b) != null;
            }
            if (b instanceof QuadSegment) {
                return Area.this.lineQuadIntersect(this, (QuadSegment)b) != null;
            }
            if (b instanceof CubicSegment) {
                return Area.this.lineCubicIntersect(this, (CubicSegment)b) != null;
            }
            return false;
        }

        int splitIntersections(Segment b) {
            if (b instanceof LineSegment) {
                Intersection i = Area.this.linesIntersect(this, (LineSegment)b);
                if (i == null) {
                    return 0;
                }
                return this.createNode(b, i);
            }
            Intersection[] x = null;
            if (b instanceof QuadSegment) {
                x = Area.this.lineQuadIntersect(this, (QuadSegment)b);
            }
            if (b instanceof CubicSegment) {
                x = Area.this.lineCubicIntersect(this, (CubicSegment)b);
            }
            if (x == null) {
                return 0;
            }
            if (x.length == 1) {
                return this.createNode(b, x[0]);
            }
            return this.createNodes(b, x);
        }

        Rectangle2D getBounds() {
            return new Rectangle2D.Double(Math.min(this.P1.getX(), this.P2.getX()), Math.min(this.P1.getY(), this.P2.getY()), Math.abs(this.P1.getX() - this.P2.getX()), Math.abs(this.P1.getY() - this.P2.getY()));
        }

        int rayCrossing(double x, double y) {
            double x0 = this.P1.getX() - x;
            double y0 = this.P1.getY() - y;
            double x1 = this.P2.getX() - x;
            double y1 = this.P2.getY() - y;
            if (y0 * y1 > 0.0) {
                return 0;
            }
            if (x0 < 0.0 && x1 < 0.0) {
                return 0;
            }
            if (y0 == 0.0) {
                y0 -= 1.0E-11;
            }
            if (y1 == 0.0) {
                y1 -= 1.0E-11;
            }
            if (Line2D.linesIntersect(x0, y0, x1, y1, 1.0E-11, 0.0, Double.MAX_VALUE, 0.0)) {
                return 1;
            }
            return 0;
        }
    }

    private class QuadSegment
    extends Segment {
        Point2D cp;

        QuadSegment(double x1, double y1, double cx, double cy, double x2, double y2) {
            this.P1 = new Point2D.Double(x1, y1);
            this.P2 = new Point2D.Double(x2, y2);
            this.cp = new Point2D.Double(cx, cy);
        }

        public Object clone() {
            return new QuadSegment(this.P1.getX(), this.P1.getY(), this.cp.getX(), this.cp.getY(), this.P2.getX(), this.P2.getY());
        }

        double curveArea() {
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp.getX();
            double y1 = this.cp.getY();
            double x2 = this.P2.getX();
            double y2 = this.P2.getY();
            double P = y2 - 2.0 * y1 + y0;
            double Q = 2.0 * (y1 - y0);
            double A = x2 - 2.0 * x1 + x0;
            double B = 2.0 * (x1 - x0);
            double area = (B * P - A * Q) / 3.0;
            return area;
        }

        boolean equals(Segment b) {
            if (!(b instanceof QuadSegment)) {
                return false;
            }
            return this.P1.equals(b.P1) && this.cp.equals(((QuadSegment)b).cp) && this.P2.equals(b.P2);
        }

        Point2D evaluatePoint(double t) {
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp.getX();
            double y1 = this.cp.getY();
            double x2 = this.P2.getX();
            double y2 = this.P2.getY();
            return new Point2D.Double(t * t * (x2 - 2.0 * x1 + x0) + 2.0 * t * (x1 - x0) + x0, t * t * (y2 - 2.0 * y1 + y0) + 2.0 * t * (y1 - y0) + y0);
        }

        Rectangle2D getBounds() {
            double t;
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp.getX();
            double y1 = this.cp.getY();
            double x2 = this.P2.getX();
            double y2 = this.P2.getY();
            double xmax = Math.max(x0, x2);
            double ymax = Math.max(y0, y2);
            double xmin = Math.min(x0, x2);
            double ymin = Math.min(y0, y2);
            double r0 = 2.0 * (y1 - y0);
            double r1 = 2.0 * (y2 - 2.0 * y1 + y0);
            if (r1 != 0.0 && (t = -r0 / r1) > 0.0 && t < 1.0) {
                double y = this.evaluatePoint(t).getY();
                ymax = Math.max(y, ymax);
                ymin = Math.min(y, ymin);
            }
            r0 = 2.0 * (x1 - x0);
            r1 = 2.0 * (x2 - 2.0 * x1 + x0);
            if (r1 != 0.0 && (t = -r0 / r1) > 0.0 && t < 1.0) {
                double x = this.evaluatePoint(t).getY();
                xmax = Math.max(x, xmax);
                xmin = Math.min(x, xmin);
            }
            return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }

        CubicSegment getCubicSegment() {
            double x1 = this.P1.getX() + 2.0 * (this.cp.getX() - this.P1.getX()) / 3.0;
            double y1 = this.P1.getY() + 2.0 * (this.cp.getY() - this.P1.getY()) / 3.0;
            double x2 = this.cp.getX() + (this.P2.getX() - this.cp.getX()) / 3.0;
            double y2 = this.cp.getY() + (this.P2.getY() - this.cp.getY()) / 3.0;
            return new CubicSegment(this.P1.getX(), this.P1.getY(), x1, y1, x2, y2, this.P2.getX(), this.P2.getY());
        }

        Point2D getMidPoint() {
            return this.evaluatePoint(0.5);
        }

        int getType() {
            return 2;
        }

        int pathIteratorFormat(double[] coords) {
            coords[0] = this.cp.getX();
            coords[1] = this.cp.getY();
            coords[2] = this.P2.getX();
            coords[3] = this.P2.getY();
            return 2;
        }

        int rayCrossing(double x, double y) {
            double x0 = this.P1.getX() - x;
            double y0 = this.P1.getY() - y;
            double x1 = this.cp.getX() - x;
            double y1 = this.cp.getY() - y;
            double x2 = this.P2.getX() - x;
            double y2 = this.P2.getY() - y;
            double[] r = new double[3];
            int nCrossings = 0;
            if ((x0 > 0.0 || x1 > 0.0 || x2 > 0.0) && (y0 * y1 <= 0.0 || y1 * y2 <= 0.0)) {
                if (y0 == 0.0) {
                    y0 -= 1.0E-11;
                }
                if (y2 == 0.0) {
                    y2 -= 1.0E-11;
                }
                r[0] = y0;
                r[1] = 2.0 * (y1 - y0);
                r[2] = y2 - 2.0 * y1 + y0;
                int nRoots = QuadCurve2D.solveQuadratic(r);
                int i = 0;
                while (i < nRoots) {
                    double t;
                    if (r[i] > 0.0 && r[i] < 1.0 && (t = r[i]) * t * (x2 - 2.0 * x1 + x0) + 2.0 * t * (x1 - x0) + x0 > 0.0) {
                        ++nCrossings;
                    }
                    ++i;
                }
            }
            return nCrossings;
        }

        void reverseCoords() {
            Point2D temp = this.P1;
            this.P1 = this.P2;
            this.P2 = temp;
        }

        int splitIntersections(Segment b) {
            if (b instanceof LineSegment) {
                return b.splitIntersections(this);
            }
            if (b instanceof CubicSegment) {
                return b.splitIntersections(this);
            }
            if (b instanceof QuadSegment) {
                Intersection[] x = Area.this.cubicCubicIntersect(this.getCubicSegment(), ((QuadSegment)b).getCubicSegment());
                if (x == null) {
                    return 0;
                }
                if (x.length == 1) {
                    return this.createNode(b, x[0]);
                }
                return this.createNodes(b, x);
            }
            return 0;
        }

        void subdivideInsert(double t) {
            double x0 = this.P1.getX();
            double y0 = this.P1.getY();
            double x1 = this.cp.getX();
            double y1 = this.cp.getY();
            double x2 = this.P2.getX();
            double y2 = this.P2.getY();
            double p10x = x0 + t * (x1 - x0);
            double p10y = y0 + t * (y1 - y0);
            double p11x = x1 + t * (x2 - x1);
            double p11y = y1 + t * (y2 - y1);
            double p20x = p10x + t * (p11x - p10x);
            double p20y = p10y + t * (p11y - p10y);
            this.insert(new QuadSegment(p20x, p20y, p11x, p11y, x2, y2));
            this.P2 = this.next.P1;
            this.cp.setLocation(p10x, p10y);
            this.next.node = this.node;
            this.node = null;
        }

        void transform(AffineTransform at) {
            this.P1 = at.transform(this.P1, null);
            this.P2 = at.transform(this.P2, null);
            this.cp = at.transform(this.cp, null);
        }
    }

    private abstract class Segment
    implements Cloneable {
        Point2D P1 = null;
        Point2D P2 = null;
        Segment next = null;
        Segment node = null;

        Segment() {
        }

        abstract void reverseCoords();

        abstract Point2D getMidPoint();

        abstract Rectangle2D getBounds();

        abstract void transform(AffineTransform var1);

        abstract int getType();

        abstract int splitIntersections(Segment var1);

        abstract int pathIteratorFormat(double[] var1);

        abstract int rayCrossing(double var1, double var3);

        abstract void subdivideInsert(double var1);

        abstract double curveArea();

        abstract boolean equals(Segment var1);

        boolean contains(double x, double y) {
            Segment v = this;
            int crossings = 0;
            do {
                int n = v.rayCrossing(x, y);
                crossings += n;
            } while ((v = v.next) != this);
            return (crossings & 1) == 1;
        }

        void nullNodes() {
            Segment v = this;
            do {
                v.node = null;
            } while ((v = v.next) != this);
        }

        void transformSegmentList(AffineTransform at) {
            Segment v = this;
            do {
                v.transform(at);
            } while ((v = v.next) != this);
        }

        boolean hasClockwiseOrientation() {
            return this.getSignedArea() > 0.0;
        }

        public Rectangle2D getPathBounds() {
            double ymax;
            double xmax;
            double xmin = xmax = this.P1.getX();
            double ymin = ymax = this.P1.getY();
            Segment v = this;
            do {
                Rectangle2D r = v.getBounds();
                xmin = Math.min(r.getMinX(), xmin);
                ymin = Math.min(r.getMinY(), ymin);
                xmax = Math.max(r.getMaxX(), xmax);
                ymax = Math.max(r.getMaxY(), ymax);
            } while ((v = v.next) != this);
            return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }

        double getSignedArea() {
            double area = 0.0;
            Segment s = this;
            do {
                area += s.curveArea();
                area += s.P1.getX() * s.next.P1.getY() - s.P1.getY() * s.next.P1.getX();
            } while ((s = s.next) != this);
            return area;
        }

        void reverseAll() {
            this.reverseCoords();
            Segment v = this.next;
            Segment former = this;
            while (v != this) {
                v.reverseCoords();
                Segment vnext = v.next;
                v.next = former;
                former = v;
                v = vnext;
            }
            this.next = former;
        }

        void insert(Segment v) {
            Segment n = this.next;
            this.next = v;
            v.next = n;
        }

        boolean isPolygonal() {
            Segment v = this;
            do {
                if (v instanceof LineSegment) continue;
                return false;
            } while ((v = v.next) != this);
            return true;
        }

        Segment cloneSegmentList() throws CloneNotSupportedException {
            Segment clone;
            Vector<Segment> list2 = new Vector<Segment>();
            Segment v = this.next;
            while (v != this) {
                list2.add(v);
                v = v.next;
            }
            v = clone = (Segment)this.clone();
            int i = 0;
            while (i < list2.size()) {
                clone = clone.next = (Segment)((Segment)list2.elementAt(i)).clone();
                ++i;
            }
            clone.next = v;
            return v;
        }

        int createNode(Segment b, Intersection i) {
            Point2D p = i.p;
            if ((Area.this.pointEquals(this.P1, p) || Area.this.pointEquals(this.P2, p)) && (Area.this.pointEquals(b.P1, p) || Area.this.pointEquals(b.P2, p))) {
                return 0;
            }
            this.subdivideInsert(i.ta);
            b.subdivideInsert(i.tb);
            this.P2 = this.next.P1 = i.p;
            b.next.P1 = this.next.P1;
            b.P2 = this.next.P1;
            this.node = b.next;
            b.node = this.next;
            return 1;
        }

        protected int createNodes(Segment b, Intersection[] x) {
            Vector<Intersection> v = new Vector<Intersection>();
            int i = 0;
            while (i < x.length) {
                Point2D p = x[i].p;
                if (!Area.this.pointEquals(this.P1, p) && !Area.this.pointEquals(this.P2, p) || !Area.this.pointEquals(b.P1, p) && !Area.this.pointEquals(b.P2, p)) {
                    v.add(x[i]);
                }
                ++i;
            }
            int nNodes = v.size();
            Intersection[] A = new Intersection[nNodes];
            Intersection[] B = new Intersection[nNodes];
            int i2 = 0;
            while (i2 < nNodes) {
                A[i2] = B[i2] = (Intersection)v.elementAt(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < nNodes - 1) {
                int j = i2 + 1;
                while (j < nNodes) {
                    Intersection swap;
                    if (A[i2].ta > A[j].ta) {
                        swap = A[i2];
                        A[i2] = A[j];
                        A[j] = swap;
                    }
                    if (B[i2].tb > B[j].tb) {
                        swap = B[i2];
                        B[i2] = B[j];
                        B[j] = swap;
                    }
                    ++j;
                }
                ++i2;
            }
            Segment s = this;
            int i3 = 0;
            while (i3 < nNodes) {
                s.subdivideInsert(A[i3].ta);
                int j = i3 + 1;
                while (j < nNodes) {
                    A[j].ta = (A[j].ta - A[i3].ta) / (1.0 - A[i3].ta);
                    ++j;
                }
                A[i3].seg = s;
                s = s.next;
                ++i3;
            }
            s = b;
            i3 = 0;
            while (i3 < nNodes) {
                s.subdivideInsert(B[i3].tb);
                int j = i3 + 1;
                while (j < nNodes) {
                    B[j].tb = (B[j].tb - B[i3].tb) / (1.0 - B[i3].tb);
                    ++j;
                }
                B[i3].seg.node = s.next;
                s.node = B[i3].seg.next;
                s.P2 = s.next.P1 = B[i3].p;
                B[i3].seg.next.P1 = s.next.P1;
                B[i3].seg.P2 = s.next.P1;
                s = s.next;
                ++i3;
            }
            return nNodes;
        }

        boolean pathEquals(Segment B) {
            if (!this.getPathBounds().equals(B.getPathBounds())) {
                return false;
            }
            Segment startA = this.getTopLeft();
            Segment startB = B.getTopLeft();
            Segment a = startA;
            Segment b = startB;
            do {
                if (!a.equals(b)) {
                    return false;
                }
                if (a instanceof LineSegment) {
                    a = ((LineSegment)a).lastCoLinear();
                }
                if (b instanceof LineSegment) {
                    b = ((LineSegment)b).lastCoLinear();
                }
                a = a.next;
                b = b.next;
            } while (a != startA && b != startB);
            return true;
        }

        Segment getTopLeft() {
            Segment v = this;
            Segment tl = this;
            do {
                if (v.P1.getY() < tl.P1.getY()) {
                    tl = v;
                    continue;
                }
                if (v.P1.getY() != tl.P1.getY() || !(v.P1.getX() < tl.P1.getX())) continue;
                tl = v;
            } while ((v = v.next) != this);
            return tl;
        }

        boolean isSegmentOutside(Shape shape) {
            return !shape.contains(this.getMidPoint());
        }
    }
}

