/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TooManyListenersException;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    private static final long serialVersionUID = -8494482757288719206L;
    protected transient ArrayList bcsListeners;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient int serializable;
    protected transient HashMap services;
    private transient HashMap serviceUsers;
    private transient HashMap serviceRequests;
    private transient HashMap serviceLeases;

    public BeanContextServicesSupport() {
    }

    public BeanContextServicesSupport(BeanContextServices peer) {
        super(peer);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale) {
        super(peer, locale);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale, boolean dtime) {
        super(peer, locale, dtime);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale, boolean dtime, boolean visible) {
        super(peer, locale, dtime, visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener listener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(listener)) {
                this.bcsListeners.add(listener);
            }
        }
    }

    public boolean addService(Class serviceClass, BeanContextServiceProvider bcsp) {
        return this.addService(serviceClass, bcsp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean addService(Class serviceClass, BeanContextServiceProvider bcsp, boolean fireEvent) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                if (this.services.containsKey(serviceClass)) {
                    return false;
                }
                this.services.put(serviceClass, this.createBCSSServiceProvider(serviceClass, bcsp));
                if (bcsp instanceof Serializable) {
                    ++this.serializable;
                }
                if (fireEvent) {
                    this.fireServiceAdded(serviceClass);
                }
                return true;
            }
        }
    }

    protected void bcsPreDeserializationHook(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.serializable = ois.readInt();
        int a = 0;
        while (a < this.serializable) {
            BCSSServiceProvider bcsssp = (BCSSServiceProvider)ois.readObject();
            this.addService(bcsssp.getServiceClass(), bcsssp.getServiceProvider());
            ++a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bcsPreSerializationHook(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.serializable);
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            for (BCSSServiceProvider bcsssp : this.services.values()) {
                if (!(bcsssp.getServiceProvider() instanceof Serializable)) continue;
                oos.writeObject(bcsssp);
            }
        }
    }

    protected void childJustRemovedHook(Object child, BeanContextSupport.BCSChild bcsc) {
        if (child instanceof BeanContextChild) {
            BeanContextChild bcchild = (BeanContextChild)child;
            Iterator childServices = ((List)this.serviceUsers.get(bcchild)).iterator();
            while (childServices.hasNext()) {
                this.releaseService(bcchild, this, childServices.next());
            }
            this.serviceUsers.remove(bcchild);
        }
    }

    protected BeanContextSupport.BCSChild createBCSChild(Object targetChild, Object peer) {
        return new BCSSChild(targetChild, peer);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class sc, BeanContextServiceProvider bcsp) {
        return new BCSSServiceProvider(sc, bcsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent bcssae) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            int size = this.bcsListeners.size();
            int i = 0;
            while (i < size) {
                BeanContextServicesListener bcsl = (BeanContextServicesListener)this.bcsListeners.get(i);
                bcsl.serviceAvailable(bcssae);
                ++i;
            }
        }
    }

    protected final void fireServiceAdded(Class serviceClass) {
        this.fireServiceAdded(new BeanContextServiceAvailableEvent(this, serviceClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent event) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            int size = this.bcsListeners.size();
            int i = 0;
            while (i < size) {
                BeanContextServicesListener bcsl = (BeanContextServicesListener)this.bcsListeners.get(i);
                bcsl.serviceRevoked(event);
                ++i;
            }
            List requests = (List)this.serviceRequests.get(event.getServiceClass());
            if (requests != null) {
                for (ServiceRequest r : requests) {
                    r.getListener().serviceRevoked(event);
                }
            }
        }
    }

    protected final void fireServiceRevoked(Class serviceClass, boolean revokeNow) {
        this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, serviceClass, revokeNow));
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.beanContextChildPeer;
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object child) {
        if (child instanceof BeanContextServicesListener) {
            return (BeanContextServicesListener)child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCurrentServiceClasses() {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                return this.services.keySet().iterator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator getCurrentServiceSelectors(Class serviceClass) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                BeanContextServiceProvider bcsp = ((BCSSServiceProvider)this.services.get(serviceClass)).getServiceProvider();
                if (bcsp == null) {
                    return null;
                }
                return bcsp.getCurrentServiceSelectors(this, serviceClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild child, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                Object service;
                BeanContextServiceProvider provider = ((BCSSServiceProvider)this.services.get(serviceClass)).getServiceProvider();
                if (provider != null) {
                    service = provider.getService(this, requestor, serviceClass, serviceSelector);
                    ArrayList<Class> childServices = (ArrayList<Class>)this.serviceUsers.get(child);
                    if (childServices == null) {
                        childServices = new ArrayList<Class>();
                        this.serviceUsers.put(child, childServices);
                    }
                    childServices.add(serviceClass);
                } else {
                    BeanContextServices peer = this.getBeanContextServicesPeer();
                    service = peer != null ? peer.getService(child, requestor, serviceClass, serviceSelector, bcsrl) : null;
                }
                if (service != null) {
                    ServiceRequest request = new ServiceRequest(requestor, bcsrl);
                    HashSet requests = (HashSet)this.serviceRequests.get(serviceClass);
                    if (requests == null) {
                        requests = new HashSet();
                        this.serviceRequests.put(serviceClass, requests);
                    }
                    requests.add(request);
                    ServiceLease lease = new ServiceLease(requestor, service);
                    this.serviceLeases.put(lease, provider);
                }
                return service;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(Class serviceClass) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                return this.services.containsKey(serviceClass);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.bcsListeners = new ArrayList();
        this.services = new HashMap();
        this.serviceUsers = new HashMap();
        this.serviceRequests = new HashMap();
        this.serviceLeases = new HashMap();
    }

    protected void initializeBeanContextResources() {
    }

    protected void releaseBeanContextResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseService(BeanContextChild child, Object requestor, Object service) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                ServiceLease lease = new ServiceLease(requestor, service);
                BeanContextServiceProvider provider = (BeanContextServiceProvider)this.serviceLeases.get(lease);
                if (provider != null) {
                    provider.releaseService(this, requestor, service);
                } else {
                    BeanContextServices peer = this.getBeanContextServicesPeer();
                    if (peer != null) {
                        peer.releaseService(child, requestor, service);
                    }
                }
                this.serviceLeases.remove(lease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener listener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeService(Class serviceClass, BeanContextServiceProvider bcsp, boolean revokeCurrentServicesNow) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                this.fireServiceRevoked(serviceClass, revokeCurrentServicesNow);
                this.services.remove(serviceClass);
                if (bcsp instanceof Serializable) {
                    --this.serializable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAvailable(BeanContextServiceAvailableEvent bcssae) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            Class klass = bcssae.getServiceClass();
            if (this.services.containsKey(klass)) {
                return;
            }
            Iterator it = this.bcsChildren();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof BeanContextServices)) continue;
                ((BeanContextServices)obj).serviceAvailable(bcssae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRevoked(BeanContextServiceRevokedEvent bcssre) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            Class klass = bcssre.getServiceClass();
            if (this.services.containsKey(klass)) {
                return;
            }
            Iterator it = this.bcsChildren();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof BeanContextServices)) continue;
                ((BeanContextServices)obj).serviceRevoked(bcssre);
            }
        }
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private static final long serialVersionUID = -3263851306889194873L;

        BCSSChild(Object targetChild, Object peer) {
            super(targetChild, peer);
        }
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private static final long serialVersionUID = 7078212910685744490L;
        private BeanContextServiceProvider provider;

        BCSSProxyServiceProvider(BeanContextServiceProvider p) {
            this.provider = p;
        }

        public Iterator getCurrentServiceSelectors(BeanContextServices bcs, Class serviceClass) {
            return this.provider.getCurrentServiceSelectors(bcs, serviceClass);
        }

        public Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector) {
            return this.provider.getService(bcs, requestor, serviceClass, serviceSelector);
        }

        public void releaseService(BeanContextServices bcs, Object requestor, Object service) {
            this.provider.releaseService(bcs, requestor, service);
        }

        public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
            if (this.provider instanceof BeanContextServiceRevokedListener) {
                ((BeanContextServiceRevokedListener)((Object)this.provider)).serviceRevoked(bcsre);
            }
        }
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        private static final long serialVersionUID = 861278251667444782L;
        protected BeanContextServiceProvider serviceProvider;
        private Class serviceClass;

        private BCSSServiceProvider(Class serviceClass, BeanContextServiceProvider provider) {
            this.serviceClass = serviceClass;
            this.serviceProvider = provider;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }

        private Class getServiceClass() {
            return this.serviceClass;
        }
    }

    private static abstract class Request {
        private Object requestor;

        public Request(Object requestor) {
            this.requestor = requestor;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Request) {
                Request req = (Request)obj;
                return req.getRequestor().equals(this.requestor);
            }
            return false;
        }

        public Object getRequestor() {
            return this.requestor;
        }
    }

    private static class ServiceLease
    extends Request {
        private Object service;

        public ServiceLease(Object requestor, Object service) {
            super(requestor);
            this.service = service;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceLease) {
                ServiceLease sl = (ServiceLease)obj;
                return super.equals(obj) && sl.getService().equals(this.service);
            }
            return false;
        }

        public Object getService() {
            return this.service;
        }
    }

    private static class ServiceRequest
    extends Request {
        private BeanContextServiceRevokedListener listener;

        public ServiceRequest(Object requestor, BeanContextServiceRevokedListener listener) {
            super(requestor);
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceRequest) {
                ServiceRequest sr = (ServiceRequest)obj;
                return super.equals(obj) && sr.getListener().equals(this.listener);
            }
            return false;
        }

        public BeanContextServiceRevokedListener getListener() {
            return this.listener;
        }
    }
}

