/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = -5634142046175988380L;
    public static final String BOTTOM = "bottom";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER = "divider";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String LEFT = "left";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final int VERTICAL_SPLIT = 0;
    protected boolean continuousLayout;
    protected boolean oneTouchExpandable = false;
    protected int dividerSize = 10;
    protected int lastDividerLocation;
    protected int orientation;
    protected Component leftComponent;
    protected Component rightComponent;
    private int dividerLocation;
    private transient double resizeWeight;
    private boolean clientDividerSizeSet = false;
    private boolean clientOneTouchExpandableSet = false;

    public JSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        if (newOrientation != 1 && newOrientation != 0) {
            throw new IllegalArgumentException("orientation is invalid.");
        }
        this.orientation = newOrientation;
        this.continuousLayout = newContinuousLayout;
        this.setLeftComponent(newLeftComponent);
        this.setRightComponent(newRightComponent);
        this.dividerLocation = -1;
        this.updateUI();
    }

    public JSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public JSplitPane(int newOrientation) {
        this(newOrientation, false, null, null);
    }

    public JSplitPane() {
        this(1, false, new JButton("left button"), new JButton("right button"));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null) {
            if (this.leftComponent == null) {
                constraints = LEFT;
            } else if (this.rightComponent == null) {
                constraints = RIGHT;
            }
        }
        if (constraints instanceof String) {
            String placement = (String)constraints;
            if (placement.equals(BOTTOM) || placement.equals(RIGHT)) {
                if (this.rightComponent != null) {
                    this.remove(this.rightComponent);
                }
                this.rightComponent = comp;
            } else if (placement.equals(LEFT) || placement.equals(TOP)) {
                if (this.leftComponent != null) {
                    this.remove(this.leftComponent);
                }
                this.leftComponent = comp;
            } else if (placement.equals(DIVIDER)) {
                constraints = null;
            } else {
                throw new IllegalArgumentException("Constraints is not a known identifier.");
            }
            if (this.getDividerLocation() != -1) {
                this.resetToPreferredSizes();
            }
            super.addImpl(comp, constraints, index);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane();
        }
        return this.accessibleContext;
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public int getMaximumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMaximumDividerLocation(this);
        }
        return -1;
    }

    public int getMinimumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).finishedPaintingChildren(this, g);
        }
    }

    protected String paramString() {
        String superParamStr = "";
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(",continuousLayout=").append(this.isContinuousLayout());
        sb.append(",dividerSize=").append(this.getDividerSize());
        sb.append(",lastDividerLocation=").append(this.getLastDividerLocation());
        sb.append(",oneTouchExpandable=").append(this.isOneTouchExpandable());
        sb.append(",orientation=");
        if (this.orientation == 1) {
            sb.append("HORIZONTAL_SPLIT");
        } else {
            sb.append("VERTICAL_SPLIT");
        }
        return String.valueOf(superParamStr) + sb.toString();
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
    }

    public void remove(int index) {
        Component component = this.getComponent(index);
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(index);
    }

    public void removeAll() {
        this.leftComponent = null;
        this.rightComponent = null;
        super.removeAll();
    }

    public void resetToPreferredSizes() {
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).resetToPreferredSizes(this);
        }
    }

    public void setBottomComponent(Component comp) {
        if (comp != null) {
            this.add(comp, BOTTOM);
        } else {
            this.add((Component)new JButton("right button"), BOTTOM);
        }
    }

    public void setContinuousLayout(boolean newContinuousLayout) {
        if (newContinuousLayout != this.continuousLayout) {
            boolean oldValue = this.continuousLayout;
            this.continuousLayout = newContinuousLayout;
            this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, oldValue, this.continuousLayout);
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (proportionalLocation > 1.0 || proportionalLocation < 0.0) {
            throw new IllegalArgumentException("proportion has to be between 0 and 1.");
        }
        int max = (this.orientation == 1 ? this.getWidth() : this.getHeight()) - this.getDividerSize();
        this.setDividerLocation((int)(proportionalLocation * (double)max));
    }

    public void setDividerLocation(int location) {
        int oldLocation = this.dividerLocation;
        this.dividerLocation = location;
        SplitPaneUI ui = this.getUI();
        if (ui != null) {
            ui.setDividerLocation(this, location);
        }
        this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, oldLocation, location);
    }

    public void setDividerSize(int newSize) {
        this.clientDividerSizeSet = true;
        if (newSize != this.dividerSize) {
            int oldSize = this.dividerSize;
            this.dividerSize = newSize;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, oldSize, this.dividerSize);
        }
    }

    public void setLastDividerLocation(int newLastLocation) {
        if (newLastLocation != this.lastDividerLocation) {
            int oldValue = this.lastDividerLocation;
            this.lastDividerLocation = newLastLocation;
            this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, oldValue, this.lastDividerLocation);
        }
    }

    public void setLeftComponent(Component comp) {
        if (comp != null) {
            this.add(comp, LEFT);
        } else {
            this.remove(this.leftComponent);
        }
    }

    public void setOneTouchExpandable(boolean newValue) {
        this.clientOneTouchExpandableSet = true;
        if (newValue != this.oneTouchExpandable) {
            boolean oldValue = this.oneTouchExpandable;
            this.oneTouchExpandable = newValue;
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, oldValue, this.oneTouchExpandable);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL_SPLIT, HORIZONTAL_SPLIT");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_PROPERTY, oldOrientation, this.orientation);
        }
    }

    public void setResizeWeight(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Value outside permitted range.");
        }
        if (this.resizeWeight != value) {
            double old = this.resizeWeight;
            this.resizeWeight = value;
            this.firePropertyChange(RESIZE_WEIGHT_PROPERTY, old, value);
        }
    }

    public void setRightComponent(Component comp) {
        if (comp != null) {
            this.add(comp, RIGHT);
        } else {
            this.remove(this.rightComponent);
        }
    }

    public void setTopComponent(Component comp) {
        if (comp != null) {
            this.add(comp, TOP);
        } else {
            this.add((Component)new JButton("left button"), TOP);
        }
    }

    public void setUI(SplitPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SplitPaneUI";
    }

    void setUIProperty(String propertyName, Object value) {
        if (propertyName.equals(DIVIDER_SIZE_PROPERTY)) {
            if (!this.clientDividerSizeSet) {
                this.setDividerSize((Integer)value);
                this.clientDividerSizeSet = false;
            }
        } else if (propertyName.equals(ONE_TOUCH_EXPANDABLE_PROPERTY)) {
            if (!this.clientOneTouchExpandableSet) {
                this.setOneTouchExpandable((Boolean)value);
                this.clientOneTouchExpandableSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -1788116871416305366L;

        protected AccessibleJSplitPane() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet result = super.getAccessibleStateSet();
            if (JSplitPane.this.getOrientation() == 1) {
                result.add(AccessibleState.HORIZONTAL);
            } else if (JSplitPane.this.getOrientation() == 0) {
                result.add(AccessibleState.VERTICAL);
            }
            return result;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSplitPane.this.getDividerLocation());
        }

        public boolean setCurrentAccessibleValue(Number value) {
            if (value == null) {
                return false;
            }
            Number oldValue = this.getCurrentAccessibleValue();
            JSplitPane.this.setDividerLocation(value.intValue());
            this.firePropertyChange("AccessibleValue", oldValue, new Integer(value.intValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSplitPane.this.getMinimumDividerLocation());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSplitPane.this.getMaximumDividerLocation());
        }
    }
}

