/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    private String directoryLabel;
    private JComboBox directoryComboBox;
    DirectoryComboBoxModel directoryModel;
    private String fileLabel;
    private JTextField fileTextField;
    private String filterLabel;
    private JPanel topPanel;
    private JPanel controls;
    private JPanel bottomPanel = new JPanel(new GridLayout(3, 2));
    private JPanel buttonPanel = new JPanel();
    private JButton approveButton;
    JList fileList;
    JTable fileTable;
    JPanel fileListPanel;
    JPanel fileTablePanel;
    private FilterComboBoxModel filterModel;
    private ActionMap actionMap;
    boolean listView;
    boolean startEditing;
    JScrollPane scrollPane;
    String save;
    String look;
    JLabel dirLabel;
    ListSelectionListener listSelList;
    MouseListener doubleClickList;
    SingleClickListener singleClickList;
    TableClickListener tableClickList;

    public static ComponentUI createUI(JComponent c) {
        JFileChooser chooser = (JFileChooser)c;
        return new MetalFileChooserUI(chooser);
    }

    public MetalFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.actionMap = this.createActionMap();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.actionMap = null;
    }

    public void installComponents(JFileChooser fc) {
        fc.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout());
        this.dirLabel = new JLabel(this.directoryLabel);
        this.topPanel.add((Component)this.dirLabel, "West");
        this.controls = new JPanel();
        this.addControlButtons();
        JPanel dirPanel = new JPanel(new VerticalMidLayout());
        this.directoryModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox = new JComboBox(this.directoryModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        dirPanel.add(this.directoryComboBox);
        this.topPanel.add(dirPanel);
        this.topPanel.add((Component)this.controls, "East");
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        fc.add((Component)this.topPanel, "North");
        JPanel list2 = this.createList(fc);
        list2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        fc.add((Component)list2, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        this.filterModel = this.createFilterComboBoxModel();
        JComboBox fileFilterCombo = new JComboBox(this.filterModel);
        fileFilterCombo.setRenderer(this.createFilterComboBoxRenderer());
        this.fileTextField = new JTextField();
        JPanel fileNamePanel = new JPanel(new VerticalMidLayout());
        fileNamePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 5));
        fileNamePanel.add(this.fileTextField);
        JPanel row1 = new JPanel(new BorderLayout());
        row1.add((Component)new JLabel(this.fileLabel), "West");
        row1.add(fileNamePanel);
        bottomPanel.add(row1);
        JPanel row2 = new JPanel(new BorderLayout());
        row2.add((Component)new JLabel(this.filterLabel), "West");
        row2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        row2.add(fileFilterCombo);
        bottomPanel.add(row2);
        JPanel buttonPanel = new JPanel(new ButtonLayout());
        this.approveButton = new JButton(this.getApproveSelectionAction());
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        buttonPanel.add(this.approveButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JButton cancelButton = new JButton(this.getCancelSelectionAction());
        cancelButton.setText(this.cancelButtonText);
        cancelButton.setToolTipText(this.cancelButtonToolTipText);
        cancelButton.setMnemonic(this.cancelButtonMnemonic);
        buttonPanel.add(cancelButton);
        bottomPanel.add((Component)buttonPanel, "South");
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        fc.add((Component)bottomPanel, "South");
        fc.add((Component)this.getAccessoryPanel(), "East");
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.remove(this.bottomPanel);
        this.bottomPanel = null;
        fc.remove(this.fileListPanel);
        fc.remove(this.fileTablePanel);
        this.fileTablePanel = null;
        this.fileListPanel = null;
        fc.remove(this.topPanel);
        this.topPanel = null;
        this.directoryModel = null;
        this.fileTextField = null;
        this.directoryComboBox = null;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new GridLayout(3, 2));
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        this.look = "Look In: ";
        this.save = "Save In: ";
        this.directoryLabel = fc.getDialogType() == 1 ? this.save : this.look;
        this.fileLabel = "File Name: ";
        this.filterLabel = "Files of Type: ";
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = "Cancel";
        this.cancelButtonToolTipText = "Abort file chooser dialog";
        this.directoryOpenButtonMnemonic = 0;
        this.directoryOpenButtonText = "Open";
        this.directoryOpenButtonToolTipText = "Open selected directory";
        this.helpButtonMnemonic = 0;
        this.helpButtonText = "Help";
        this.helpButtonToolTipText = "Filechooser help";
        this.openButtonMnemonic = 0;
        this.openButtonText = "Open";
        this.openButtonToolTipText = "Open selected file";
        this.saveButtonMnemonic = 0;
        this.saveButtonText = "Save";
        this.saveButtonToolTipText = "Save selected file";
        this.updateButtonMnemonic = 0;
        this.updateButtonText = "Update";
        this.updateButtonToolTipText = "Update directory listing";
    }

    protected void installListeners(JFileChooser fc) {
        this.directoryComboBox.setAction(new DirectoryComboBoxAction());
        fc.addPropertyChangeListener(this.filterModel);
        this.listSelList = this.createListSelectionListener(fc);
        this.doubleClickList = this.createDoubleClickListener(fc, this.fileList);
        this.singleClickList = new SingleClickListener(this.fileList);
        this.fileList.addListSelectionListener(this.listSelList);
        this.fileList.addMouseListener(this.doubleClickList);
        this.fileList.addMouseListener(this.singleClickList);
        super.installListeners(fc);
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        fc.removePropertyChangeListener(this.filterModel);
        this.directoryComboBox.setAction(null);
        this.fileList.removeListSelectionListener(this.listSelList);
        this.fileList.removeMouseListener(this.doubleClickList);
        this.fileList.removeMouseListener(this.singleClickList);
        if (this.fileTable != null) {
            this.fileTable.removeMouseListener(this.tableClickList);
        }
    }

    protected ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = this.createActionMap();
        }
        return this.actionMap;
    }

    protected ActionMap createActionMap() {
        ActionMap map = new ActionMap();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", this.getCancelSelectionAction());
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        if (this.fileList == null) {
            this.fileListPanel = new JPanel(new BorderLayout());
            this.fileList = new JList(this.getModel());
            this.scrollPane = new JScrollPane(this.fileList);
            this.fileList.setLayoutOrientation(1);
            this.fileList.setCellRenderer(new FileRenderer());
        } else {
            this.fileList.setModel(this.getModel());
            this.fileListPanel.removeAll();
            this.scrollPane.getViewport().setView(this.fileList);
        }
        this.fileListPanel.add(this.scrollPane);
        this.fileListPanel.setPreferredSize(new Dimension(405, 135));
        return this.fileListPanel;
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        this.fileTablePanel = new JPanel(new BorderLayout());
        Object[] cols = new Object[]{"Name", "Size", "Modified"};
        Object[][] rows = new Object[this.fileList.getModel().getSize()][3];
        this.fileTable = new JTable(new DefaultTableModel(rows, cols));
        if (fc.isMultiSelectionEnabled()) {
            this.fileTable.setSelectionMode(2);
        } else {
            this.fileTable.setSelectionMode(0);
        }
        this.fileTable.setShowGrid(false);
        this.fileTable.setColumnSelectionAllowed(false);
        this.fileTable.setDefaultRenderer(Object.class, new TableFileRenderer());
        this.tableClickList = new TableClickListener(this.fileTable, fc);
        this.fileTable.addMouseListener(this.tableClickList);
        return this.updateTable();
    }

    JPanel updateTable() {
        int rc;
        DefaultTableModel mod = (DefaultTableModel)this.fileTable.getModel();
        ListModel lm = this.fileList.getModel();
        DateFormat dt = DateFormat.getDateTimeInstance(3, 3);
        File curr = null;
        int size = lm.getSize();
        int x = rc = mod.getRowCount();
        while (x < size) {
            mod.addRow(new Object[3]);
            ++x;
        }
        int i = 0;
        while (i < size) {
            curr = (File)lm.getElementAt(i);
            this.fileTable.setValueAt(curr.getName(), i, 0);
            this.fileTable.setValueAt(this.formatSize(curr.length()), i, 1);
            this.fileTable.setValueAt(dt.format(new Date(curr.lastModified())), i, 2);
            ++i;
        }
        while (rc > size) {
            mod.removeRow(--rc);
        }
        this.scrollPane.getViewport().setView(this.fileTable);
        this.scrollPane.setColumnHeaderView(this.fileTable.getTableHeader());
        this.fileTablePanel.removeAll();
        this.fileTablePanel.add(this.scrollPane);
        return this.fileTablePanel;
    }

    private String formatSize(long bytes) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        long mb = (long)Math.pow(2.0, 20.0);
        long kb = (long)Math.pow(2.0, 10.0);
        long gb = (long)Math.pow(2.0, 30.0);
        double size = 0.0;
        String id = "";
        if (bytes / gb >= 1L) {
            size = (double)bytes / (double)gb;
            id = "GB";
        } else if (bytes / mb >= 1L) {
            size = (double)bytes / (double)mb;
            id = "MB";
        } else if (bytes / kb >= 1L) {
            size = (double)bytes / (double)kb;
            id = "KB";
        } else {
            size = bytes;
            id = "Bytes";
        }
        return String.valueOf(nf.format(size)) + " " + id;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new MetalFileChooserSelectionListener();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension tp = this.topPanel.getPreferredSize();
        Dimension bp = this.bottomPanel.getPreferredSize();
        Dimension fl = this.fileListPanel.getPreferredSize();
        return new Dimension(fl.width, tp.height + bp.height + fl.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension tp = this.topPanel.getMinimumSize();
        Dimension bp = this.bottomPanel.getMinimumSize();
        Dimension fl = this.fileListPanel.getMinimumSize();
        return new Dimension(fl.width, tp.height + bp.height + fl.height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new MetalFileChooserPropertyChangeListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer(fc);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected void addControlButtons() {
        JButton upButton = new JButton(this.getChangeToParentDirectoryAction());
        upButton.setText(null);
        upButton.setIcon(this.upFolderIcon);
        upButton.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(upButton);
        JButton homeButton = new JButton(this.getGoHomeAction());
        homeButton.setText(null);
        homeButton.setIcon(this.homeFolderIcon);
        homeButton.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(homeButton);
        JButton newFolderButton = new JButton(this.getNewFolderAction());
        newFolderButton.setText(null);
        newFolderButton.setIcon(this.newFolderIcon);
        newFolderButton.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(newFolderButton);
        JToggleButton listButton = new JToggleButton(this.listViewIcon);
        listButton.setMargin(new Insets(0, 0, 0, 0));
        listButton.addActionListener(new ListViewActionListener());
        listButton.setSelected(true);
        this.listView = true;
        this.controls.add(listButton);
        JToggleButton detailButton = new JToggleButton(this.detailsViewIcon);
        detailButton.setMargin(new Insets(0, 0, 0, 0));
        detailButton.addActionListener(new DetailViewActionListener());
        detailButton.setSelected(false);
        this.controls.add(detailButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(listButton);
        buttonGroup.add(detailButton);
    }

    protected void removeControlButtons() {
        this.controls.removeAll();
        this.controls.revalidate();
        this.controls.repaint();
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.directoryModel.setSelectedItem(fc.getCurrentDirectory());
        this.getModel().validateFileCache();
        if (!this.listView) {
            this.updateTable();
        } else {
            this.createList(fc);
        }
    }

    public String getFileName() {
        String result = null;
        if (this.fileTextField != null) {
            result = this.fileTextField.getText();
        }
        return result;
    }

    public void setFileName(String filename) {
        this.fileTextField.setText(filename);
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    class ButtonLayout
    implements LayoutManager {
        static final int GAP = 4;

        ButtonLayout() {
        }

        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            if (count > 0) {
                int maxW = 0;
                int i = 0;
                while (i < count) {
                    Component c = parent.getComponent(i);
                    Dimension prefSize = c.getPreferredSize();
                    maxW = Math.max(prefSize.width, maxW);
                    ++i;
                }
                Insets insets = parent.getInsets();
                int availableH = parent.getHeight() - insets.top - insets.bottom;
                int currentX = parent.getWidth() - insets.right;
                int i2 = count - 1;
                while (i2 >= 0) {
                    Component c = parent.getComponent(i2);
                    Dimension prefSize = c.getPreferredSize();
                    int adj = Math.max(0, (availableH - prefSize.height) / 2);
                    c.setBounds(currentX -= prefSize.width, insets.top + adj, prefSize.width, (int)Math.min(prefSize.getHeight(), (double)availableH));
                    currentX -= 4;
                    --i2;
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int maxW = 0;
            int maxH = 0;
            int count = parent.getComponentCount();
            if (count > 0) {
                int i = 0;
                while (i < count) {
                    Component c = parent.getComponent(i);
                    Dimension d = c.getPreferredSize();
                    maxW = Math.max(d.width, maxW);
                    maxH = Math.max(d.height, maxH);
                    ++i;
                }
            }
            return new Dimension(maxW * count + 4 * (count - 1) + insets.left + insets.right, maxH + insets.top + insets.bottom);
        }

        public void addLayoutComponent(String name, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    class DetailViewActionListener
    implements ActionListener {
        DetailViewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MetalFileChooserUI.this.listView) {
                int[] index = MetalFileChooserUI.this.fileList.getSelectedIndices();
                JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
                MetalFileChooserUI.this.listView = false;
                fc.remove(MetalFileChooserUI.this.fileListPanel);
                if (MetalFileChooserUI.this.fileTable == null) {
                    MetalFileChooserUI.this.createDetailsView(fc);
                } else {
                    MetalFileChooserUI.this.updateTable();
                }
                MetalFileChooserUI.this.fileTable.getSelectionModel().clearSelection();
                if (index.length > 0) {
                    int i = 0;
                    while (i < index.length) {
                        MetalFileChooserUI.this.fileTable.getSelectionModel().addSelectionInterval(index[i], index[i]);
                        ++i;
                    }
                }
                fc.add((Component)MetalFileChooserUI.this.fileTablePanel, "Center");
                fc.revalidate();
                fc.repaint();
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
            fc.setCurrentDirectory((File)MetalFileChooserUI.this.directoryModel.getSelectedItem());
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List items = new ArrayList();
        private int selectedIndex = -1;

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        public int getDepth(int index) {
            return Math.max(index, 0);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.items.clear();
            FileSystemView fsv = MetalFileChooserUI.this.getFileChooser().getFileSystemView();
            File parent = (File)selectedDirectory;
            while (parent != null) {
                this.items.add(0, parent);
                parent = fsv.getParentDirectory(parent);
            }
            this.selectedIndex = this.items.indexOf(selectedDirectory);
            this.fireContentsChanged(this, 0, this.items.size() - 1);
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private IndentIcon indentIcon;

        public DirectoryComboBoxRenderer(JFileChooser fc) {
            this.indentIcon = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(MetalFileChooserUI.this.getFileChooser().getName(file));
            Icon icon = MetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.indentIcon.setIcon(icon);
            int depth = MetalFileChooserUI.this.directoryModel.getDepth(index);
            this.indentIcon.setDepth(depth);
            this.setIcon(this.indentIcon);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FileView v = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
            File f = (File)value;
            if (f != null) {
                this.setText(v.getName(f));
                this.setIcon(v.getIcon(f));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list2.getSelectionBackground());
                this.setForeground(list2.getSelectionForeground());
            } else {
                this.setBackground(list2.getBackground());
                this.setForeground(list2.getForeground());
            }
            this.setEnabled(list2.isEnabled());
            this.setFont(list2.getFont());
            if (cellHasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters = new FileFilter[1];
        private Object selected;

        protected FilterComboBoxModel() {
            this.filters[0] = MetalFileChooserUI.this.getAcceptAllFileFilter(MetalFileChooserUI.this.getFileChooser());
            this.selected = this.filters[0];
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("fileFilterChanged")) {
                JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
                FileFilter[] choosableFilters = fc.getChoosableFileFilters();
                this.filters = choosableFilters;
                this.fireContentsChanged(this, 0, this.filters.length);
                this.selected = e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (e.getPropertyName().equals("ChoosableFileFilterChangedProperty")) {
                JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
                FileFilter[] choosableFilters = fc.getChoosableFileFilters();
                this.filters = choosableFilters;
                this.fireContentsChanged(this, 0, this.filters.length);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                this.selected = filter;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int index) {
            return this.filters[index];
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            this.setText(filter.getDescription());
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        private static final int INDENT = 10;
        private Icon icon;
        private int depth;

        IndentIcon() {
        }

        void setIcon(Icon i) {
            this.icon = i;
        }

        void setDepth(int d) {
            this.depth = d;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x + this.depth * 10, y);
        }
    }

    class ListViewActionListener
    implements ActionListener {
        ListViewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!MetalFileChooserUI.this.listView) {
                int[] index = MetalFileChooserUI.this.fileTable.getSelectedRows();
                MetalFileChooserUI.this.listView = true;
                JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
                fc.remove(MetalFileChooserUI.this.fileTablePanel);
                MetalFileChooserUI.this.createList(fc);
                MetalFileChooserUI.this.fileList.getSelectionModel().clearSelection();
                if (index.length > 0) {
                    int i = 0;
                    while (i < index.length) {
                        MetalFileChooserUI.this.fileList.getSelectionModel().addSelectionInterval(index[i], index[i]);
                        ++i;
                    }
                }
                fc.add((Component)MetalFileChooserUI.this.fileListPanel, "Center");
                fc.revalidate();
                fc.repaint();
            }
        }
    }

    class MetalFileChooserPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            JFileChooser filechooser = MetalFileChooserUI.this.getFileChooser();
            String n = e.getPropertyName();
            if (n.equals("MultiSelectionEnabledChangedProperty")) {
                int mode = -1;
                mode = filechooser.isMultiSelectionEnabled() ? 2 : 0;
                if (MetalFileChooserUI.this.listView) {
                    MetalFileChooserUI.this.fileList.setSelectionMode(mode);
                } else {
                    MetalFileChooserUI.this.fileTable.setSelectionMode(mode);
                }
            } else if (n.equals("SelectedFileChangedProperty")) {
                File file = filechooser.getSelectedFile();
                if (file != null && filechooser.getDialogType() == 1) {
                    if (file.isDirectory() && filechooser.isTraversable(file)) {
                        MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.look;
                        MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                        filechooser.setApproveButtonText(MetalFileChooserUI.this.openButtonText);
                        filechooser.setApproveButtonToolTipText(MetalFileChooserUI.this.openButtonToolTipText);
                    } else if (file.isFile()) {
                        MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.save;
                        MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                        filechooser.setApproveButtonText(MetalFileChooserUI.this.saveButtonText);
                        filechooser.setApproveButtonToolTipText(MetalFileChooserUI.this.saveButtonToolTipText);
                    }
                }
                if (file == null) {
                    MetalFileChooserUI.this.setFileName(null);
                } else if (file.isFile() || filechooser.getFileSelectionMode() != 0) {
                    MetalFileChooserUI.this.setFileName(file.getName());
                }
                int index = -1;
                index = MetalFileChooserUI.this.getModel().indexOf(file);
                if (index >= 0) {
                    if (MetalFileChooserUI.this.listView) {
                        MetalFileChooserUI.this.fileList.setSelectedIndex(index);
                        MetalFileChooserUI.this.fileList.ensureIndexIsVisible(index);
                        MetalFileChooserUI.this.fileList.revalidate();
                        MetalFileChooserUI.this.fileList.repaint();
                    } else {
                        MetalFileChooserUI.this.fileTable.getSelectionModel().addSelectionInterval(index, index);
                        MetalFileChooserUI.this.fileTable.scrollRectToVisible(MetalFileChooserUI.this.fileTable.getCellRect(index, 0, true));
                        MetalFileChooserUI.this.fileTable.revalidate();
                        MetalFileChooserUI.this.fileTable.repaint();
                    }
                }
            } else if (n.equals("directoryChanged")) {
                if (MetalFileChooserUI.this.listView) {
                    MetalFileChooserUI.this.fileList.clearSelection();
                    MetalFileChooserUI.this.fileList.revalidate();
                    MetalFileChooserUI.this.fileList.repaint();
                } else {
                    MetalFileChooserUI.this.fileTable.clearSelection();
                    MetalFileChooserUI.this.fileTable.revalidate();
                    MetalFileChooserUI.this.fileTable.repaint();
                }
                MetalFileChooserUI.this.setDirectorySelected(false);
                File currentDirectory = filechooser.getCurrentDirectory();
                MetalFileChooserUI.this.setDirectory(currentDirectory);
                boolean hasParent = currentDirectory.getParentFile() != null;
                MetalFileChooserUI.this.getChangeToParentDirectoryAction().setEnabled(hasParent);
            } else if (n.equals("ChoosableFileFilterChangedProperty")) {
                MetalFileChooserUI.this.filterModel.propertyChange(e);
            } else if (n.equals("fileFilterChanged")) {
                MetalFileChooserUI.this.filterModel.propertyChange(e);
            } else if (n.equals("DialogTypeChangedProperty") || n.equals("DialogTitleChangedProperty")) {
                Window owner = SwingUtilities.windowForComponent(filechooser);
                if (owner instanceof JDialog) {
                    ((JDialog)owner).setTitle(MetalFileChooserUI.this.getDialogTitle(filechooser));
                }
                MetalFileChooserUI.this.approveButton.setText(MetalFileChooserUI.this.getApproveButtonText(filechooser));
                MetalFileChooserUI.this.approveButton.setToolTipText(MetalFileChooserUI.this.getApproveButtonToolTipText(filechooser));
                MetalFileChooserUI.this.approveButton.setMnemonic(MetalFileChooserUI.this.getApproveButtonMnemonic(filechooser));
            } else if (n.equals("ApproveButtonTextChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setText(MetalFileChooserUI.this.getApproveButtonText(filechooser));
            } else if (n.equals("ApproveButtonToolTipTextChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setToolTipText(MetalFileChooserUI.this.getApproveButtonToolTipText(filechooser));
            } else if (n.equals("ApproveButtonMnemonicChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setMnemonic(MetalFileChooserUI.this.getApproveButtonMnemonic(filechooser));
            } else if (n.equals("ControlButtonsAreShownChangedProperty")) {
                if (filechooser.getControlButtonsAreShown()) {
                    MetalFileChooserUI.this.topPanel.add((Component)MetalFileChooserUI.this.controls, "East");
                } else {
                    MetalFileChooserUI.this.topPanel.remove(MetalFileChooserUI.this.controls);
                }
                MetalFileChooserUI.this.topPanel.revalidate();
                MetalFileChooserUI.this.topPanel.repaint();
                MetalFileChooserUI.this.topPanel.doLayout();
            } else if (n.equals("acceptAllFileFilterUsedChanged")) {
                if (filechooser.isAcceptAllFileFilterUsed()) {
                    filechooser.addChoosableFileFilter(MetalFileChooserUI.this.getAcceptAllFileFilter(filechooser));
                } else {
                    filechooser.removeChoosableFileFilter(MetalFileChooserUI.this.getAcceptAllFileFilter(filechooser));
                }
            } else if (n.equals("AccessoryChangedProperty")) {
                JComponent newval;
                JComponent old = (JComponent)e.getOldValue();
                if (old != null) {
                    MetalFileChooserUI.this.getAccessoryPanel().remove(old);
                }
                if ((newval = (JComponent)e.getNewValue()) != null) {
                    MetalFileChooserUI.this.getAccessoryPanel().add(newval);
                }
            }
            if (n.equals("directoryChanged") || n.equals("fileFilterChanged") || n.equals("FileHidingChanged")) {
                if (MetalFileChooserUI.this.fileTable != null) {
                    MetalFileChooserUI.this.fileTable.removeAll();
                }
                if (MetalFileChooserUI.this.fileList != null) {
                    MetalFileChooserUI.this.fileList.removeAll();
                }
                MetalFileChooserUI.this.startEditing = false;
                if (filechooser.getDialogType() == 1) {
                    MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.save;
                    MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                    filechooser.setApproveButtonText(MetalFileChooserUI.this.saveButtonText);
                    filechooser.setApproveButtonToolTipText(MetalFileChooserUI.this.saveButtonToolTipText);
                }
                MetalFileChooserUI.this.rescanCurrentDirectory(filechooser);
            }
            filechooser.revalidate();
            filechooser.repaint();
        }
    }

    class MetalFileChooserSelectionListener
    implements ListSelectionListener {
        protected MetalFileChooserSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            File f = (File)MetalFileChooserUI.this.fileList.getSelectedValue();
            if (f == null) {
                return;
            }
            JFileChooser filechooser = MetalFileChooserUI.this.getFileChooser();
            if (!filechooser.isTraversable(f)) {
                filechooser.setSelectedFile(f);
            } else {
                filechooser.setSelectedFile(null);
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;
        File editFile;
        JFileChooser fc;
        Object lastSelected;
        JTextField editField;

        public SingleClickListener(JList list2) {
            this.list = list2;
            this.editFile = null;
            this.fc = MetalFileChooserUI.this.getFileChooser();
            this.lastSelected = null;
            MetalFileChooserUI.this.startEditing = false;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && e.getButton() == 1) {
                int index = this.list.locationToIndex(e.getPoint());
                File[] sf = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || sf != null && sf.length <= 1) && index >= 0 && !MetalFileChooserUI.this.startEditing && this.list.isSelectedIndex(index)) {
                    Object tmp = this.list.getModel().getElementAt(index);
                    if (this.lastSelected != null && this.lastSelected.equals(tmp)) {
                        this.editFile(index);
                    }
                    this.lastSelected = tmp;
                } else {
                    this.completeEditing();
                }
            } else {
                this.completeEditing();
            }
        }

        void editFile(int index) {
            Rectangle bounds = this.list.getCellBounds(index, index);
            this.list.scrollRectToVisible(bounds);
            this.editFile = (File)this.list.getModel().getElementAt(index);
            if (this.editFile.canWrite()) {
                MetalFileChooserUI.this.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener());
                Icon icon = MetalFileChooserUI.this.getFileView(this.fc).getIcon(this.editFile);
                if (icon != null) {
                    int padding = icon.getIconWidth() + 4;
                    bounds.x += padding;
                    bounds.width -= padding;
                }
                this.editField.setBounds(bounds);
                this.list.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.list.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                File f;
                String text = this.editField.getText();
                if (text != null && text != "" && !text.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(f = this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), text))) {
                    MetalFileChooserUI.this.rescanCurrentDirectory(this.fc);
                }
                this.list.remove(this.editField);
            }
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.lastSelected = null;
            this.editField = null;
            this.list.repaint();
        }

        class EditingActionListener
        implements ActionListener {
            EditingActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (SingleClickListener.this.editField != null) {
                    SingleClickListener.this.completeEditing();
                }
            }
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        JTable table;
        JFileChooser fc;
        Object lastSelected;
        File editFile;
        JTextField editField;

        public TableClickListener(JTable table, JFileChooser fc) {
            this.table = table;
            this.fc = fc;
            this.lastSelected = MetalFileChooserUI.this.fileList.getSelectedValue();
            MetalFileChooserUI.this.setDirectorySelected(false);
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.editField = null;
        }

        public void mouseClicked(MouseEvent e) {
            int row = this.table.getSelectedRow();
            Object selVal = MetalFileChooserUI.this.fileList.getModel().getElementAt(row);
            if (selVal == null) {
                return;
            }
            FileSystemView fsv = this.fc.getFileSystemView();
            if (e.getClickCount() == 1 && selVal.equals(this.lastSelected) && e.getButton() == 1) {
                File[] sf = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || sf != null && sf.length <= 1) && !MetalFileChooserUI.this.startEditing) {
                    this.editFile = (File)selVal;
                    this.editFile(row);
                }
            } else if (e.getClickCount() >= 2 && selVal.equals(this.lastSelected)) {
                File f;
                if (MetalFileChooserUI.this.startEditing) {
                    this.completeEditing();
                }
                if (this.fc.isTraversable(f = fsv.createFileObject(this.lastSelected.toString()))) {
                    this.fc.setCurrentDirectory(f);
                    this.fc.rescanCurrentDirectory();
                } else {
                    this.fc.setSelectedFile(f);
                    this.fc.approveSelection();
                    this.closeDialog();
                }
            } else {
                if (MetalFileChooserUI.this.startEditing) {
                    this.completeEditing();
                }
                String path = selVal.toString();
                File f = fsv.createFileObject(path);
                this.fc.setSelectedFile(f);
                if (this.fc.isTraversable(f)) {
                    MetalFileChooserUI.this.setDirectorySelected(true);
                    MetalFileChooserUI.this.setDirectory(f);
                } else {
                    MetalFileChooserUI.this.setDirectorySelected(false);
                    MetalFileChooserUI.this.setDirectory(null);
                }
                this.lastSelected = selVal;
                if (f.isFile()) {
                    MetalFileChooserUI.this.setFileName(path.substring(path.lastIndexOf("/") + 1));
                } else if (this.fc.getFileSelectionMode() != 0) {
                    MetalFileChooserUI.this.setFileName(path);
                }
            }
            MetalFileChooserUI.this.fileTable.repaint();
        }

        void editFile(int row) {
            Rectangle bounds = this.table.getCellRect(row, 0, true);
            this.table.scrollRectToVisible(bounds);
            if (this.editFile.canWrite()) {
                MetalFileChooserUI.this.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener());
                bounds.y = row * this.table.getRowHeight();
                this.editField.setBounds(bounds);
                this.table.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.table.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                String text = this.editField.getText();
                if (text != null && text != "" && !text.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), text))) {
                    MetalFileChooserUI.this.rescanCurrentDirectory(this.fc);
                }
                this.table.remove(this.editField);
            }
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.editField = null;
            this.table.repaint();
        }

        public void closeDialog() {
            Window owner = SwingUtilities.windowForComponent(this.fc);
            if (owner instanceof JDialog) {
                ((JDialog)owner).dispose();
            }
        }

        class EditingActionListener
        implements ActionListener {
            EditingActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (TableClickListener.this.editField != null) {
                    TableClickListener.this.completeEditing();
                }
            }
        }
    }

    class TableFileRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                FileView v = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
                ListModel lm = MetalFileChooserUI.this.fileList.getModel();
                if (row < lm.getSize()) {
                    this.setIcon(v.getIcon((File)lm.getElementAt(row)));
                }
            } else {
                this.setIcon(null);
            }
            this.setText(value.toString());
            this.setOpaque(true);
            this.setEnabled(table.isEnabled());
            this.setFont(MetalFileChooserUI.this.fileList.getFont());
            if (MetalFileChooserUI.this.startEditing && column == 0 || !isSelected) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    class VerticalMidLayout
    implements LayoutManager {
        VerticalMidLayout() {
        }

        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            if (count > 0) {
                Insets insets = parent.getInsets();
                Component c = parent.getComponent(0);
                Dimension prefSize = c.getPreferredSize();
                int h = parent.getHeight() - insets.top - insets.bottom;
                int adj = Math.max(0, (h - prefSize.height) / 2);
                c.setBounds(insets.left, insets.top + adj, parent.getWidth() - insets.left - insets.right, (int)Math.min(prefSize.getHeight(), (double)h));
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            if (parent.getComponentCount() > 0) {
                return parent.getComponent(0).getPreferredSize();
            }
            return null;
        }

        public void addLayoutComponent(String name, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

