/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.ArrayList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.SimpleAttributeSet;

public class PlainDocument
extends AbstractDocument {
    private static final long serialVersionUID = 4758290289196893664L;
    public static final String lineLimitAttribute = "lineLimit";
    public static final String tabSizeAttribute = "tabSize";
    private Element rootElement = this.createDefaultRoot();

    public PlainDocument() {
        this(new GapContent());
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
        this.putProperty(tabSizeAttribute, new Integer(8));
    }

    private void reindex() {
        Element[] lines;
        try {
            String str = this.content.getString(0, this.content.length());
            ArrayList<Element> elts = new ArrayList<Element>();
            int j = 0;
            int i = str.indexOf(10, 0);
            while (i != -1) {
                elts.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, j, i + 1));
                j = i + 1;
                i = str.indexOf(10, i + 1);
            }
            if (j < this.content.length()) {
                elts.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, j, this.content.length()));
            }
            lines = new Element[elts.size()];
            i = 0;
            while (i < elts.size()) {
                lines[i] = (Element)elts.get(i);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            lines = new Element[]{this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, 0, 1)};
        }
        ((AbstractDocument.BranchElement)this.rootElement).replace(0, this.rootElement.getElementCount(), lines);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element[] array = new Element[]{this.createLeafElement(root, null, 0, 1)};
        root.replace(0, 0, array);
        return root;
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent event, AttributeSet attributes) {
        String text = null;
        int offset = event.getOffset();
        int length = event.getLength();
        try {
            text = this.getText(offset, length);
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError();
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        boolean hasLineBreak = text.indexOf(10) != -1;
        boolean prevCharIsLineBreak = false;
        try {
            prevCharIsLineBreak = offset > 0 && this.getText(offset - 1, 1).charAt(0) == '\n';
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError();
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        boolean lastCharIsLineBreak = text.charAt(text.length() - 1) == '\n';
        int lineIndex = -1;
        int lineStart = -1;
        int lineEnd = -1;
        Element[] removed = null;
        AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)this.rootElement;
        boolean updateStructure = true;
        if (prevCharIsLineBreak && !lastCharIsLineBreak) {
            lineIndex = root.getElementIndex(offset - 1);
            Element prevLine = root.getElement(lineIndex);
            Element nextLine = root.getElement(lineIndex + 1);
            lineStart = prevLine.getStartOffset();
            lineEnd = nextLine.getEndOffset();
            removed = new Element[]{prevLine, nextLine};
        } else if (hasLineBreak) {
            lineIndex = root.getElementIndex(offset);
            Element line = root.getElement(lineIndex);
            lineStart = line.getStartOffset();
            lineEnd = line.getEndOffset();
            removed = new Element[]{line};
        } else {
            updateStructure = false;
        }
        if (updateStructure) {
            ArrayList<Element> lines = new ArrayList<Element>();
            int len = lineEnd - lineStart;
            try {
                text = this.getText(lineStart, len);
            }
            catch (BadLocationException ex) {
                AssertionError err = new AssertionError();
                ((Throwable)((Object)err)).initCause(ex);
                throw err;
            }
            int prevLineBreak = 0;
            int lineBreak = text.indexOf(10);
            do {
                lines.add(this.createLeafElement(root, null, lineStart + prevLineBreak, lineStart + ++lineBreak));
                prevLineBreak = lineBreak;
                lineBreak = text.indexOf(10, prevLineBreak);
            } while (prevLineBreak < len);
            Element[] added = lines.toArray(new Element[lines.size()]);
            event.addEdit(new AbstractDocument.ElementEdit(root, lineIndex, removed, added));
            root.replace(lineIndex, removed.length, added);
        }
        super.insertUpdate(event, attributes);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent event) {
        super.removeUpdate(event);
        Element[] added = new Element[1];
        int p0 = event.getOffset();
        int i1 = this.rootElement.getElementIndex(p0);
        int i2 = this.rootElement.getElementIndex(p0 + event.getLength());
        if (i1 != i2) {
            Element[] removed = new Element[i2 - i1 + 1];
            int i = i1;
            while (i <= i2) {
                removed[i - i1] = this.rootElement.getElement(i);
                ++i;
            }
            int start = this.rootElement.getElement(i1).getStartOffset();
            int end = this.rootElement.getElement(i2).getEndOffset();
            added[0] = this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, start, end);
            AbstractDocument.ElementEdit e = new AbstractDocument.ElementEdit(this.rootElement, i1, removed, added);
            event.addEdit(e);
            ((AbstractDocument.BranchElement)this.rootElement).replace(i1, i2 - i1 + 1, added);
        }
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public Element getParagraphElement(int pos) {
        Element root = this.getDefaultRootElement();
        return root.getElement(root.getElementIndex(pos));
    }

    public void insertString(int offs, String str, AttributeSet atts) throws BadLocationException {
        String string = str;
        if (str != null && Boolean.TRUE.equals(this.getProperty("filterNewlines"))) {
            string = str.replaceAll("\n", " ");
        }
        super.insertString(offs, string, atts);
    }
}

