/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import java.util.HashMap;
import java.util.Map;
import org.logstash.beats.Batch;

public class Message
implements Comparable<Message> {
    private final int sequence;
    private String identityStream;
    private final Map data;
    private Batch batch;

    public Message(int sequence, Map map) {
        this.sequence = sequence;
        this.data = map;
        this.identityStream = this.extractIdentityStream();
    }

    public int getSequence() {
        return this.sequence;
    }

    public Map getData() {
        return this.data;
    }

    @Override
    public int compareTo(Message o) {
        return Integer.compare(this.getSequence(), o.getSequence());
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch newBatch) {
        this.batch = newBatch;
    }

    public String getIdentityStream() {
        return this.identityStream;
    }

    private String extractIdentityStream() {
        HashMap beatsData = (HashMap)this.getData().get("beat");
        if (beatsData != null) {
            String id = (String)beatsData.get("id");
            String resourceId = (String)beatsData.get("resource_id");
            if (id != null && resourceId != null) {
                return id + "-" + resourceId;
            }
            return (String)beatsData.get("name") + "-" + (String)beatsData.get("source");
        }
        return null;
    }
}

