/*
 * Decompiled with CFR 0.152.
 */
package org.manticore;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

class EntityConverter
extends RubyObject {
    public EntityConverter(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod
    public IRubyObject readEntity(ThreadContext threadContext, IRubyObject iRubyObject, HttpEntity httpEntity, Block block) throws IOException {
        if (block.isGiven()) {
            return this.streamEntity(threadContext, httpEntity, block);
        }
        return this.readWholeEntity(threadContext, httpEntity);
    }

    private IRubyObject readWholeEntity(ThreadContext threadContext, HttpEntity httpEntity) throws IOException {
        ByteList byteList = new ByteList(EntityUtils.toByteArray((HttpEntity)httpEntity), false);
        return RubyString.newStringShared((Ruby)threadContext.getRuntime(), (ByteList)byteList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject streamEntity(ThreadContext threadContext, HttpEntity httpEntity, Block block) throws IOException {
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        String string = EntityUtils.getContentCharSet((HttpEntity)httpEntity);
        int n = (int)httpEntity.getContentLength();
        if (n < 0) {
            n = 4096;
        }
        if (string == null) {
            string = "ISO-8859-1";
        }
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                String string2 = new String(byArray, string);
                block.call(threadContext, (IRubyObject)RubyString.newString((Ruby)threadContext.getRuntime(), (String)string2));
            }
        }
        finally {
            inputStream.close();
        }
        return threadContext.nil;
    }
}

