/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nokogiri.NokogiriService;
import nokogiri.XmlComment;
import nokogiri.XmlDtd;
import nokogiri.XmlElement;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlProcessingInstruction;
import nokogiri.XmlText;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import nokogiri.internals.c14n.CanonicalFilter;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.Canonicalizer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNil;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::Document"}, parent="Nokogiri::XML::Node")
public class XmlDocument
extends XmlNode {
    private NokogiriNamespaceCache nsCache;
    public static final String DTD_RAW_DOCUMENT = "DTD_RAW_DOCUMENT";
    public static final String DTD_INTERNAL_SUBSET = "DTD_INTERNAL_SUBSET";
    public static final String DTD_EXTERNAL_SUBSET = "DTD_EXTERNAL_SUBSET";
    private static final String DOCUMENTBUILDERFACTORY_IMPLE_NAME = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static boolean substituteEntities = false;
    private static boolean loadExternalSubset = false;
    protected IRubyObject encoding = null;
    protected IRubyObject url = null;

    public XmlDocument(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass, XmlDocument.createNewDocument());
    }

    public XmlDocument(Ruby ruby, Document document) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), document);
    }

    public XmlDocument(Ruby ruby, RubyClass rubyClass, Document document) {
        super(ruby, rubyClass, document);
        this.initializeNamespaceCacheIfNecessary();
        this.createAndCacheNamespaces(ruby, document.getDocumentElement());
        this.stabilizeTextContent(document);
        this.setInstanceVariable("@decorators", ruby.getNil());
    }

    public void setDocumentNode(ThreadContext threadContext, Node node) {
        super.setNode(threadContext, node);
        this.initializeNamespaceCacheIfNecessary();
        Ruby ruby = threadContext.getRuntime();
        if (node != null) {
            Document document = (Document)node;
            this.stabilizeTextContent(document);
            this.createAndCacheNamespaces(ruby, document.getDocumentElement());
        }
        this.setInstanceVariable("@decorators", ruby.getNil());
    }

    public void setEncoding(IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
    }

    public IRubyObject getEncoding() {
        return this.encoding;
    }

    protected void stabilizeTextContent(Document document) {
        if (document.getDocumentElement() != null) {
            document.getDocumentElement().getTextContent();
        }
    }

    private void createAndCacheNamespaces(Ruby ruby, Node node) {
        int n;
        Object object;
        if (node == null) {
            return;
        }
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                Attr attr = (Attr)node2;
                String string = attr.getName();
                String string2 = attr.getValue();
                if (!NokogiriHelpers.isNamespace(string)) continue;
                XmlNamespace.createFromAttr(ruby, attr);
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            this.createAndCacheNamespaces(ruby, object.item(n));
        }
    }

    public XmlDocument(Ruby ruby, RubyClass rubyClass, Document document, XmlDocument xmlDocument) {
        super(ruby, rubyClass, document);
        this.nsCache = xmlDocument.getNamespaceCache();
        XmlNamespace xmlNamespace = this.nsCache.getDefault();
        String string = NokogiriHelpers.rubyStringToString(xmlNamespace.href(ruby.getCurrentContext()));
        this.resolveNamespaceIfNecessary(ruby.getCurrentContext(), document.getDocumentElement(), string);
    }

    private void resolveNamespaceIfNecessary(ThreadContext threadContext, Node node, String string) {
        Object object;
        if (node == null) {
            return;
        }
        String string2 = node.getPrefix();
        if (string2 == null) {
            NokogiriHelpers.renameNode(node, string, node.getNodeName());
        } else {
            object = this.nsCache.get(node, string2);
            String string3 = NokogiriHelpers.rubyStringToString(((XmlNamespace)((Object)object)).href(threadContext));
            NokogiriHelpers.renameNode(node, string3, node.getNodeName());
        }
        this.resolveNamespaceIfNecessary(threadContext, node.getNextSibling(), string);
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            this.resolveNamespaceIfNecessary(threadContext, object.item(i), string);
        }
    }

    public NokogiriNamespaceCache getNamespaceCache() {
        return this.nsCache;
    }

    public void initializeNamespaceCacheIfNecessary() {
        if (this.nsCache == null) {
            this.nsCache = new NokogiriNamespaceCache();
        }
    }

    public void setNamespaceCache(NokogiriNamespaceCache nokogiriNamespaceCache) {
        this.nsCache = nokogiriNamespaceCache;
    }

    public Document getDocument() {
        return (Document)this.node;
    }

    @Override
    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name == null) {
            this.name = threadContext.getRuntime().newString("document");
        }
        return this.name;
    }

    public void setUrl(IRubyObject iRubyObject) {
        this.url = iRubyObject;
    }

    protected IRubyObject getUrl() {
        return this.url;
    }

    @JRubyMethod
    public IRubyObject url(ThreadContext threadContext) {
        return this.getUrl();
    }

    public static Document createNewDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance(DOCUMENTBUILDERFACTORY_IMPLE_NAME, NokogiriService.class.getClassLoader());
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument = null;
        try {
            Document document = XmlDocument.createNewDocument();
            if ("Nokogiri::HTML::Document".equals(((RubyClass)iRubyObject).getName())) {
                xmlDocument = (XmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
                xmlDocument.setDocumentNode(threadContext, document);
            } else {
                xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
                xmlDocument.setDocumentNode(threadContext, document);
            }
        }
        catch (Exception exception) {
            throw threadContext.getRuntime().newRuntimeError("couldn't create document: " + exception.toString());
        }
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return xmlDocument;
    }

    @JRubyMethod(required=1, optional=4)
    public IRubyObject create_entity(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newRuntimeError("Could not create entity");
        }
        String string = NokogiriHelpers.rubyStringToString(iRubyObjectArray[0]);
        Element element = this.getOwnerDocument().createElement(string);
        return XmlEntityDecl.create(threadContext, element, iRubyObjectArray);
    }

    @Override
    @JRubyMethod
    public IRubyObject document(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"encoding="})
    public IRubyObject encoding_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
        return this;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext threadContext) {
        if (this.encoding == null || this.encoding.isNil()) {
            this.encoding = this.getDocument().getXmlEncoding() == null ? threadContext.getRuntime().getNil() : threadContext.getRuntime().newString(this.getDocument().getXmlEncoding());
        }
        return this.encoding.isNil() ? this.encoding : this.encoding.asString().encode(threadContext, (IRubyObject)threadContext.getRuntime().newString("UTF-8"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_external_subsets_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        loadExternalSubset = iRubyObject2.isTrue();
        return threadContext.getRuntime().getNil();
    }

    public static IRubyObject newFromData(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)4, (int)4);
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(ruby, iRubyObjectArray[2], iRubyObjectArray[3]);
        xmlDomParserContext.setInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return xmlDomParserContext.parse(threadContext, iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.newFromData(threadContext, iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.newFromData(threadContext, iRubyObject, iRubyObjectArray);
    }

    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.read_memory(threadContext, (IRubyObject)NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Document"), iRubyObjectArray);
    }

    @JRubyMethod(name={"remove_namespaces!"})
    public IRubyObject remove_namespaces(ThreadContext threadContext) {
        this.removeNamespceRecursively(threadContext, this);
        this.nsCache.clear();
        NokogiriHelpers.clearXpathContext(this.getNode());
        return this;
    }

    private void removeNamespceRecursively(ThreadContext threadContext, XmlNode xmlNode) {
        Object object;
        Node node = xmlNode.node;
        if (node.getNodeType() == 1) {
            node.setPrefix(null);
            NokogiriHelpers.renameNode(node, null, node.getLocalName());
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                if (NokogiriHelpers.isNamespace(attr.getNodeName())) {
                    ((Element)node).removeAttributeNode(attr);
                    continue;
                }
                attr.setPrefix(null);
                NokogiriHelpers.renameNode(attr, null, attr.getLocalName());
            }
        }
        object = (XmlNodeSet)xmlNode.children(threadContext);
        for (long i = 0L; i < ((XmlNodeSet)object).length(); ++i) {
            XmlNode xmlNode2 = (XmlNode)((XmlNodeSet)object).slice(threadContext, (IRubyObject)RubyFixnum.newFixnum((Ruby)threadContext.getRuntime(), (long)i));
            this.removeNamespceRecursively(threadContext, xmlNode2);
        }
    }

    @JRubyMethod
    public IRubyObject root(ThreadContext threadContext) {
        Element element = this.getDocument().getDocumentElement();
        try {
            Boolean bl = (Boolean)element.getUserData("NOKOGIRI_VALIDE_ROOT_NODE");
            if (!bl.booleanValue()) {
                return threadContext.getRuntime().getNil();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (element == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), element);
    }

    @JRubyMethod(name={"root="})
    public IRubyObject root_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNil) {
            this.getDocument().getDocumentElement().setUserData("NOKOGIRI_VALIDE_ROOT_NODE", false, null);
            return iRubyObject;
        }
        XmlNode xmlNode = XmlDocument.asXmlNode(threadContext, iRubyObject);
        IRubyObject iRubyObject2 = this.root(threadContext);
        if (iRubyObject2.isNil()) {
            Node node = this.getDocument() == xmlNode.getOwnerDocument() ? xmlNode.node : this.getDocument().importNode(xmlNode.node, true);
            this.add_child_node(threadContext, NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node));
        } else {
            Node node = XmlDocument.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject2).node;
            ((XmlNode)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node)).replace_node(threadContext, (IRubyObject)xmlNode);
        }
        return xmlNode;
    }

    @JRubyMethod
    public IRubyObject version(ThreadContext threadContext) {
        return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), this.getDocument().getXmlVersion());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject substitute_entities_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        substituteEntities = iRubyObject2.isTrue();
        return threadContext.getRuntime().getNil();
    }

    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        Object object = (IRubyObject)this.node.getUserData(DTD_INTERNAL_SUBSET);
        if (object == null) {
            Document document = this.getDocument();
            if (document.getUserData(DTD_RAW_DOCUMENT) != null) {
                object = XmlDtd.newFromInternalSubset(threadContext.getRuntime(), document);
            } else if (document.getDoctype() != null) {
                IRubyObject iRubyObject;
                DocumentType documentType = document.getDoctype();
                IRubyObject iRubyObject2 = iRubyObject = threadContext.getRuntime().getNil();
                IRubyObject iRubyObject3 = iRubyObject;
                if (documentType.getName() != null) {
                    iRubyObject3 = threadContext.getRuntime().newString(documentType.getName());
                }
                if (documentType.getPublicId() != null) {
                    iRubyObject2 = threadContext.getRuntime().newString(documentType.getPublicId());
                }
                if (documentType.getSystemId() != null) {
                    iRubyObject = threadContext.getRuntime().newString(documentType.getSystemId());
                }
                object = XmlDtd.newEmpty(threadContext.getRuntime(), document, iRubyObject3, iRubyObject2, iRubyObject);
            } else {
                object = threadContext.getRuntime().getNil();
            }
            this.setInternalSubset((IRubyObject)object);
        }
        return object;
    }

    public IRubyObject createInternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setInternalSubset((IRubyObject)xmlDtd);
        return xmlDtd;
    }

    protected void setInternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_INTERNAL_SUBSET, iRubyObject, null);
    }

    public IRubyObject getExternalSubset(ThreadContext threadContext) {
        IRubyObject iRubyObject = (IRubyObject)this.node.getUserData(DTD_EXTERNAL_SUBSET);
        if (iRubyObject == null) {
            return threadContext.getRuntime().getNil();
        }
        return iRubyObject;
    }

    public IRubyObject createExternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setExternalSubset((IRubyObject)xmlDtd);
        return xmlDtd;
    }

    protected void setExternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_EXTERNAL_SUBSET, iRubyObject, null);
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        Document document = this.getDocument();
        saveContextVisitor.enter(document);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XmlNode xmlNode;
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 8) {
                xmlNode = (XmlComment)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlComment)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 10) {
                xmlNode = (XmlDtd)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlDtd)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 7) {
                xmlNode = (XmlProcessingInstruction)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlProcessingInstruction)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 3) {
                xmlNode = (XmlText)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlText)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s != 1) continue;
            xmlNode = (XmlElement)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
            ((XmlElement)xmlNode).accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(document);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrapJavaDocument(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Document"));
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"initialize");
        Document document = (Document)iRubyObject2.toJava(Document.class);
        xmlDocument.setDocumentNode(threadContext, document);
        return xmlDocument;
    }

    @JRubyMethod
    public IRubyObject toJavaDocument(ThreadContext threadContext) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)threadContext.getRuntime(), (Object)this.node);
    }

    @JRubyMethod(optional=3)
    public IRubyObject canonicalize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        Integer n = 0;
        String string = null;
        Boolean bl = false;
        if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil()) {
            n = RubyFixnum.fix2int((IRubyObject)iRubyObjectArray[0]);
        }
        if (iRubyObjectArray.length > 1) {
            if (!iRubyObjectArray[1].isNil() && !(iRubyObjectArray[1] instanceof List)) {
                throw threadContext.getRuntime().newTypeError("Expected array");
            }
            if (!iRubyObjectArray[1].isNil()) {
                string = ((RubyArray)iRubyObjectArray[1]).join(threadContext, (IRubyObject)threadContext.getRuntime().newString(" ")).asString().asJavaString();
            }
        }
        if (iRubyObjectArray.length > 2) {
            bl = iRubyObjectArray[2].isTrue();
        }
        String string2 = null;
        switch (n) {
            case 0: {
                if (bl.booleanValue()) {
                    string2 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
                    break;
                }
                string2 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
                break;
            }
            case 1: {
                if (bl.booleanValue()) {
                    string2 = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
                    break;
                }
                string2 = "http://www.w3.org/2001/10/xml-exc-c14n#";
                break;
            }
            case 2: {
                string2 = bl != false ? "http://www.w3.org/2006/12/xml-c14n11#WithComments" : "http://www.w3.org/2006/12/xml-c14n11";
            }
        }
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(string2);
            XmlNode xmlNode = this.getStartingNode(block);
            CanonicalFilter canonicalFilter = new CanonicalFilter(threadContext, block);
            byte[] byArray = string == null ? canonicalizer.canonicalizeSubtree(xmlNode.getNode(), canonicalFilter) : canonicalizer.canonicalizeSubtree(xmlNode.getNode(), string, canonicalFilter);
            String string3 = new String(byArray, "UTF-8");
            return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string3);
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return threadContext.getRuntime().getNil();
    }

    private XmlNode getStartingNode(Block block) {
        if (block.isGiven() && block.getBinding().getSelf() instanceof XmlNode) {
            return (XmlNode)block.getBinding().getSelf();
        }
        return this;
    }

    public void resetNamespaceCache(ThreadContext threadContext) {
        this.nsCache = new NokogiriNamespaceCache();
        this.createAndCacheNamespaces(threadContext.getRuntime(), this.node);
    }
}

