/*
 * Decompiled with CFR 0.152.
 */
package lucee.runtime.util;

import java.io.IOException;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.loader.util.Util;
import lucee.runtime.exp.PageException;
import lucee.runtime.type.Array;
import lucee.runtime.type.Struct;
import lucee.runtime.util.XMLUtilImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class XMLValidator
extends XMLUtilImpl.XMLEntityResolverDefaultHandler {
    private Array warnings;
    private Array errors;
    private Array fatals;
    private boolean hasErrors;
    private String strSchema;

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        return super.resolveEntity(publicID, systemID);
    }

    public XMLValidator(InputSource validator, String strSchema) {
        super(validator);
        this.strSchema = strSchema;
    }

    private void release() {
        this.warnings = null;
        this.errors = null;
        this.fatals = null;
        this.hasErrors = false;
    }

    @Override
    public void warning(SAXParseException spe) {
        this.log(spe, "Warning", this.warnings);
    }

    @Override
    public void error(SAXParseException spe) {
        this.hasErrors = true;
        this.log(spe, "Error", this.errors);
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        this.hasErrors = true;
        this.log(spe, "Fatal Error", this.fatals);
    }

    private void log(SAXParseException spe, String type, Array array) {
        StringBuffer sb = new StringBuffer("[" + type + "] ");
        String id = spe.getSystemId();
        if (!Util.isEmpty(id)) {
            int li = id.lastIndexOf(47);
            if (li != -1) {
                sb.append(id.substring(li + 1));
            } else {
                sb.append(id);
            }
        }
        sb.append(':');
        sb.append(spe.getLineNumber());
        sb.append(':');
        sb.append(spe.getColumnNumber());
        sb.append(": ");
        sb.append(spe.getMessage());
        sb.append(" ");
        array.appendEL(sb.toString());
    }

    public Struct validate(InputSource xml) throws PageException {
        CFMLEngine engine = CFMLEngineFactory.getInstance();
        this.warnings = engine.getCreationUtil().createArray();
        this.errors = engine.getCreationUtil().createArray();
        this.fatals = engine.getCreationUtil().createArray();
        try {
            XMLReader parser = new XMLUtilImpl().createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.setEntityResolver(this);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            if (!Util.isEmpty(this.strSchema)) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.strSchema);
            }
            parser.parse(xml);
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            throw engine.getExceptionUtil().createXMLException(e.getMessage());
        }
        Struct result = engine.getCreationUtil().createStruct();
        result.setEL("warnings", (Object)this.warnings);
        result.setEL("errors", (Object)this.errors);
        result.setEL("fatalerrors", (Object)this.fatals);
        result.setEL("status", (Object)engine.getCastUtil().toBoolean(!this.hasErrors));
        this.release();
        return result;
    }
}

