/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 * 0.0) => 0.0
 * (0.0 * -1.33) => -0.0
 * (0.0 * 0.85000002) => 0.0
 * (-1.33 * 0.0) => -0.0
 * (-1.33 * -1.33) => 1.7689002
 * (-1.33 * 0.85000002) => -1.1305001
 * (0.85000002 * 0.0) => 0.0
 * (0.85000002 * -1.33) => -1.1305001
 * (0.85000002 * 0.85000002) => 0.72250003
 */
#version 120

void main()
{
  float[distance((0.0 * 0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 * -1.33), -0.0) <= 0.0 ? 1 : -1] array1;
  float[distance((0.0 * 0.85000002), 0.0) <= 0.0 ? 1 : -1] array2;
  float[distance((-1.33 * 0.0), -0.0) <= 0.0 ? 1 : -1] array3;
  float[distance((-1.33 * -1.33), 1.7689002) <= 1.7689001e-05 ? 1 : -1] array4;
  float[distance((-1.33 * 0.85000002), -1.1305001) <= 1.1305001e-05 ? 1 : -1] array5;
  float[distance((0.85000002 * 0.0), 0.0) <= 0.0 ? 1 : -1] array6;
  float[distance((0.85000002 * -1.33), -1.1305001) <= 1.1305001e-05 ? 1 : -1] array7;
  float[distance((0.85000002 * 0.85000002), 0.72250003) <= 7.2250004e-06 ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
