/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) * vec2(-0.1, -1.2)) => vec2(0.010000001, 1.4400001)
 * (vec2(-0.1, -1.2) * vec2(-0.41999999, 0.47999999)) => vec2(0.041999999, -0.57600003)
 * (vec2(-0.41999999, 0.47999999) * vec2(-0.1, -1.2)) => vec2(0.041999999, -0.57600003)
 * (vec2(-0.41999999, 0.47999999) * vec2(-0.41999999, 0.47999999)) => vec2(0.17639999, 0.2304)
 */
#version 120

void main()
{
  float[distance((vec2(-0.1, -1.2) * vec2(-0.1, -1.2)), vec2(0.010000001, 1.4400001)) <= 1.4400348e-05 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) * vec2(-0.41999999, 0.47999999)), vec2(0.041999999, -0.57600003)) <= 5.7752923e-06 ? 1 : -1] array1;
  float[distance((vec2(-0.41999999, 0.47999999) * vec2(-0.1, -1.2)), vec2(0.041999999, -0.57600003)) <= 5.7752923e-06 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) * vec2(-0.41999999, 0.47999999)), vec2(0.17639999, 0.2304)) <= 2.9017428e-06 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
