/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) - vec2(-0.1, -1.2)) => vec2(0.0, 0.0)
 * (vec2(-0.1, -1.2) - vec2(-0.41999999, 0.47999999)) => vec2(0.31999999, -1.6800001)
 * (vec2(-0.41999999, 0.47999999) - vec2(-0.1, -1.2)) => vec2(-0.31999999, 1.6800001)
 * (vec2(-0.41999999, 0.47999999) - vec2(-0.41999999, 0.47999999)) => vec2(0.0, 0.0)
 */
#version 120

void main()
{
  float[distance((vec2(-0.1, -1.2) - vec2(-0.1, -1.2)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) - vec2(-0.41999999, 0.47999999)), vec2(0.31999999, -1.6800001)) <= 1.7102047e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.41999999, 0.47999999) - vec2(-0.1, -1.2)), vec2(-0.31999999, 1.6800001)) <= 1.7102047e-05 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) - vec2(-0.41999999, 0.47999999)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
