/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * distance(0.0, 0.0) => 0.0
 * distance(0.0, -1.33) => 1.33
 * distance(0.0, 0.85000002) => 0.85000002
 * distance(-1.33, 0.0) => 1.33
 * distance(-1.33, -1.33) => 0.0
 * distance(-1.33, 0.85000002) => 2.1800001
 * distance(0.85000002, 0.0) => 0.85000002
 * distance(0.85000002, -1.33) => 2.1800001
 * distance(0.85000002, 0.85000002) => 0.0
 */
#version 150

void main()
{
  float[0.0 <= distance(0.0, 0.0) && distance(0.0, 0.0) <= 0.0 ? 1 : -1] array0;
  float[1.32998669147 <= distance(0.0, -1.33) && distance(0.0, -1.33) <= 1.33001339436 ? 1 : -1] array1;
  float[0.849991500378 <= distance(0.0, 0.85000002) && distance(0.0, 0.85000002) <= 0.850008547306 ? 1 : -1] array2;
  float[1.32998669147 <= distance(-1.33, 0.0) && distance(-1.33, 0.0) <= 1.33001339436 ? 1 : -1] array3;
  float[0.0 <= distance(-1.33, -1.33) && distance(-1.33, -1.33) <= 0.0 ? 1 : -1] array4;
  float[2.17997837067 <= distance(-1.33, 0.85000002) && distance(-1.33, 0.85000002) <= 2.18002176285 ? 1 : -1] array5;
  float[0.849991500378 <= distance(0.85000002, 0.0) && distance(0.85000002, 0.0) <= 0.850008547306 ? 1 : -1] array6;
  float[2.17997837067 <= distance(0.85000002, -1.33) && distance(0.85000002, -1.33) <= 2.18002176285 ? 1 : -1] array7;
  float[0.0 <= distance(0.85000002, 0.85000002) && distance(0.85000002, 0.85000002) <= 0.0 ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
