/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.document.Document;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class NewBaseCalendarDialog
extends AbstractDialog {
    JTextField name;
    JRadioButton createNewBase;
    JRadioButton makeACopy;
    JComboBox calendarToCopy;
    ButtonGroup options;
    Document document;
    WorkingCalendar newCalendar = null;

    public static NewBaseCalendarDialog getInstance(Frame frame, Document document) {
        return new NewBaseCalendarDialog(frame, document);
    }

    private NewBaseCalendarDialog(Frame frame, Document document) {
        super(frame, Messages.getString("NewBaseCalendarDialog.NewBaseCalendar"), true);
        this.document = document;
        this.addDocHelp("New_Base_Calendar");
    }

    protected void initControls() {
        this.name = new JTextField();
        this.createNewBase = new JRadioButton(Messages.getString("NewBaseCalendarDialog.CreateANewBaseCalendar"));
        this.makeACopy = new JRadioButton(Messages.getString("NewBaseCalendarDialog.CreateACopyOfCalendar"));
        this.calendarToCopy = new JComboBox();
        this.calendarToCopy.setEnabled(false);
        this.options = new ButtonGroup();
        this.options.add(this.createNewBase);
        this.options.add(this.makeACopy);
        this.createNewBase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewBaseCalendarDialog.this.calendarToCopy.setEnabled(false);
            }
        });
        this.makeACopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewBaseCalendarDialog.this.calendarToCopy.setEnabled(true);
            }
        });
        this.createNewBase.setSelected(true);
        this.bind(true);
    }

    protected boolean bind(boolean bl) {
        CalendarService calendarService = CalendarService.getInstance();
        if (bl) {
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(calendarService.getBaseCalendars().toArray());
            this.calendarToCopy.setModel(defaultComboBoxModel);
        } else {
            WorkingCalendar workingCalendar = this.makeACopy.isSelected() ? (WorkingCalendar)this.calendarToCopy.getSelectedItem() : CalendarService.getInstance().getDefaultInstance();
            this.newCalendar = CalendarService.getInstance().makeScratchCopy(workingCalendar);
            this.newCalendar.setName(this.name.getText());
            calendarService.add(this.newCalendar);
        }
        return super.bind(bl);
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("p, 3dlu, 100dlu", "p, 3dlu,p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("NewBaseCalendarDialog.Name"), (Component)this.name);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createNewBase);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.makeACopy);
        defaultFormBuilder.append(this.calendarToCopy);
        return defaultFormBuilder.getPanel();
    }

    public final WorkingCalendar getNewCalendar() {
        return this.newCalendar;
    }
}

