/*
 * Decompiled with CFR 0.152.
 */
package com.projity.document;

import com.projity.document.ObjectEvent;
import com.projity.field.Field;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.task.NormalTask;
import com.projity.undo.NodeUndoInfo;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class ObjectEventManager {
    protected EventListenerList listenerList = new EventListenerList();

    public void addListener(ObjectEvent.Listener listener) {
        this.listenerList.add(ObjectEvent.Listener.class, listener);
    }

    public void removeListener(ObjectEvent.Listener listener) {
        this.listenerList.remove(ObjectEvent.Listener.class, listener);
    }

    public void fireCreateEvent(Object object, Object object2) {
        this.fire(object, object2, 1, null);
    }

    public void fireCreateEvent(Object object, Object object2, NodeUndoInfo nodeUndoInfo) {
        this.fire(object, object2, 1, nodeUndoInfo);
    }

    public void fireDeleteEvent(Object object, Object object2) {
        this.fire(object, object2, -1, null);
    }

    public void fireDeleteEvent(Object object, Object object2, NodeUndoInfo nodeUndoInfo) {
        this.fire(object, object2, -1, nodeUndoInfo);
    }

    public void fireUpdateEvent(Object object, Object object2) {
        this.fire(object, object2, 0, null);
    }

    public void fireUpdateEvent(Object object, Object object2, NodeUndoInfo nodeUndoInfo) {
        this.fire(object, object2, 0, nodeUndoInfo);
    }

    public void fireUpdateEvent(Object object, Object object2, Field field) {
        ObjectEvent objectEvent = ObjectEvent.getInstance(object, object2, 0, null);
        objectEvent.setField(field);
        this.fire(objectEvent);
        if (object2 instanceof NormalTask && field.isApplicable(Assignment.class)) {
            Iterator iterator = ((NormalTask)object2).getAssignments().iterator();
            while (iterator.hasNext()) {
                this.fireUpdateEvent(object, iterator.next(), field);
            }
        }
    }

    private void fire(Object object, Object object2, int n, NodeUndoInfo nodeUndoInfo) {
        ObjectEvent objectEvent = ObjectEvent.getInstance(object, object2, n, nodeUndoInfo);
        this.fire(objectEvent);
    }

    public void fire(ObjectEvent objectEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ObjectEvent.Listener.class) continue;
            ((ObjectEvent.Listener)objectArray[i + 1]).objectChanged(objectEvent);
        }
        objectEvent.recycle();
    }
}

