/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class OutlineCode
extends Format {
    static final int NUMBERS = 0;
    static final int UPPERCASE_LETTERS = 1;
    static final int LOWERCASE_LETTERS = 2;
    static final int CHARACTERS = 3;
    private static final int ANY_LENGTH = 0;
    private ArrayList masks = new ArrayList();
    private transient Pattern pattern = null;

    public Object parseObject(String string, ParsePosition parsePosition) {
        Object var3_3 = null;
        Iterator iterator = this.masks.iterator();
        String string2 = string.substring(parsePosition.getIndex());
        Matcher matcher = this.pattern.matcher(string2);
        if (matcher.matches()) {
            parsePosition.setIndex(parsePosition.getIndex() + matcher.end());
            return string2;
        }
        return null;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return null;
    }

    public boolean isValid(String string) {
        try {
            this.parseObject(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public void addMask(Mask mask) {
        this.masks.add(mask);
        this.rebuildPattern();
    }

    private void rebuildPattern() {
        Iterator iterator = this.masks.iterator();
        this.pattern = Pattern.compile(this.getPattern(iterator, ""));
    }

    private String getPattern(Iterator iterator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Mask mask = (Mask)iterator.next();
        stringBuffer.append(mask.getPattern(string));
        if (iterator.hasNext()) {
            stringBuffer.append("(?:" + this.getPattern(iterator, mask.getSeparatorRegex()) + ")?");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        OutlineCode outlineCode = new OutlineCode();
        outlineCode.addMask(new Mask(0, 0, "."));
        outlineCode.addMask(new Mask(1, 2, "."));
        outlineCode.addMask(new Mask(2, 0, "."));
        boolean bl = outlineCode.isValid("12.AA.a");
        bl = outlineCode.isValid("22212.AA.absdf");
        bl = outlineCode.isValid("1");
        bl = outlineCode.isValid("12.AA");
        bl = outlineCode.isValid("12.");
        bl = outlineCode.isValid(".AA");
        bl = outlineCode.isValid("A2");
        bl = outlineCode.isValid("132");
        bl = outlineCode.isValid("12.11");
        bl = outlineCode.isValid("12.AA.");
    }

    public static class Mask {
        static final int NUMBERS = 0;
        static final int UPPERCASE_LETTERS = 1;
        static final int LOWERCASE_LETTERS = 2;
        static final int CHARACTERS = 3;
        private static final int ANY_LENGTH = 0;
        int type = 0;
        int length;
        String separator;

        StringBuffer getPattern(String string) {
            StringBuffer stringBuffer = new StringBuffer("(");
            stringBuffer.append(string);
            switch (this.type) {
                case 0: {
                    stringBuffer.append("\\d");
                    break;
                }
                case 1: {
                    stringBuffer.append("[A-Z]");
                    break;
                }
                case 2: {
                    stringBuffer.append("[a-z]");
                    break;
                }
                case 3: {
                    stringBuffer.append("[^" + this.separator + "]");
                }
            }
            if (this.length == 0) {
                stringBuffer.append("+");
            } else {
                stringBuffer.append("{" + this.length + "}");
            }
            stringBuffer.append(")");
            return stringBuffer;
        }

        String nextValue(String string) {
            String string2 = string;
            switch (this.type) {
                case 0: {
                    int n = Integer.parseInt(string) + 1;
                    string2 = this.length == 0 ? "" + n : new DecimalFormat(StringUtils.repeat("0", this.length)).format(Integer.getInteger(string));
                }
            }
            return string2;
        }

        public Mask() {
        }

        public Mask(int n, int n2, String string) {
            this.type = n;
            this.length = n2;
            this.separator = string;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public String getSeparator() {
            return this.separator;
        }

        public String getSeparatorRegex() {
            return "\\" + this.separator;
        }

        public void setSeparator(String string) {
            this.separator = string;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }
    }
}

