/*
 * Decompiled with CFR 0.152.
 */
package com.projity.help;

import com.projity.field.Field;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.util.BrowserControl;
import com.projity.util.Environment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.JTableHeader;

public class HelpUtil
implements KeyEventDispatcher {
    private HashMap<Component, String> map = new HashMap();
    private static HelpUtil instance = null;
    private static final int DELAY_BETWEEN_HELPS = 5000;
    private long lastHelpTime = 0L;
    public boolean noHelp = false;
    public static String helpTipImg = "<img src=\"" + IconManager.class.getResource("/toolbarButtonGraphics/general/Information16.gif") + "\"> F1";
    public static String helpTipHtml = "<html><img src=\"" + IconManager.class.getResource("/toolbarButtonGraphics/general/Information16.gif") + "\"> F1</html>";

    private static synchronized HelpUtil getInstance() {
        if (instance == null) {
            instance = new HelpUtil();
        }
        return instance;
    }

    private HelpUtil() {
        boolean bl = this.noHelp = Environment.getOs() == Environment.MAC && Environment.isApplet();
        if (this.noHelp) {
            System.out.print("no help");
        }
        if (this.noHelp) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public static void addHelp(Component component, String string) {
        if (HelpUtil.getInstance().noHelp) {
            return;
        }
        if (component instanceof JComponent && ((JComponent)component).getToolTipText() == null) {
            ((JComponent)component).setToolTipText(helpTipHtml);
        }
        HelpUtil.getInstance().map.put(component, string);
    }

    public static String getHelpURL(String string) {
        return "http://www.projectlibre.com/projectlibre-documentation" + string;
    }

    public static void addDocHelp(Component component, String string) {
        HelpUtil.addHelp(component, HelpUtil.getHelpURL(string));
    }

    public static String findHelp(Component component) {
        if (HelpUtil.getInstance().noHelp) {
            return null;
        }
        String string = null;
        while (component != null && (string = HelpUtil.getInstance().map.get(component)) == null) {
            component = component.getParent();
        }
        return string;
    }

    public static boolean doHelp(Component component) {
        if (HelpUtil.getInstance().noHelp) {
            return false;
        }
        String string = HelpUtil.findHelp(component);
        if (string != null) {
            long l = System.currentTimeMillis();
            boolean bl = l - HelpUtil.getInstance().lastHelpTime > 5000L;
            HelpUtil.getInstance().lastHelpTime = l;
            if (bl) {
                BrowserControl.displayURL(string);
                return true;
            }
        }
        return false;
    }

    public static boolean doHelp() {
        Component component;
        if (HelpUtil.getInstance().noHelp) {
            return false;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        for (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component != null && !(component instanceof JDialog) && !(component instanceof Frame); component = component.getParent()) {
        }
        Component component2 = null;
        Point point2 = component.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        component2 = ((Container)component).findComponentAt(point3);
        if (component2 == null) {
            component2 = component;
        }
        while (component2 != null) {
            if (component2 instanceof JTableHeader) {
                JTableHeader jTableHeader = (JTableHeader)component2;
                point2 = component2.getLocationOnScreen();
                point3 = new Point(point.x - point2.x, point.y - point2.y);
                int n = jTableHeader.columnAtPoint(point3);
                SpreadSheet spreadSheet = (SpreadSheet)jTableHeader.getTable();
                Field field = ((SpreadSheetModel)spreadSheet.getModel()).getFieldInColumn(n + 1);
                if (field.getHelp() != null) {
                    BrowserControl.displayURL("http://www.projectlibre.com/projectlibre-documentation" + field.getHelp());
                    return true;
                }
            }
            if (HelpUtil.doHelp(component2)) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.noHelp) {
            return false;
        }
        if (keyEvent.getKeyCode() == 112 && !keyEvent.isConsumed() && HelpUtil.doHelp()) {
            keyEvent.consume();
            return true;
        }
        return false;
    }
}

