/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.availability;

import com.projity.field.FieldContext;
import com.projity.interval.InvalidValueObjectForIntervalException;
import com.projity.interval.ValueObjectForInterval;
import com.projity.interval.ValueObjectForIntervalTable;
import com.projity.pm.availability.HasAvailability;
import com.projity.util.DateTime;

public class Availability
extends ValueObjectForInterval
implements HasAvailability {
    static final long serialVersionUID = 3647989273828L;
    double maximumUnits = 1.0;

    public Availability(ValueObjectForIntervalTable valueObjectForIntervalTable, long l) {
        super(valueObjectForIntervalTable, l);
    }

    public double getMaximumUnits() {
        return this.maximumUnits;
    }

    public void setMaximumUnits(double d) {
        this.maximumUnits = d;
    }

    public long getAvailableFrom() {
        return this.getStart();
    }

    public long getAvailableTo() {
        return this.getEnd();
    }

    public void setAvailableFrom(long l) throws InvalidValueObjectForIntervalException {
        this.table.adjustStart(l, this);
    }

    public void setAvailableTo(long l) {
        l = Math.min(l, DateTime.getMaxDate().getTime());
        this.setEnd(l);
    }

    public boolean isReadOnlyAvailableFrom(FieldContext fieldContext) {
        return this.isDefault();
    }

    public boolean isReadOnlyAvailableTo(FieldContext fieldContext) {
        return this.isDefault();
    }

    public boolean fieldHideMaximumUnits(FieldContext fieldContext) {
        return false;
    }
}

