/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.functor.IntervalConsumer;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.undo.FieldEdit;
import com.projity.undo.ScheduleEdit;
import com.projity.undo.SplitEdit;
import com.projity.util.ClassUtils;
import com.projity.util.DateTime;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class ScheduleService {
    private boolean consuming = false;
    private static Field completedFieldInstance = null;
    private static ScheduleService instance = null;

    public static Field getCompletedField() {
        if (completedFieldInstance == null) {
            completedFieldInstance = Configuration.getFieldFromId("Field.stop");
        }
        return completedFieldInstance;
    }

    public static ScheduleService getInstance() {
        if (instance == null) {
            instance = new ScheduleService();
        }
        return instance;
    }

    private ScheduleService() {
    }

    public long getCompleted(Schedule schedule) {
        return schedule.getCompletedThrough();
    }

    public void setCompleted(Object object, Schedule schedule, long l, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Field field = ScheduleService.getCompletedField();
        Object object2 = field.getValue(schedule);
        if (object2 == null) {
            object2 = new Long(schedule.getActualStart());
        }
        Long l2 = new Long(l);
        field.setValue(schedule, object, l2);
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            undoableEditSupport.postEdit(new FieldEdit(field, schedule, l2, object2, object, null));
        }
    }

    public static boolean isReadOnly(Schedule schedule) {
        return ClassUtils.isObjectReadOnly(schedule);
    }

    public void setInterval(Object object, Schedule schedule, long l, long l2, ScheduleInterval scheduleInterval, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Object object2 = null;
        l = DateTime.hourFloor(l);
        l2 = DateTime.hourFloor(l2);
        if (scheduleInterval.getStart() == l && scheduleInterval.getEnd() == l2) {
            return;
        }
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            object2 = schedule.backupDetail();
        }
        schedule.moveInterval(object, l, l2, scheduleInterval, false);
        if (object2 != null) {
            undoableEditSupport.postEdit(new ScheduleEdit(schedule, object2, l, l2, scheduleInterval, false, object));
        }
    }

    public void split(Object object, Schedule schedule, long l, long l2, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Object object2 = null;
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            object2 = schedule.backupDetail();
        }
        schedule.split(object, DateTime.hourFloor(l), DateTime.hourFloor(l2));
        if (object2 != null) {
            undoableEditSupport.postEdit(new SplitEdit(schedule, object2, l, l2, object));
        }
    }

    public void consumeIntervals(Schedule schedule, IntervalConsumer intervalConsumer) {
        if (this.consuming) {
            return;
        }
        this.consuming = true;
        schedule.consumeIntervals(intervalConsumer);
        this.consuming = false;
    }
}

