/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterContainer {
    private List<Filter> m_taskFilters = new ArrayList<Filter>();
    private List<Filter> m_resourceFilters = new ArrayList<Filter>();
    private Map<String, Filter> m_filtersByName = new HashMap<String, Filter>();
    private Map<Integer, Filter> m_filtersByID = new HashMap<Integer, Filter>();

    public void addFilter(Filter filter) {
        if (filter.isTaskFilter()) {
            this.m_taskFilters.add(filter);
        }
        if (filter.isResourceFilter()) {
            this.m_resourceFilters.add(filter);
        }
        this.m_filtersByName.put(filter.getName(), filter);
        this.m_filtersByID.put(filter.getID(), filter);
    }

    public void removeFilter(String string) {
        Filter filter = this.getFilterByName(string);
        if (filter != null) {
            if (filter.isTaskFilter()) {
                this.m_taskFilters.remove(filter);
            }
            if (filter.isResourceFilter()) {
                this.m_resourceFilters.remove(filter);
            }
            this.m_filtersByName.remove(string);
            this.m_filtersByID.remove(filter.getID());
        }
    }

    public List<Filter> getResourceFilters() {
        return this.m_resourceFilters;
    }

    public List<Filter> getTaskFilters() {
        return this.m_taskFilters;
    }

    public Filter getFilterByName(String string) {
        return this.m_filtersByName.get(string);
    }

    public Filter getFilterByID(Integer n) {
        return this.m_filtersByID.get(n);
    }
}

