/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UserFieldDataType {
    FT_TEXT("TEXT"),
    FT_START_DATE("START"),
    FT_END_DATE("FINISH"),
    FT_FLOAT_2_DECIMALS("NUMBER"),
    FT_INT("NUMBER"),
    FT_STATICTYPE("TEXT"),
    FT_MONEY("COST");

    private String m_defaultFieldName;
    private static final Map<FieldTypeClass, String> SUBJECT_AREA_MAP;

    private UserFieldDataType(String string2) {
        this.m_defaultFieldName = string2;
    }

    public String getDefaultFieldName() {
        return this.m_defaultFieldName;
    }

    public static String inferUserFieldDataType(DataType dataType) {
        switch (dataType) {
            case BINARY: 
            case STRING: 
            case DURATION: {
                return "Text";
            }
            case DATE: {
                return "Start Date";
            }
            case NUMERIC: {
                return "Double";
            }
            case BOOLEAN: 
            case INTEGER: 
            case SHORT: {
                return "Integer";
            }
            case CURRENCY: {
                return "Cost";
            }
        }
        throw new RuntimeException("Unconvertible data type: " + dataType);
    }

    public static String inferUserFieldSubjectArea(FieldType fieldType) {
        String string = SUBJECT_AREA_MAP.get((Object)fieldType.getFieldTypeClass());
        if (string == null) {
            throw new RuntimeException("Unrecognized field type: " + fieldType);
        }
        return string;
    }

    static {
        SUBJECT_AREA_MAP = new HashMap<FieldTypeClass, String>();
        SUBJECT_AREA_MAP.put(FieldTypeClass.TASK, "Activity");
        SUBJECT_AREA_MAP.put(FieldTypeClass.RESOURCE, "Resource");
        SUBJECT_AREA_MAP.put(FieldTypeClass.PROJECT, "Project");
        SUBJECT_AREA_MAP.put(FieldTypeClass.ASSIGNMENT, "Assignment");
        SUBJECT_AREA_MAP.put(FieldTypeClass.CONSTRAINT, "Constraint");
    }
}

