/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaDatabaseReader;
import net.sf.mpxj.asta.AstaFileReader;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.ProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversalProjectReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;
    private static final int BUFFER_SIZE = 512;
    private static final byte[] MPP_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88, 44};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] XER_FINGERPRINT = new byte[]{69, 82, 77, 72, 68, 82};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*<APIBusinessObjects.*", 32);
    private static final Pattern MSPDI_FINGERPRINT = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project\".*", 32);

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(512);
            byte[] byArray = new byte[512];
            int n = bufferedInputStream.read(byArray);
            bufferedInputStream.reset();
            if (n != 512) {
                throw new MPXJException("Invalid file format");
            }
            if (this.matchesFingerprint(byArray, MPP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPPReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MSPDI_FINGERPRINT)) {
                return new MSPDIReader().read(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new AstaFileReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MPX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPXReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, XER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraXERFileReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PLANNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PlannerReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PMXML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraPMFileReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bufferedInputStream);
            }
            return null;
        }
        catch (Exception exception) {
            throw new MPXJException("Invalid file format", exception);
        }
    }

    private boolean matchesFingerprint(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray2, Arrays.copyOf(byArray, byArray2.length));
    }

    private boolean matchesFingerprint(byte[] byArray, Pattern pattern) {
        return pattern.matcher(new String(byArray)).matches();
    }

    private ProjectFile readProjectFile(ProjectReader projectReader, InputStream inputStream) throws MPXJException {
        this.addListeners(projectReader);
        return projectReader.read(inputStream);
    }

    private ProjectFile readProjectFile(ProjectReader projectReader, File file) throws MPXJException {
        this.addListeners(projectReader);
        return projectReader.read(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleMDBFile(InputStream inputStream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(inputStream, ".mdb");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String string = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + file.getCanonicalPath();
            Set<String> set = this.populateTableNames(string);
            if (set.contains("MSP_PROJECTS")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MPDDatabaseReader(), file);
                return projectFile;
            }
            if (set.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleSQLiteFile(InputStream inputStream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(inputStream, ".sqlite");
        try {
            Class.forName("org.sqlite.JDBC");
            String string = "jdbc:sqlite:" + file.getCanonicalPath();
            Set<String> set = this.populateTableNames(string);
            if (set.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseFileReader(), file);
                return projectFile;
            }
            if (set.contains("PROJWBS")) {
                Connection connection = null;
                try {
                    Properties properties = new Properties();
                    properties.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
                    connection = DriverManager.getConnection(string, properties);
                    PrimaveraDatabaseReader primaveraDatabaseReader = new PrimaveraDatabaseReader();
                    primaveraDatabaseReader.setConnection(connection);
                    this.addListeners(primaveraDatabaseReader);
                    ProjectFile projectFile = primaveraDatabaseReader.read();
                    return projectFile;
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            file.delete();
        }
    }

    private ProjectFile handleZipFile(InputStream inputStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null) {
            return new UniversalProjectReader().read(zipInputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> populateTableNames(String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection(string);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("TABLE_NAME").toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return hashSet;
    }

    private void addListeners(ProjectReader projectReader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectReader.addProjectListener(projectListener);
            }
        }
    }
}

