/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPreservingProcess {
    private static final Logger LOG = Logger.getInstance(GitPreservingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<VirtualFile> myRootsToSave;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final String myDestinationName;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Runnable myOperation;
    @NotNull
    private final String myStashMessage;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final AtomicBoolean myLoaded;

    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull String destinationName, @NotNull GitVcsSettings.UpdateChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            GitPreservingProcess.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitPreservingProcess.$$$reportNull$$$0(1);
        }
        if (rootsToSave == null) {
            GitPreservingProcess.$$$reportNull$$$0(2);
        }
        if (operationTitle == null) {
            GitPreservingProcess.$$$reportNull$$$0(3);
        }
        if (destinationName == null) {
            GitPreservingProcess.$$$reportNull$$$0(4);
        }
        if (saveMethod == null) {
            GitPreservingProcess.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            GitPreservingProcess.$$$reportNull$$$0(6);
        }
        if (operation == null) {
            GitPreservingProcess.$$$reportNull$$$0(7);
        }
        this.myLoaded = new AtomicBoolean();
        this.myProject = project;
        this.myGit = git;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myDestinationName = destinationName;
        this.myProgressIndicator = indicator;
        this.myOperation = operation;
        this.myStashMessage = VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{StringUtil.capitalize((String)this.myOperationTitle)}) + " at " + DateFormatUtil.formatDateTime((long)Clock.getTime());
        this.mySaver = this.configureSaver(saveMethod);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(@Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = () -> {
            LOG.debug("starting");
            boolean savedSuccessfully = this.save();
            LOG.debug("save result: " + savedSuccessfully);
            if (savedSuccessfully) {
                try {
                    LOG.debug("running operation");
                    this.myOperation.run();
                    LOG.debug("operation completed.");
                }
                finally {
                    if (autoLoadDecision == null || ((Boolean)autoLoadDecision.compute()).booleanValue()) {
                        LOG.debug("loading");
                        this.load();
                    } else {
                        this.mySaver.notifyLocalChangesAreNotRestored();
                    }
                }
            }
            LOG.debug("finished.");
        };
        new GitFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    @NotNull
    private GitChangesSaver configureSaver(@NotNull GitVcsSettings.UpdateChangesPolicy saveMethod) {
        if (saveMethod == null) {
            GitPreservingProcess.$$$reportNull$$$0(8);
        }
        GitChangesSaver saver = GitChangesSaver.getSaver(this.myProject, this.myGit, this.myProgressIndicator, this.myStashMessage, saveMethod);
        MergeDialogCustomizer mergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                return String.format("<html>Uncommitted changes that were saved before %s have conflicts with files from <code>%s</code></html>", GitPreservingProcess.this.myOperationTitle, GitPreservingProcess.this.myDestinationName);
            }

            public String getLeftPanelTitle(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Uncommitted changes from stash";
            }

            public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                return String.format("<html>Changes from <b><code>%s</code></b></html>", GitPreservingProcess.this.myDestinationName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/util/GitPreservingProcess$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getMultipleFileMergeDescription";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getLeftPanelTitle";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRightPanelTitle";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer).setErrorNotificationTitle("Local changes were not restored");
        saver.setConflictResolverParams(params);
        GitChangesSaver gitChangesSaver = saver;
        if (gitChangesSaver == null) {
            GitPreservingProcess.$$$reportNull$$$0(9);
        }
        return gitChangesSaver;
    }

    private boolean save() {
        try {
            this.mySaver.saveLocalChanges(this.myRootsToSave);
            return true;
        }
        catch (VcsException e) {
            LOG.info("Couldn't save local changes", (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't save uncommitted changes.", String.format("Tried to save uncommitted changes in stash before %s, but failed with an error.<br/>%s", this.myOperationTitle, StringUtil.join((String[])e.getMessages())));
            return false;
        }
    }

    public void load() {
        if (this.myLoaded.compareAndSet(false, true)) {
            this.mySaver.load();
        } else {
            LOG.warn("The changes were already loaded", new Throwable());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitPreservingProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitPreservingProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "configureSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureSaver";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

