/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.RegionPainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class ScrollPainter
extends RegionPainter.Alpha {
    private static final Color x0D = ScrollPainter.gray("mac.scroll.thumb.darcula.border", 13);
    private static final Color xA6 = ScrollPainter.gray("mac.scroll.thumb.darcula.color", 166);
    private final int myOffset;
    private final float myAlphaBase;
    private final float myAlphaDelta;
    private final Color myFillColor;
    private final Color myDrawColor;

    private static Color gray(String key, int defaultValue) {
        return new JBColor(() -> {
            int value = Registry.intValue((String)key, (int)defaultValue);
            return value <= 0 ? Gray._0 : (value >= 255 ? Gray._255 : Gray.get((int)value));
        });
    }

    private ScrollPainter(int offset, float base, float delta, Color fill, Color draw) {
        this.myOffset = offset;
        this.myAlphaBase = base;
        this.myAlphaDelta = delta;
        this.myFillColor = fill;
        this.myDrawColor = draw;
    }

    protected float getAlpha(Float value) {
        return value != null ? this.myAlphaBase + this.myAlphaDelta * value.floatValue() : 0.0f;
    }

    protected void paint(Graphics2D g, int x, int y, int width, int height) {
        if (this.myOffset > 0) {
            x += this.myOffset;
            y += this.myOffset;
            width -= this.myOffset + this.myOffset;
            height -= this.myOffset + this.myOffset;
        }
        if (width > 0 && height > 0) {
            if (this.myFillColor != null) {
                g.setColor(this.myFillColor);
                this.fill(g, x, y, width, height, this.myDrawColor != null);
            }
            if (this.myDrawColor != null) {
                g.setColor(this.myDrawColor);
                this.draw(g, x, y, width, height);
            }
        }
    }

    protected void fill(Graphics2D g, int x, int y, int width, int height, boolean border) {
        if (border) {
            g.fillRect(x + 1, y + 1, width - 2, height - 2);
        } else {
            g.fillRect(x, y, width, height);
        }
    }

    protected void draw(Graphics2D g, int x, int y, int width, int height) {
        RectanglePainter.DRAW.paint(g, x, y, width, height, null);
    }

    static /* synthetic */ Color access$400() {
        return xA6;
    }

    static /* synthetic */ Color access$500() {
        return x0D;
    }

    private static class SubtractComposite
    implements Composite,
    CompositeContext {
        private final float myAlpha;

        private SubtractComposite(float alpha) {
            this.myAlpha = alpha;
        }

        private int subtract(int newValue, int oldValue) {
            float value = (float)(oldValue & 0xFF) - (float)(newValue & 0xFF) * this.myAlpha;
            return value <= 0.0f ? 0 : (int)value;
        }

        @Override
        public CompositeContext createContext(ColorModel src, ColorModel dst, RenderingHints hints) {
            return SubtractComposite.isValid(src) && SubtractComposite.isValid(dst) ? this : AlphaComposite.SrcOver.derive(this.myAlpha).createContext(src, dst, hints);
        }

        private static boolean isValid(ColorModel model) {
            DirectColorModel dcm;
            if (model instanceof DirectColorModel && 3 == model.getTransferType() && 0xFF0000 == (dcm = (DirectColorModel)model).getRedMask() && 65280 == dcm.getGreenMask() && 255 == dcm.getBlueMask()) {
                return 4 != dcm.getNumComponents() || -16777216 == dcm.getAlphaMask();
            }
            return false;
        }

        @Override
        public void compose(Raster srcIn, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(srcIn.getWidth(), dstIn.getWidth());
            int height = Math.min(srcIn.getHeight(), dstIn.getHeight());
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                srcIn.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int src = srcPixels[x];
                    int dst = dstPixels[x];
                    int a = this.subtract(src >> 24, dst >> 24) << 24;
                    int r = this.subtract(src >> 16, dst >> 16) << 16;
                    int g = this.subtract(src >> 8, dst >> 8) << 8;
                    int b = this.subtract(src, dst);
                    dstPixels[x] = a | r | g | b;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static class SubtractColor
    extends ScrollPainter {
        private SubtractColor(int offset, float base, float delta, Color fill, Color draw) {
            super(offset, base, delta, fill, draw);
        }

        protected Composite getComposite(float alpha) {
            return alpha < 1.0f ? new SubtractComposite(alpha) : AlphaComposite.SrcOver;
        }
    }

    private static class Protected
    implements RegionPainter<Float> {
        private RegionPainter<Float> myPainter;
        private RegionPainter<Float> myFallback;

        private Protected(RegionPainter<Float> painter, RegionPainter<Float> fallback) {
            this.myPainter = painter;
            this.myFallback = fallback;
        }

        public void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
            RegionPainter<Float> painter;
            block4: {
                painter = this.myFallback;
                if (this.myPainter != null) {
                    try {
                        this.myPainter.paint(g, x, y, width, height, (Object)value);
                        return;
                    }
                    catch (Throwable exception) {
                        if (SystemInfo.isWindows) break block4;
                        this.myPainter = null;
                    }
                }
            }
            if (painter != null) {
                painter.paint(g, x, y, width, height, (Object)value);
            }
        }
    }

    private static class Round
    extends ScrollPainter {
        private Round(int offset, float base, float delta, Color fill, Color draw) {
            super(offset, base, delta, fill, draw);
        }

        @Override
        protected void fill(Graphics2D g, int x, int y, int width, int height, boolean border) {
            RectanglePainter.FILL.paint(g, x, y, width, height, (Object)Math.min(width, height));
        }

        @Override
        protected void draw(Graphics2D g, int x, int y, int width, int height) {
            RectanglePainter.DRAW.paint(g, x, y, width, height, (Object)Math.min(width, height));
        }
    }

    static final class EditorThumb {
        static final RegionPainter<Float> DARCULA = new ScrollPainter(0, 0.33f, 0.12f, (Color)Gray.xA6, (Color)Gray.x1A);
        static final RegionPainter<Float> DEFAULT = new Protected((RegionPainter)new SubtractColor(0, 0.25f, 0.15f, (Color)Gray.x80, (Color)Gray.xA6), (RegionPainter)new ScrollPainter(0, 0.25f, 0.15f, (Color)Gray.x80, (Color)Gray.x59));

        EditorThumb() {
        }

        static final class Mac {
            static final RegionPainter<Float> DARCULA = new Round(1, 0.35f, 0.2f, ScrollPainter.access$400(), ScrollPainter.access$500());
            static final RegionPainter<Float> DEFAULT = Thumb.Mac.DEFAULT;

            Mac() {
            }

            static final class Overlay {
                static final RegionPainter<Float> DARCULA = new Round(1, 0.0f, 0.55f, ScrollPainter.access$400(), ScrollPainter.access$500());
                static final RegionPainter<Float> DEFAULT = Thumb.Mac.Overlay.DEFAULT;

                Overlay() {
                }
            }
        }
    }

    static final class Thumb {
        static final RegionPainter<Float> DARCULA = new ScrollPainter(0, 0.28f, 0.07f, (Color)Gray.xA6, (Color)Gray.x38);
        static final RegionPainter<Float> DEFAULT = new Protected((RegionPainter)new SubtractColor(0, 0.2f, 0.08f, (Color)Gray.x73, (Color)Gray.x91), (RegionPainter)new ScrollPainter(0, 0.2f, 0.08f, (Color)Gray.x73, (Color)Gray.x59));

        Thumb() {
        }

        static final class Mac {
            static final RegionPainter<Float> DARCULA = new Round(1, 0.35f, 0.2f, (Color)Gray.x80, (Color)Gray.x26);
            static final RegionPainter<Float> DEFAULT = new Round(2, 0.2f, 0.3f, (Color)Gray.x00, null);

            Mac() {
            }

            static final class Overlay {
                static final RegionPainter<Float> DARCULA = new Round(1, 0.0f, 0.55f, (Color)Gray.x80, (Color)Gray.x26);
                static final RegionPainter<Float> DEFAULT = new Round(2, 0.0f, 0.5f, (Color)Gray.x00, null);

                Overlay() {
                }
            }
        }
    }

    static final class Track {
        static final RegionPainter<Float> DARCULA = new ScrollPainter(0, 0.0f, 0.1f, (Color)Gray.x80, null);
        static final RegionPainter<Float> DEFAULT = DARCULA;

        Track() {
        }
    }
}

