/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    @NotNull
    private final RangeHighlighter myHighlighter;
    @NotNull
    private final TextDiffType myDiffType;
    private final boolean myIgnoredFoldingOutline;
    private final boolean myResolved;
    private final boolean myHideWithoutLineNumbers;
    private final boolean myEmptyRange;
    private final boolean myFirstLine;
    private final boolean myLastLine;

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType diffType, boolean ignoredFoldingOutline, boolean resolved, boolean hideWithoutLineNumbers, boolean isEmptyRange, boolean isFirstLine, boolean isLastLine) {
        if (highlighter == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        if (diffType == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        this.myHighlighter = highlighter;
        this.myDiffType = diffType;
        this.myIgnoredFoldingOutline = ignoredFoldingOutline;
        this.myResolved = resolved;
        this.myHideWithoutLineNumbers = hideWithoutLineNumbers;
        this.myEmptyRange = isEmptyRange;
        this.myFirstLine = isFirstLine;
        this.myLastLine = isLastLine;
    }

    public void paint(Editor editor, Graphics g, Rectangle range) {
        int y2;
        int y1;
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x1 = 0;
        int x2 = x1 + gutter.getWidth();
        if (this.myEmptyRange && this.myLastLine) {
            y2 = y1 = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(editor.getDocument()));
        } else {
            int startLine = editor.getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            int endLine = editor.getDocument().getLineNumber(this.myHighlighter.getEndOffset()) + 1;
            y1 = DiffDrawUtil.lineToY(editor, startLine);
            int n = y2 = this.myEmptyRange ? y1 : DiffDrawUtil.lineToY(editor, endLine);
        }
        if (this.myEmptyRange && this.myFirstLine) {
            ++y1;
            ++y2;
        }
        if (this.myHideWithoutLineNumbers && !editor.getSettings().isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else {
            int annotationsOffset = gutter.getAnnotationsAreaOffset();
            int annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                this.drawMarker(editor, g2, x1, annotationsOffset, y1, y2, false);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (this.myIgnoredFoldingOutline) {
            int xOutline = gutter.getWhitespaceSeparatorOffset();
            this.drawMarker(editor, g2, xOutline, x2, y1, y2, true);
            this.drawMarker(editor, g2, x1, xOutline, y1, y2, false);
        } else {
            this.drawMarker(editor, g2, x1, x2, y1, y2, false);
        }
    }

    private void drawMarker(Editor editor, Graphics2D g2, int x1, int x2, int y1, int y2, boolean ignoredBackgroundColor) {
        if (x1 >= x2) {
            return;
        }
        Color color = this.myDiffType.getColor(editor);
        if (y2 - y1 > 2) {
            if (!this.myResolved) {
                g2.setColor(ignoredBackgroundColor ? this.myDiffType.getIgnoredColor(editor) : color);
                g2.fillRect(x1, y1, x2 - x1, y2 - y1);
            } else {
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y1, color, false, this.myResolved);
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y2 - 1, color, false, this.myResolved);
            }
        } else {
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y1 - 1, color, true, this.myResolved);
        }
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffLineMarkerRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

