/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExportTestResultsDialog
extends DialogWrapper {
    private final ExportTestResultsForm myForm;
    private final ExportTestResultsConfiguration myConfig;

    public ExportTestResultsDialog(Project project, ExportTestResultsConfiguration config, String defaultFileName) {
        super(project);
        String defaultFolder;
        this.myConfig = config;
        if (StringUtil.isNotEmpty((String)config.getOutputFolder())) {
            defaultFolder = FileUtil.toSystemDependentName((String)config.getOutputFolder());
        } else {
            VirtualFile dir = project.getBaseDir();
            assert (dir != null);
            defaultFolder = FileUtil.toSystemDependentName((String)dir.getPresentableUrl());
        }
        this.myForm = new ExportTestResultsForm(config, defaultFileName, defaultFolder);
        this.myForm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExportTestResultsDialog.this.revalidate();
            }
        });
        this.setSize(600, 400);
        this.setTitle(ExecutionBundle.message((String)"export.test.results.dialog.title", (Object[])new Object[0]));
        this.init();
        this.revalidate();
    }

    protected void doOKAction() {
        this.myForm.apply(this.myConfig);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    private void revalidate() {
        String message = this.myForm.validate();
        this.myForm.showMessage(message);
        this.setOKActionEnabled(message == null);
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    protected String getDimensionServiceKey() {
        return "export.test.results";
    }

    protected String getHelpId() {
        return "reference.settings.ide.settings.export.test.results";
    }

    public String getFileName() {
        return this.myForm.getFileName();
    }
}

