/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectInAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.select.in");
        SelectInContext context = SelectInContextImpl.createContext(e);
        if (context == null) {
            return;
        }
        SelectInAction.invoke(e.getDataContext(), context);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SelectInAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (SelectInContextImpl.createContext(event) == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
        }
    }

    private static void invoke(@NotNull DataContext dataContext, @NotNull SelectInContext context) {
        ListPopup popup2;
        List<SelectInTarget> targetVector;
        if (dataContext == null) {
            SelectInAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SelectInAction.$$$reportNull$$$0(2);
        }
        if ((targetVector = Arrays.asList(SelectInAction.getSelectInManager(context.getProject()).getTargets())).isEmpty()) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new NoTargetsAction());
            popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        } else {
            popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new SelectInActionsStep(targetVector, context));
        }
        popup2.showInBestPositionFor(dataContext);
    }

    private static String numberingText(int n, String text) {
        text = n < 9 ? "&" + (n + 1) + ". " + text : (n == 9 ? "&0. " + text : "&" + (char)(65 + n - 10) + ". " + text);
        return text;
    }

    private static SelectInManager getSelectInManager(Project project) {
        return SelectInManager.getInstance((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SelectInAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NoTargetsAction
    extends AnAction {
        public NoTargetsAction() {
            super(IdeBundle.message((String)"message.no.targets.available", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }

    private static class SelectInActionsStep
    extends BaseListPopupStep<SelectInTarget> {
        private final SelectInContext mySelectInContext;
        private final List<SelectInTarget> myVisibleTargets;

        public SelectInActionsStep(@NotNull Collection<SelectInTarget> targetVector, @NotNull SelectInContext selectInContext) {
            if (targetVector == null) {
                SelectInActionsStep.$$$reportNull$$$0(0);
            }
            if (selectInContext == null) {
                SelectInActionsStep.$$$reportNull$$$0(1);
            }
            this.mySelectInContext = selectInContext;
            this.myVisibleTargets = ContainerUtil.newArrayList(targetVector);
            this.init(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), this.myVisibleTargets, null);
        }

        @NotNull
        public String getTextFor(SelectInTarget value) {
            ToolWindow toolWindow;
            String text = value.toString();
            String id = value.getMinorViewId() == null ? value.getToolWindowId() : null;
            ToolWindow toolWindow2 = toolWindow = id == null ? null : ToolWindowManager.getInstance((Project)this.mySelectInContext.getProject()).getToolWindow(id);
            if (toolWindow != null) {
                text = text.replace(value.getToolWindowId(), toolWindow.getStripeTitle());
            }
            int n = this.myVisibleTargets.indexOf(value);
            String string = SelectInAction.numberingText(n, text);
            if (string == null) {
                SelectInActionsStep.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PopupStep onChosen(SelectInTarget target2, boolean finalChoice) {
            ArrayList<SelectInTarget> subTargets;
            if (finalChoice) {
                PsiDocumentManager.getInstance((Project)this.mySelectInContext.getProject()).commitAllDocuments();
                target2.selectIn(this.mySelectInContext, true);
                return FINAL_CHOICE;
            }
            if (target2 instanceof CompositeSelectInTarget && (subTargets = new ArrayList<SelectInTarget>(((CompositeSelectInTarget)target2).getSubTargets(this.mySelectInContext))).size() > 0) {
                Collections.sort(subTargets, new SelectInManager.SelectInTargetComparator());
                return new SelectInActionsStep(subTargets, this.mySelectInContext);
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(SelectInTarget selectedValue) {
            return selectedValue instanceof CompositeSelectInTarget && ((CompositeSelectInTarget)selectedValue).getSubTargets(this.mySelectInContext).size() > 1;
        }

        public boolean isSelectable(SelectInTarget target2) {
            if (DumbService.isDumb((Project)this.mySelectInContext.getProject()) && !DumbService.isDumbAware((Object)target2)) {
                return false;
            }
            return target2.canSelect(this.mySelectInContext);
        }

        public boolean isMnemonicsNavigationEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetVector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectInContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SelectInAction$SelectInActionsStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SelectInAction$SelectInActionsStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

