/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.DeletedFilesHolder;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileHolderComposite
implements FileHolder {
    private final Map<FileHolder.HolderType, FileHolder> myHolders = new HashMap<FileHolder.HolderType, FileHolder>();

    public FileHolderComposite(Project project) {
        this.add(new VirtualFileHolder(project, FileHolder.HolderType.UNVERSIONED));
        this.add(new SwitchedFileHolder(project, FileHolder.HolderType.ROOT_SWITCH));
        this.add(new SwitchedFileHolder(project, FileHolder.HolderType.SWITCHED));
        this.add(new VirtualFileHolder(project, FileHolder.HolderType.MODIFIED_WITHOUT_EDITING));
        this.add(new IgnoredFilesCompositeHolder(project));
        this.add(new VirtualFileHolder(project, FileHolder.HolderType.LOCKED));
        this.add(new LogicallyLockedHolder(project));
        this.add(new DeletedFilesHolder());
    }

    private FileHolderComposite(FileHolderComposite holder) {
        for (FileHolder fileHolder : holder.myHolders.values()) {
            this.addCopy(fileHolder);
        }
    }

    private void add(@NotNull FileHolder fileHolder) {
        if (fileHolder == null) {
            FileHolderComposite.$$$reportNull$$$0(0);
        }
        this.myHolders.put(fileHolder.getType(), fileHolder);
    }

    private void addCopy(@NotNull FileHolder fileHolder) {
        if (fileHolder == null) {
            FileHolderComposite.$$$reportNull$$$0(1);
        }
        this.myHolders.put(fileHolder.getType(), fileHolder.copy());
    }

    @Override
    public void cleanAll() {
        for (FileHolder holder : this.myHolders.values()) {
            holder.cleanAll();
        }
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        for (FileHolder holder : this.myHolders.values()) {
            holder.cleanAndAdjustScope(scope);
        }
    }

    @Override
    public FileHolderComposite copy() {
        return new FileHolderComposite(this);
    }

    public FileHolder get(FileHolder.HolderType type) {
        return this.myHolders.get((Object)type);
    }

    public VirtualFileHolder getVFHolder(FileHolder.HolderType type) {
        return (VirtualFileHolder)this.myHolders.get((Object)type);
    }

    public IgnoredFilesCompositeHolder getIgnoredFileHolder() {
        return (IgnoredFilesCompositeHolder)this.myHolders.get((Object)FileHolder.HolderType.IGNORED);
    }

    public LogicallyLockedHolder getLogicallyLockedFileHolder() {
        return (LogicallyLockedHolder)this.myHolders.get((Object)FileHolder.HolderType.LOGICALLY_LOCKED);
    }

    public SwitchedFileHolder getRootSwitchFileHolder() {
        return (SwitchedFileHolder)this.myHolders.get((Object)FileHolder.HolderType.ROOT_SWITCH);
    }

    public SwitchedFileHolder getSwitchedFileHolder() {
        return (SwitchedFileHolder)this.myHolders.get((Object)FileHolder.HolderType.SWITCHED);
    }

    public DeletedFilesHolder getDeletedFileHolder() {
        return (DeletedFilesHolder)this.myHolders.get((Object)FileHolder.HolderType.DELETED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHolderComposite another = (FileHolderComposite)o;
        return this.myHolders.equals(another.myHolders);
    }

    public int hashCode() {
        return this.myHolders.hashCode();
    }

    @Override
    public FileHolder.HolderType getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
        for (FileHolder fileHolder : this.myHolders.values()) {
            fileHolder.notifyVcsStarted(vcs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "fileHolder";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/FileHolderComposite";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

