/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GetCommittedChangelistAction
extends AbstractCommonUpdateAction {
    private static final ScopeInfo CHANGELIST = new ScopeInfo(){

        @Override
        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            Collection filePaths = GetCommittedChangelistAction.getFilePaths(context);
            return filePaths.toArray(new FilePath[filePaths.size()]);
        }

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return "Changelist";
        }

        @Override
        public boolean filterExistsInVcs() {
            return false;
        }
    };

    public GetCommittedChangelistAction() {
        super(ActionInfo.UPDATE, CHANGELIST, false);
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        int rc;
        if (context == null) {
            GetCommittedChangelistAction.$$$reportNull$$$0(0);
        }
        Collection<FilePath> filePaths = GetCommittedChangelistAction.getFilePaths(context);
        ArrayList selectedChangeLists = new ArrayList();
        ChangeList[] selectionFromContext = context.getSelectedChangeLists();
        if (selectionFromContext != null) {
            Collections.addAll(selectedChangeLists, selectionFromContext);
        }
        List<CommittedChangeList> incomingChanges = CommittedChangesCache.getInstance(context.getProject()).getCachedIncomingChanges();
        ArrayList<CommittedChangeList> intersectingChanges = new ArrayList<CommittedChangeList>();
        if (incomingChanges != null) {
            block0: for (CommittedChangeList changeList : incomingChanges) {
                if (selectedChangeLists.contains(changeList)) continue;
                for (Change change : changeList.getChanges()) {
                    if (!filePaths.contains(ChangesUtil.getFilePath((Change)change))) continue;
                    intersectingChanges.add(changeList);
                    continue block0;
                }
            }
        }
        if (intersectingChanges.size() > 0 && (rc = Messages.showOkCancelDialog((Project)context.getProject(), (String)VcsBundle.message((String)"get.committed.changes.intersecting.prompt", (Object[])new Object[]{intersectingChanges.size(), selectedChangeLists.size()}), (String)VcsBundle.message((String)"get.committed.changes.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        super.actionPerformed(context);
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return false;
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            GetCommittedChangelistAction.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            GetCommittedChangelistAction.$$$reportNull$$$0(2);
        }
        super.update(vcsContext, presentation);
        ChangeList[] changeLists = vcsContext.getSelectedChangeLists();
        presentation.setEnabled(presentation.isEnabled() && CommittedChangesCache.getInstance(vcsContext.getProject()).getCachedIncomingChanges() != null && changeLists != null && changeLists.length > 0);
    }

    private static Collection<FilePath> getFilePaths(VcsContext context) {
        HashSet<FilePath> files = new HashSet<FilePath>();
        ChangeList[] selectedChangeLists = context.getSelectedChangeLists();
        if (selectedChangeLists != null) {
            for (ChangeList changelist : selectedChangeLists) {
                for (Change change : changelist.getChanges()) {
                    files.add(ChangesUtil.getFilePath((Change)change));
                }
            }
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/GetCommittedChangelistAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

