/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusTrackerBase {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    private final Object LOCK;
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final Document myDocument;
    @NotNull
    protected final Document myVcsDocument;
    @NotNull
    protected final Application myApplication;
    @NotNull
    protected final MyDocumentListener myDocumentListener;
    @NotNull
    protected final ApplicationAdapter myApplicationListener;
    private boolean myInitialized;
    private boolean myDuringRollback;
    private boolean myBulkUpdate;
    private boolean myAnathemaThrown;
    private boolean myReleased;
    @NotNull
    private List<Range> myRanges;
    @NotNull
    private final Set<Range> myToBeDestroyedRanges;
    @NotNull
    private final Set<Range> myToBeInstalledRanges;
    @Nullable
    private DirtyRange myDirtyRange;

    public LineStatusTrackerBase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myRanges = Collections.emptyList();
        this.myToBeDestroyedRanges = ContainerUtil.newIdentityTroveSet();
        this.myToBeInstalledRanges = ContainerUtil.newIdentityTroveSet();
        this.myDocument = document;
        this.myProject = project;
        this.myApplication = ApplicationManager.getApplication();
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        this.myApplicationListener = new MyApplicationListener();
        this.myApplication.addApplicationListener((ApplicationListener)this.myApplicationListener);
        this.myVcsDocument = new DocumentImpl("", true);
        this.myVcsDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
    }

    protected abstract void createHighlighter(@NotNull Range var1);

    protected boolean isDetectWhitespaceChangedLines() {
        return false;
    }

    protected void installNotification(@NotNull String text) {
        if (text == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(1);
        }
    }

    protected void destroyNotification() {
    }

    protected void fireFileUnchanged() {
    }

    @Nullable
    protected VirtualFile getVirtualFile() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseRevision(@NotNull CharSequence vcsContent) {
        if (vcsContent == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(2);
        }
        this.myApplication.assertIsDispatchThread();
        if (this.myReleased) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.myVcsDocument.setReadOnly(false);
                this.myVcsDocument.setText(vcsContent);
                this.myVcsDocument.setReadOnly(true);
            }
            finally {
                this.myInitialized = true;
            }
            this.reinstallRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinstallRanges() {
        if (!this.myInitialized || this.myReleased || this.myBulkUpdate) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.destroyRanges();
            try {
                this.myRanges = RangesBuilder.createRanges(this.myDocument, this.myVcsDocument, this.isDetectWhitespaceChangedLines());
                for (Range range : this.myRanges) {
                    this.createHighlighter(range);
                }
                if (this.myRanges.isEmpty()) {
                    this.fireFileUnchanged();
                }
            }
            catch (FilesTooBigForDiffException e) {
                this.installAnathema();
            }
        }
    }

    private void destroyRanges() {
        this.removeAnathema();
        for (Range range : this.myRanges) {
            range.invalidate();
            this.disposeHighlighter(range);
        }
        for (Range range : this.myToBeDestroyedRanges) {
            this.disposeHighlighter(range);
        }
        this.myRanges = Collections.emptyList();
        this.myToBeDestroyedRanges.clear();
        this.myToBeInstalledRanges.clear();
        this.myDirtyRange = null;
    }

    private void installAnathema() {
        this.myAnathemaThrown = true;
        this.installNotification("Can not highlight changed lines. File is too big and there are too many changes.");
    }

    private void removeAnathema() {
        if (!this.myAnathemaThrown) {
            return;
        }
        this.myAnathemaThrown = false;
        this.destroyNotification();
    }

    private void disposeHighlighter(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(3);
        }
        try {
            RangeHighlighter highlighter = range.getHighlighter();
            if (highlighter != null) {
                range.setHighlighter(null);
                highlighter.dispose();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean tryValidate() {
        if (this.myApplication.isDispatchThread()) {
            this.updateRanges();
        }
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperational() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myInitialized && !this.myReleased;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.LOCK;
        synchronized (object) {
            return !this.isSuppressed() && this.myDirtyRange == null;
        }
    }

    private boolean isSuppressed() {
        return !this.myInitialized || this.myReleased || this.myAnathemaThrown || this.myBulkUpdate || this.myDuringRollback;
    }

    public void release() {
        Runnable runnable2 = () -> {
            if (this.myReleased) {
                return;
            }
            LOG.assertTrue(!this.myDuringRollback);
            Object object = this.LOCK;
            synchronized (object) {
                this.myReleased = true;
                this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
                this.myApplication.removeApplicationListener((ApplicationListener)this.myApplicationListener);
                this.destroyRanges();
            }
        };
        if (this.myApplication.isDispatchThread() && !this.myDuringRollback) {
            runnable2.run();
        } else {
            this.myApplication.invokeLater(runnable2);
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(4);
        }
        return document;
    }

    @NotNull
    public Document getVcsDocument() {
        Document document = this.myVcsDocument;
        if (document == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(5);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Range> getRanges() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            this.myApplication.assertReadAccessAllowed();
            ArrayList<Range> result2 = new ArrayList<Range>(this.myRanges.size());
            for (Range range : this.myRanges) {
                result2.add(new Range(range));
            }
            return result2;
        }
    }

    @NotNull
    public List<Range> getRangesInner() {
        List<Range> list2 = this.myRanges;
        if (list2 == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(6);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkUpdate() {
        if (this.myReleased) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myBulkUpdate = true;
            this.destroyRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkUpdate() {
        if (this.myReleased) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myBulkUpdate = false;
            this.reinstallRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRanges() {
        if (this.isSuppressed()) {
            return;
        }
        if (this.myDirtyRange != null) {
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    this.doUpdateRanges(this.myDirtyRange.line1, this.myDirtyRange.line2, this.myDirtyRange.lineShift, this.myDirtyRange.beforeTotalLines);
                    this.myDirtyRange = null;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    this.reinstallRanges();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRangeHighlighters() {
        if (this.myToBeInstalledRanges.isEmpty() && this.myToBeDestroyedRanges.isEmpty()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myToBeInstalledRanges.removeAll(this.myToBeDestroyedRanges);
            for (Range range : this.myToBeDestroyedRanges) {
                this.disposeHighlighter(range);
            }
            for (Range range : this.myToBeInstalledRanges) {
                this.createHighlighter(range);
            }
            this.myToBeDestroyedRanges.clear();
            this.myToBeInstalledRanges.clear();
        }
    }

    @NotNull
    private int[] fixRanges(@NotNull DocumentEvent e, int line1, int line2) {
        if (e == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(7);
        }
        CharSequence document = this.myDocument.getCharsSequence();
        int offset = e.getOffset();
        if (e.getOldLength() == 0 && e.getNewLength() != 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTrackerBase.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    LineStatusTrackerBase.$$$reportNull$$$0(8);
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTrackerBase.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    LineStatusTrackerBase.$$$reportNull$$$0(9);
                }
                return nArray;
            }
        }
        if (e.getOldLength() != 0 && e.getNewLength() == 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTrackerBase.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    LineStatusTrackerBase.$$$reportNull$$$0(10);
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTrackerBase.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    LineStatusTrackerBase.$$$reportNull$$$0(11);
                }
                return nArray;
            }
        }
        int[] nArray = new int[]{line1, line2};
        if (nArray == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(12);
        }
        return nArray;
    }

    private static boolean isNewline(int offset, @NotNull CharSequence sequence) {
        if (sequence == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(13);
        }
        if (offset < 0) {
            return false;
        }
        if (offset >= sequence.length()) {
            return false;
        }
        return sequence.charAt(offset) == '\n';
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines) {
        LOG.assertTrue(!this.myReleased);
        ArrayList<Range> rangesBeforeChange = new ArrayList<Range>();
        ArrayList<Range> rangesAfterChange = new ArrayList<Range>();
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        this.sortRanges(beforeChangedLine1, beforeChangedLine2, linesShift, rangesBeforeChange, changedRanges, rangesAfterChange);
        Range firstChangedRange = (Range)ContainerUtil.getFirstItem(changedRanges);
        Range lastChangedRange = (Range)ContainerUtil.getLastItem(changedRanges);
        if (firstChangedRange != null && firstChangedRange.getLine1() < beforeChangedLine1) {
            beforeChangedLine1 = firstChangedRange.getLine1();
        }
        if (lastChangedRange != null && lastChangedRange.getLine2() > beforeChangedLine2) {
            beforeChangedLine2 = lastChangedRange.getLine2();
        }
        this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, linesShift, beforeTotalLines, rangesBeforeChange, changedRanges, rangesAfterChange);
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines, @NotNull List<Range> rangesBefore, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfter) {
        if (rangesBefore == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(14);
        }
        if (changedRanges == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(15);
        }
        if (rangesAfter == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(16);
        }
        try {
            int vcsTotalLines = DiffUtil.getLineCount(this.myVcsDocument);
            Range lastRangeBefore = (Range)ContainerUtil.getLastItem(rangesBefore);
            Range firstRangeAfter = (Range)ContainerUtil.getFirstItem(rangesAfter);
            int afterChangedLine1 = beforeChangedLine1;
            int afterChangedLine2 = beforeChangedLine2 + linesShift;
            int vcsLine1 = LineStatusTrackerBase.getVcsLine1(lastRangeBefore, beforeChangedLine1);
            int vcsLine2 = LineStatusTrackerBase.getVcsLine2(firstRangeAfter, beforeChangedLine2, beforeTotalLines, vcsTotalLines);
            List<Range> newChangedRanges = this.getNewChangedRanges(afterChangedLine1, afterChangedLine2, vcsLine1, vcsLine2);
            LineStatusTrackerBase.shiftRanges(rangesAfter, linesShift);
            if (!changedRanges.equals(newChangedRanges)) {
                this.myRanges = new ArrayList<Range>(rangesBefore.size() + newChangedRanges.size() + rangesAfter.size());
                this.myRanges.addAll(rangesBefore);
                this.myRanges.addAll(newChangedRanges);
                this.myRanges.addAll(rangesAfter);
                for (Range range : changedRanges) {
                    range.invalidate();
                }
                this.myToBeDestroyedRanges.addAll(changedRanges);
                this.myToBeInstalledRanges.addAll(newChangedRanges);
                if (this.myRanges.isEmpty()) {
                    this.fireFileUnchanged();
                }
            }
        }
        catch (ProcessCanceledException vcsTotalLines) {
        }
        catch (FilesTooBigForDiffException e1) {
            this.destroyRanges();
            this.installAnathema();
        }
    }

    private static int getVcsLine1(@Nullable Range range, int line) {
        return range == null ? line : line + range.getVcsLine2() - range.getLine2();
    }

    private static int getVcsLine2(@Nullable Range range, int line, int totalLinesBefore, int totalLinesAfter) {
        return range == null ? totalLinesAfter - totalLinesBefore + line : line + range.getVcsLine1() - range.getLine1();
    }

    private List<Range> getNewChangedRanges(int changedLine1, int changedLine2, int vcsLine1, int vcsLine2) throws FilesTooBigForDiffException {
        if (changedLine1 == changedLine2 && vcsLine1 == vcsLine2) {
            return Collections.emptyList();
        }
        if (changedLine1 == changedLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        if (vcsLine1 == vcsLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        List<String> lines2 = DiffUtil.getLines(this.myDocument, changedLine1, changedLine2);
        List<String> vcsLines = DiffUtil.getLines(this.myVcsDocument, vcsLine1, vcsLine2);
        return RangesBuilder.createRanges(lines2, vcsLines, changedLine1, vcsLine1, this.isDetectWhitespaceChangedLines());
    }

    private static void shiftRanges(@NotNull List<Range> rangesAfterChange, int shift) {
        if (rangesAfterChange == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(17);
        }
        for (Range range : rangesAfterChange) {
            range.shift(shift);
        }
    }

    private void sortRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, @NotNull List<Range> rangesBeforeChange, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfterChange) {
        Range range;
        int i;
        if (rangesBeforeChange == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(18);
        }
        if (changedRanges == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(19);
        }
        if (rangesAfterChange == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(20);
        }
        int lastBefore = -1;
        int firstAfter = this.myRanges.size();
        for (i = 0; i < this.myRanges.size(); ++i) {
            range = this.myRanges.get(i);
            if (range.getLine2() < beforeChangedLine1) {
                lastBefore = i;
                continue;
            }
            if (range.getLine1() <= beforeChangedLine2) continue;
            firstAfter = i;
            break;
        }
        while (lastBefore != -1) {
            int firstChangedLine = beforeChangedLine1;
            if (lastBefore + 1 < this.myRanges.size()) {
                Range firstChanged = this.myRanges.get(lastBefore + 1);
                firstChangedLine = Math.min(firstChangedLine, firstChanged.getLine1());
            }
            if (!LineStatusTrackerBase.isLineRangeEmpty(this.myDocument, this.myRanges.get(lastBefore).getLine2(), firstChangedLine)) break;
            --lastBefore;
        }
        while (firstAfter != this.myRanges.size()) {
            int firstUnchangedLineAfter = beforeChangedLine2 + linesShift;
            if (firstAfter > 0) {
                Range lastChanged = this.myRanges.get(firstAfter - 1);
                firstUnchangedLineAfter = Math.max(firstUnchangedLineAfter, lastChanged.getLine2() + linesShift);
            }
            if (!LineStatusTrackerBase.isLineRangeEmpty(this.myDocument, firstUnchangedLineAfter, this.myRanges.get(firstAfter).getLine1() + linesShift)) break;
            ++firstAfter;
        }
        for (i = 0; i < this.myRanges.size(); ++i) {
            range = this.myRanges.get(i);
            if (i <= lastBefore) {
                rangesBeforeChange.add(range);
                continue;
            }
            if (i >= firstAfter) {
                rangesAfterChange.add(range);
                continue;
            }
            changedRanges.add(range);
        }
    }

    private static boolean isLineRangeEmpty(@NotNull Document document, int line1, int line2) {
        int lineCount;
        if (document == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(21);
        }
        int startOffset = line1 == (lineCount = DiffUtil.getLineCount(document)) ? document.getTextLength() : document.getLineStartOffset(line1);
        int endOffset = line2 == lineCount ? document.getTextLength() : document.getLineStartOffset(line2);
        CharSequence interval = document.getImmutableCharSequence().subSequence(startOffset, endOffset);
        return StringUtil.isEmptyOrSpaces((CharSequence)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(Range range) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            int index = this.myRanges.indexOf(range);
            if (index == this.myRanges.size() - 1) {
                return null;
            }
            return this.myRanges.get(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(Range range) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            int index = this.myRanges.indexOf(range);
            if (index <= 0) {
                return null;
            }
            return this.myRanges.get(index - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(int line) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            for (Range range : this.myRanges) {
                if (line >= range.getLine2() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(int line) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            for (int i = this.myRanges.size() - 1; i >= 0; --i) {
                Range range = this.myRanges.get(i);
                if (line <= range.getLine1() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getRangeForLine(int line) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return null;
            }
            for (Range range : this.myRanges) {
                if (!range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    protected void doRollbackRange(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(22);
        }
        DiffUtil.applyModification(this.myDocument, range.getLine1(), range.getLine2(), this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
    }

    public void rollbackChanges(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(23);
        }
        this.rollbackChanges(Collections.singletonList(range));
    }

    public void rollbackChanges(@NotNull BitSet lines2) {
        if (lines2 == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(24);
        }
        ArrayList<Range> toRollback = new ArrayList<Range>();
        for (Range range : this.myRanges) {
            boolean check = DiffUtil.isSelectedByLine(lines2, range.getLine1(), range.getLine2());
            if (!check) continue;
            toRollback.add(range);
        }
        this.rollbackChanges(toRollback);
    }

    private void rollbackChanges(@NotNull List<Range> ranges) {
        if (ranges == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(25);
        }
        this.runBulkRollback(() -> {
            if (ranges == null) {
                LineStatusTrackerBase.$$$reportNull$$$0(35);
            }
            Range first = null;
            Range last = null;
            int shift = 0;
            for (Range range : ranges) {
                if (!range.isValid()) {
                    LOG.warn("Rollback of invalid range");
                    break;
                }
                if (first == null) {
                    first = range;
                }
                last = range;
                Range shiftedRange = new Range(range);
                shiftedRange.shift(shift);
                this.doRollbackRange(shiftedRange);
                shift += range.getVcsLine2() - range.getVcsLine1() - (range.getLine2() - range.getLine1());
            }
            if (first != null) {
                int beforeChangedLine1 = first.getLine1();
                int beforeChangedLine2 = last.getLine2();
                int beforeTotalLines = DiffUtil.getLineCount(this.myDocument) - shift;
                this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, shift, beforeTotalLines);
                this.updateRangeHighlighters();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBulkRollback(@NotNull Runnable task2) {
        if (task2 == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(26);
        }
        this.myApplication.assertWriteAccessAllowed();
        if (!this.tryValidate()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.myDuringRollback = true;
                task2.run();
            }
            catch (Error | RuntimeException e) {
                this.reinstallRanges();
                throw e;
            }
            finally {
                this.myDuringRollback = false;
            }
        }
    }

    @NotNull
    public CharSequence getCurrentContent(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(27);
        }
        TextRange textRange = this.getCurrentTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        if (charSequence == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(28);
        }
        return charSequence;
    }

    @NotNull
    public CharSequence getVcsContent(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(29);
        }
        TextRange textRange = this.getVcsTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myVcsDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        if (charSequence == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(30);
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getCurrentTextRange(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(31);
        }
        Object object = this.LOCK;
        // MONITORENTER : object
        assert (this.isValid());
        if (!range.isValid()) {
            LOG.warn("Current TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range.getLine1(), range.getLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        LineStatusTrackerBase.$$$reportNull$$$0(32);
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getVcsTextRange(@NotNull Range range) {
        if (range == null) {
            LineStatusTrackerBase.$$$reportNull$$$0(33);
        }
        Object object = this.LOCK;
        // MONITORENTER : object
        assert (this.isValid());
        if (!range.isValid()) {
            LOG.warn("Vcs TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        LineStatusTrackerBase.$$$reportNull$$$0(34);
        return textRange;
    }

    public boolean isLineModified(int line) {
        return this.isRangeModified(line, line + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeModified(int line1, int line2) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return false;
            }
            if (line1 == line2) {
                return false;
            }
            assert (line1 < line2);
            for (Range range : this.myRanges) {
                if (range.getLine1() >= line2) {
                    return false;
                }
                if (range.getLine2() <= line1) continue;
                return true;
            }
            return false;
        }
    }

    public int transferLineToFromVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, true);
    }

    public int transferLineToVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferLine(int line, boolean approximate, boolean fromVcs) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.tryValidate()) {
                return approximate ? line : -1;
            }
            int result2 = line;
            for (Range range : this.myRanges) {
                int endLine2;
                int startLine1 = fromVcs ? range.getVcsLine1() : range.getLine1();
                int endLine1 = fromVcs ? range.getVcsLine2() : range.getLine2();
                int startLine2 = fromVcs ? range.getLine1() : range.getVcsLine1();
                int n = endLine2 = fromVcs ? range.getLine2() : range.getVcsLine2();
                if (startLine1 <= line && endLine1 > line) {
                    return approximate ? startLine2 : -1;
                }
                if (endLine1 > line) {
                    return result2;
                }
                int length1 = endLine1 - startLine1;
                int length2 = endLine2 - startLine2;
                result2 += length2 - length1;
            }
            return result2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContent";
                break;
            }
            case 3: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusTrackerBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesBefore";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesAfter";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesAfterChange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesBeforeChange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusTrackerBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsDocument";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesInner";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fixRanges";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTextRange";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installNotification";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setBaseRevision";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disposeHighlighter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fixRanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNewline";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateRanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shiftRanges";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sortRanges";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isLineRangeEmpty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doRollbackRange";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runBulkRollback";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVcsContent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTextRange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getVcsTextRange";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rollbackChanges$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DirtyRange {
        public final int line1;
        public final int line2;
        public final int lineShift;
        public final int beforeTotalLines;

        public DirtyRange(int line1, int line2, int lineShift, int beforeTotalLines) {
            this.line1 = line1;
            this.line2 = line2;
            this.lineShift = lineShift;
            this.beforeTotalLines = beforeTotalLines;
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private int myLine1;
        private int myLine2;
        private int myBeforeTotalLines;

        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (LineStatusTrackerBase.this.isSuppressed()) {
                return;
            }
            assert (LineStatusTrackerBase.this.myDocument == e.getDocument());
            this.myLine1 = LineStatusTrackerBase.this.myDocument.getLineNumber(e.getOffset());
            this.myLine2 = e.getOldLength() == 0 ? this.myLine1 + 1 : LineStatusTrackerBase.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength()) + 1;
            this.myBeforeTotalLines = DiffUtil.getLineCount(LineStatusTrackerBase.this.myDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(DocumentEvent e) {
            LineStatusTrackerBase.this.myApplication.assertIsDispatchThread();
            if (LineStatusTrackerBase.this.isSuppressed()) {
                return;
            }
            assert (LineStatusTrackerBase.this.myDocument == e.getDocument());
            Object object = LineStatusTrackerBase.this.LOCK;
            synchronized (object) {
                int newLine1 = this.myLine1;
                int newLine2 = e.getNewLength() == 0 ? newLine1 + 1 : LineStatusTrackerBase.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength()) + 1;
                int linesShift = newLine2 - newLine1 - (this.myLine2 - this.myLine1);
                int[] fixed = LineStatusTrackerBase.this.fixRanges(e, this.myLine1, this.myLine2);
                int line1 = fixed[0];
                int line2 = fixed[1];
                if (LineStatusTrackerBase.this.myDirtyRange == null) {
                    LineStatusTrackerBase.this.myDirtyRange = new DirtyRange(line1, line2, linesShift, this.myBeforeTotalLines);
                } else {
                    int oldLine1 = ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.line1;
                    int oldLine2 = ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.line2 + ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.lineShift;
                    int updatedLine1 = ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.line1 - Math.max(oldLine1 - line1, 0);
                    int updatedLine2 = ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.line2 + Math.max(line2 - oldLine2, 0);
                    LineStatusTrackerBase.this.myDirtyRange = new DirtyRange(updatedLine1, updatedLine2, linesShift + ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.lineShift, ((LineStatusTrackerBase)LineStatusTrackerBase.this).myDirtyRange.beforeTotalLines);
                }
            }
        }
    }

    private class MyApplicationListener
    extends ApplicationAdapter {
        private MyApplicationListener() {
        }

        public void afterWriteActionFinished(@NotNull Object action) {
            if (action == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            LineStatusTrackerBase.this.updateRanges();
            LineStatusTrackerBase.this.updateRangeHighlighters();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyApplicationListener", "afterWriteActionFinished"));
        }
    }
}

