/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    protected final String myName;
    protected final String myPath;
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp = 0;
    private final VirtualFileSystem myFileSystem;
    protected boolean myProcessingBeforeContentsChange;

    protected AbstractVcsVirtualFile(String path, VirtualFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
        this.myPath = path;
        File file2 = new File(this.myPath);
        this.myName = file2.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file2.getParent(), this, this.myFileSystem) : null;
        OutsidersPsiFileSupport.markFile(this);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFileSystem;
        if (virtualFileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(0);
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getPresentableName() {
        if (this.myRevision == null) {
            return this.myName;
        }
        return this.myName + " (" + this.myRevision + ")";
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new RuntimeException(VcsFileSystem.COULD_NOT_IMPLEMENT_MESSAGE);
    }

    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void fireBeforeContentsChange() {
        this.myProcessingBeforeContentsChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ((VcsFileSystem)AbstractVcsVirtualFile.this.getFileSystem()).fireBeforeContentsChange(this, AbstractVcsVirtualFile.this);
                }
            });
        }
        finally {
            this.myProcessingBeforeContentsChange = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

