/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ThreeState;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveAttributeToInitQuickFix;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAttributeOutsideInitInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.attribute.outside.init", new Object[0]);
        if (string == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static boolean isApplicable(@NotNull PyClass containingClass, @NotNull TypeEvalContext context) {
        if (containingClass == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(5);
        }
        return !PythonUnitTestUtil.isTestClass(containingClass, ThreeState.UNSURE, context) && !containingClass.isSubclass("django.db.models.base.Model", context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = node.getName();
            if (name != null && name.startsWith("_")) {
                return;
            }
            if (!PyAttributeOutsideInitInspection.isApplicable(containingClass, this.myTypeEvalContext)) {
                return;
            }
            PyFunction.Modifier modifier = node.getModifier();
            if (modifier != null) {
                return;
            }
            List<PyTargetExpression> classAttributes = containingClass.getClassAttributes();
            HashMap<String, PyTargetExpression> attributesInInit = new HashMap<String, PyTargetExpression>();
            for (PyTargetExpression pyTargetExpression : classAttributes) {
                attributesInInit.put(pyTargetExpression.getName(), pyTargetExpression);
            }
            PyFunction initMethod = containingClass.findMethodByName("__init__", false, null);
            if (initMethod != null) {
                PyClassImpl.collectInstanceAttributes(initMethod, attributesInInit);
            }
            for (PyClass superClass : containingClass.getAncestorClasses(this.myTypeEvalContext)) {
                PyFunction superInit = superClass.findMethodByName("__init__", false, null);
                if (superInit != null) {
                    PyClassImpl.collectInstanceAttributes(superInit, attributesInInit);
                }
                for (PyTargetExpression classAttr : superClass.getClassAttributes()) {
                    attributesInInit.put(classAttr.getName(), classAttr);
                }
            }
            HashMap<String, PyTargetExpression> hashMap = new HashMap<String, PyTargetExpression>();
            PyClassImpl.collectInstanceAttributes(node, hashMap);
            for (Map.Entry attribute : hashMap.entrySet()) {
                String attributeName = (String)attribute.getKey();
                if (attributeName == null) continue;
                Property property = containingClass.findProperty(attributeName, true, null);
                if (attributesInInit.containsKey(attributeName) || property != null) continue;
                this.registerProblem((PsiElement)attribute.getValue(), PyBundle.message("INSP.attribute.$0.outside.init", attributeName), new PyMoveAttributeToInitQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection$Visitor", "<init>"));
        }
    }
}

