/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkAdditionalData
implements SdkAdditionalData {
    @NonNls
    private static final String PATHS_ADDED_BY_USER_ROOT = "PATHS_ADDED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_ADDED_BY_USER = "PATH_ADDED_BY_USER";
    @NonNls
    private static final String PATHS_REMOVED_BY_USER_ROOT = "PATHS_REMOVED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_REMOVED_BY_USER = "PATH_REMOVED_BY_USER";
    @NonNls
    private static final String ASSOCIATED_PROJECT_PATH = "ASSOCIATED_PROJECT_PATH";
    private final VirtualFilePointerContainer myAddedPaths;
    private final VirtualFilePointerContainer myExcludedPaths;
    private final PythonSdkFlavor myFlavor;
    private String myAssociatedProjectPath;
    private boolean myAssociateWithNewProject;

    public PythonSdkAdditionalData(@Nullable PythonSdkFlavor flavor) {
        this.myFlavor = flavor;
        this.myAddedPaths = VirtualFilePointerManager.getInstance().createContainer((Disposable)ApplicationManager.getApplication());
        this.myExcludedPaths = VirtualFilePointerManager.getInstance().createContainer((Disposable)ApplicationManager.getApplication());
    }

    public PythonSdkAdditionalData(PythonSdkAdditionalData from) {
        this.myFlavor = from.getFlavor();
        this.myAddedPaths = from.myAddedPaths.clone((Disposable)ApplicationManager.getApplication());
        this.myExcludedPaths = from.myExcludedPaths.clone((Disposable)ApplicationManager.getApplication());
    }

    public Object clone() {
        return new PythonSdkAdditionalData(this);
    }

    public void setAddedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myAddedPaths.killAll();
        for (VirtualFile file2 : addedPaths) {
            this.myAddedPaths.add(file2);
        }
    }

    public void setExcludedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(1);
        }
        this.myExcludedPaths.killAll();
        for (VirtualFile file2 : addedPaths) {
            this.myExcludedPaths.add(file2);
        }
    }

    public String getAssociatedProjectPath() {
        return this.myAssociatedProjectPath;
    }

    public void setAssociatedProjectPath(@Nullable String associatedProjectPath) {
        this.myAssociatedProjectPath = associatedProjectPath;
        this.myAssociateWithNewProject = false;
    }

    public void associateWithProject(@NotNull Project project) {
        String path;
        if (project == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(2);
        }
        if ((path = project.getBasePath()) != null) {
            this.myAssociatedProjectPath = FileUtil.toSystemIndependentName((String)path);
        }
        this.myAssociateWithNewProject = false;
    }

    public void associateWithNewProject() {
        this.myAssociateWithNewProject = true;
    }

    public void reassociateWithCreatedProject(@NotNull Project project) {
        if (project == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(3);
        }
        if (this.myAssociateWithNewProject) {
            this.associateWithProject(project);
        }
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(4);
        }
        PythonSdkAdditionalData.savePaths(rootElement, this.myAddedPaths, PATHS_ADDED_BY_USER_ROOT, PATH_ADDED_BY_USER);
        PythonSdkAdditionalData.savePaths(rootElement, this.myExcludedPaths, PATHS_REMOVED_BY_USER_ROOT, PATH_REMOVED_BY_USER);
        if (this.myAssociatedProjectPath != null) {
            rootElement.setAttribute(ASSOCIATED_PROJECT_PATH, this.myAssociatedProjectPath);
        }
    }

    private static void savePaths(Element rootElement, VirtualFilePointerContainer paths, String root, String element) {
        for (String addedPath : paths.getUrls()) {
            Element child = new Element(root);
            child.setAttribute(element, addedPath);
            rootElement.addContent(child);
        }
    }

    @Nullable
    public PythonSdkFlavor getFlavor() {
        return this.myFlavor;
    }

    @NotNull
    public static PythonSdkAdditionalData load(Sdk sdk, @Nullable Element element) {
        PythonSdkAdditionalData data = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(sdk.getHomePath()));
        data.load(element, data);
        PythonSdkAdditionalData pythonSdkAdditionalData = data;
        if (pythonSdkAdditionalData == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(5);
        }
        return pythonSdkAdditionalData;
    }

    protected void load(@Nullable Element element, @NotNull PythonSdkAdditionalData data) {
        if (data == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(6);
        }
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_ADDED_BY_USER_ROOT, (String)PATH_ADDED_BY_USER), this.myAddedPaths);
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_REMOVED_BY_USER_ROOT, (String)PATH_REMOVED_BY_USER), this.myExcludedPaths);
        if (element != null) {
            data.setAssociatedProjectPath(element.getAttributeValue(ASSOCIATED_PROJECT_PATH));
        }
    }

    private static void collectPaths(@NotNull List<String> paths, VirtualFilePointerContainer container) {
        if (paths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(7);
        }
        for (String path : paths) {
            if (StringUtil.isEmpty((String)path)) continue;
            String protocol = VirtualFileManager.extractProtocol((String)path);
            String url = protocol != null ? path : VirtualFileManager.constructUrl((String)"file", (String)path);
            container.add(url);
        }
    }

    public Set<VirtualFile> getAddedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myAddedPaths);
    }

    public Set<VirtualFile> getExcludedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myExcludedPaths);
    }

    private static Set<VirtualFile> getPathsAsVirtualFiles(VirtualFilePointerContainer paths) {
        HashSet ret = Sets.newHashSet();
        Collections.addAll(ret, paths.getFiles());
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAddedPathsFromVirtualFiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExcludedPathsFromVirtualFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "associateWithProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reassociateWithCreatedProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

