/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSystemWideInterpreterPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Ljava/util/List;)V", "panelName", "", "getPanelName", "()Ljava/lang/String;", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "python-community"})
public final class PyAddSystemWideInterpreterPanel
extends PyAddSdkPanel {
    @NotNull
    private final String panelName = "System interpreter";
    private final PySdkPathChoosingComboBox sdkComboBox;
    private final List<Sdk> existingSdks;

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object)PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox)));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk = this.sdkComboBox.getSelectedSdk();
        Sdk sdk2 = sdk;
        return sdk2 instanceof PyDetectedSdk ? PySdkExtKt.setup((PyDetectedSdk)sdk, this.existingSdks) : sdk;
    }

    public PyAddSystemWideInterpreterPanel(@NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        this.existingSdks = existingSdks;
        this.panelName = "System interpreter";
        this.sdkComboBox = new PySdkPathChoosingComboBox(PySdkExtKt.detectSystemWideSdks(this.existingSdks), null);
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent("Interpreter:", (JComponent)((Object)this.sdkComboBox)).getPanel();
        this.add((Component)formPanel, "North");
    }
}

