/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.common.SolrException;

class IntStreamFillMissingFunction
extends IntValueStream.AbstractIntValueStream
implements IntConsumer {
    private final IntValueStream baseExpr;
    private final IntValueStream fillExpr;
    public static final String name = "fill_missing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    IntConsumer cons;

    public IntStreamFillMissingFunction(IntValueStream baseExpr, IntValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamInts(IntConsumer cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamInts(this);
        if (!this.exists) {
            this.fillExpr.streamInts(cons);
        }
    }

    @Override
    public void accept(int value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

