/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.xmp.XmpDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpDescriptor
extends TagDescriptor<XmpDirectory> {
    public XmpDescriptor(@NotNull XmpDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: 
            case 2: {
                return ((XmpDirectory)this._directory).getString(tagType);
            }
            case 3: {
                return this.getExposureTimeDescription();
            }
            case 12: {
                return this.getExposureProgramDescription();
            }
            case 4: {
                return this.getShutterSpeedDescription();
            }
            case 5: {
                return this.getFNumberDescription();
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ((XmpDirectory)this._directory).getString(tagType);
            }
            case 10: {
                return this.getFocalLengthDescription();
            }
            case 11: {
                return this.getApertureValueDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getExposureTimeDescription() {
        String value = ((XmpDirectory)this._directory).getString(3);
        if (value == null) {
            return null;
        }
        return value + " sec";
    }

    @Nullable
    public String getExposureProgramDescription() {
        return this.getIndexedDescription(12, 1, "Manual control", "Program normal", "Aperture priority", "Shutter priority", "Program creative (slow program)", "Program action (high-speed program)", "Portrait mode", "Landscape mode");
    }

    @Nullable
    public String getShutterSpeedDescription() {
        Float value = ((XmpDirectory)this._directory).getFloatObject(4);
        if (value == null) {
            return null;
        }
        if (value.floatValue() <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)value.floatValue() * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            return fApexPower + " sec";
        }
        int apexPower = (int)Math.exp((double)value.floatValue() * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    @Nullable
    public String getFNumberDescription() {
        Rational value = ((XmpDirectory)this._directory).getRational(5);
        if (value == null) {
            return null;
        }
        return XmpDescriptor.getFStopDescription(value.doubleValue());
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational value = ((XmpDirectory)this._directory).getRational(10);
        return value == null ? null : XmpDescriptor.getFocalLengthDescription(value.doubleValue());
    }

    @Nullable
    public String getApertureValueDescription() {
        Double value = ((XmpDirectory)this._directory).getDoubleObject(11);
        if (value == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(value);
        return XmpDescriptor.getFStopDescription(fStop);
    }
}

