/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutePlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PREFIX = "op-";
    static final int DEFAULT_TASK_TIMEOUT_SECONDS = 120;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        log.debug("-- processing event: {} with context properties: {}", (Object)event, context.getProperties());
        SolrCloudManager dataProvider = context.getCloudManager();
        List operations = (List)context.getProperty("operations");
        if (operations == null || operations.isEmpty()) {
            log.info("No operations to execute for event: {}", (Object)event);
            return;
        }
        try {
            for (SolrRequest operation : operations) {
                log.info("Executing operation: {}", (Object)operation.getParams());
                try {
                    SolrResponse response = null;
                    int counter = 0;
                    if (operation instanceof CollectionAdminRequest.AsyncCollectionAdminRequest) {
                        CollectionAdminRequest.AsyncCollectionAdminRequest req = (CollectionAdminRequest.AsyncCollectionAdminRequest)operation;
                        req.setWaitForFinalState(true);
                        String asyncId = event.getSource() + '/' + event.getId() + '/' + counter;
                        String znode = this.saveAsyncId(dataProvider.getDistribStateManager(), event, asyncId);
                        log.debug("Saved requestId: {} in znode: {}", (Object)asyncId, (Object)znode);
                        req.setAsyncId(asyncId);
                        SolrResponse asyncResponse = dataProvider.request((SolrRequest)req);
                        if (asyncResponse.getResponse().get("error") != null) {
                            throw new IOException("" + asyncResponse.getResponse().get("error"));
                        }
                        asyncId = (String)asyncResponse.getResponse().get("requestid");
                        CollectionAdminRequest.RequestStatusResponse statusResponse = ExecutePlanAction.waitForTaskToFinish(dataProvider, asyncId, 120L, TimeUnit.SECONDS);
                        if (statusResponse != null) {
                            RequestStatusState state = statusResponse.getRequestStatus();
                            if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED || state == RequestStatusState.NOT_FOUND) {
                                try {
                                    dataProvider.getDistribStateManager().removeData(znode, -1);
                                }
                                catch (Exception e) {
                                    log.warn("Unexpected exception while trying to delete znode: " + znode, (Throwable)e);
                                }
                            }
                            response = statusResponse;
                        }
                    } else {
                        response = dataProvider.request(operation);
                    }
                    NamedList result = response.getResponse();
                    context.getProperties().compute("responses", (s, o) -> {
                        ArrayList<NamedList> responses = (ArrayList<NamedList>)o;
                        if (responses == null) {
                            responses = new ArrayList<NamedList>(operations.size());
                        }
                        responses.add(result);
                        return responses;
                    });
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to talk to ZooKeeper", (Throwable)e);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception executing operation: " + operation.getParams(), (Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception while processing event: " + event, (Throwable)e);
        }
    }

    static CollectionAdminRequest.RequestStatusResponse waitForTaskToFinish(SolrCloudManager dataProvider, String requestId, long duration, TimeUnit timeUnit) throws IOException, InterruptedException {
        long timeoutSeconds = timeUnit.toSeconds(duration);
        RequestStatusState state = RequestStatusState.NOT_FOUND;
        CollectionAdminRequest.RequestStatusResponse statusResponse = null;
        int i = 0;
        while ((long)i < timeoutSeconds) {
            try {
                statusResponse = (CollectionAdminRequest.RequestStatusResponse)dataProvider.request((SolrRequest)CollectionAdminRequest.requestStatus((String)requestId));
                state = statusResponse.getRequestStatus();
                if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED) {
                    log.info("Task with requestId={} finished with state={} in {}s", new Object[]{requestId, state, i * 5});
                    dataProvider.request((SolrRequest)CollectionAdminRequest.deleteAsyncId((String)requestId));
                    return statusResponse;
                }
                if (state == RequestStatusState.NOT_FOUND) {
                    log.warn("Task with requestId={} was not found on overseer", (Object)requestId);
                    dataProvider.request((SolrRequest)CollectionAdminRequest.deleteAsyncId((String)requestId));
                    return statusResponse;
                }
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof IllegalStateException && rootCause.getMessage().contains("Connection pool shut down")) {
                    throw e;
                }
                if (rootCause instanceof TimeoutException && rootCause.getMessage().contains("Could not connect to ZooKeeper")) {
                    throw e;
                }
                if (rootCause instanceof SolrServerException) {
                    throw e;
                }
                log.error("Unexpected Exception while querying status of requestId=" + requestId, (Throwable)e);
            }
            if (i > 0 && i % 5 == 0) {
                log.debug("Task with requestId={} still not complete after {}s. Last state={}", new Object[]{requestId, i * 5, state});
            }
            TimeUnit.SECONDS.sleep(5L);
            ++i;
        }
        log.debug("Task with requestId={} did not complete within 5 minutes. Last state={}", (Object)requestId, (Object)state);
        return statusResponse;
    }

    private String saveAsyncId(DistribStateManager stateManager, TriggerEvent event, String asyncId) throws InterruptedException, AlreadyExistsException, IOException, KeeperException {
        String parentPath = "/autoscaling/triggerState/" + event.getSource() + "/" + this.getName();
        try {
            stateManager.makePath(parentPath);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
        return stateManager.createData(parentPath + "/" + PREFIX, Utils.toJSON(Collections.singletonMap("requestid", asyncId)), CreateMode.PERSISTENT_SEQUENTIAL);
    }
}

