/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.util.Vector;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.actions.screens.columns.ActionsColumn;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.actions.screens.filters.FilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsScreen
extends ObservableImpl
implements Observable,
Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private String key;
    private byte[] columnOrder;
    private byte[] sortColumns;
    private byte[] sortStatus;
    private boolean showFilters;
    private Manager<ActionsColumn> columns;
    private Vector<ActionsFilter> filters;

    private ActionsScreen(String key) {
        this.key = key;
    }

    public static ActionsScreen create(String key) {
        ActionsScreen screen = new ActionsScreen(key);
        for (int i = 0; i < ActionsColumn.COLUMN_INDICES.length; ++i) {
            screen.getColumns().add((Observable)ActionsColumn.createColumn(ActionsColumn.COLUMN_INDICES[i]));
        }
        for (int j = 0; j < FilterFactory.INDICES.length; ++j) {
            byte index = FilterFactory.INDICES[j];
            screen.getFilters().add(FilterFactory.instance.createFilter(index));
        }
        return screen;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        String string = key = key == null ? "" : key;
        if (!Utils.equal((Object)this.key, (Object)key)) {
            this.key = key;
            this.notifyObservers(this);
        }
    }

    public String toString() {
        try {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.key);
        }
        catch (Exception ex) {
            return this.key;
        }
    }

    public Manager<ActionsColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new Manager();
            this.columns.addObserver((Observer)this);
        }
        return this.columns;
    }

    public void setColumns(Manager<ActionsColumn> columns) {
        if (this.columns != null) {
            this.columns.removeObserver((Observer)this);
        }
        this.columns = columns == null ? new Manager() : columns;
        this.columns.addObserver((Observer)this);
    }

    public byte[] getColumnOrder() {
        if (this.columnOrder == null) {
            this.columnOrder = new byte[0];
        }
        return this.columnOrder;
    }

    public void setColumnOrder(byte[] order) {
        this.columnOrder = order;
        this.notifyObservers(this);
    }

    public byte[] getSortColumns() {
        if (this.sortColumns == null) {
            this.sortColumns = new byte[0];
        }
        return this.sortColumns;
    }

    public void setSortColumns(byte[] columns) {
        this.sortColumns = columns;
        this.notifyObservers(this);
    }

    public byte[] getSortStates() {
        if (this.sortStatus == null) {
            this.sortStatus = new byte[0];
        }
        return this.sortStatus;
    }

    public void setSortStatus(byte[] status) {
        this.sortStatus = status;
        this.notifyObservers(this);
    }

    public Vector<ActionsFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new Vector();
        }
        return this.filters;
    }

    public void setFilters(Vector<ActionsFilter> filters) {
        this.filters = filters;
    }

    public void resetObservers() {
        if (this.columns != null) {
            this.columns.resetObservers();
            this.columns.addObserver((Observer)this);
        }
    }

    public void update(Observable observable, Object object) {
        this.notifyObservers(observable, object);
    }

    public boolean isShowFilters() {
        return this.showFilters;
    }

    public void setShowFilters(boolean showFilters) {
        this.showFilters = showFilters;
    }

    public boolean equals(Object object) {
        int i;
        if (!(object instanceof ActionsScreen)) {
            return false;
        }
        ActionsScreen other = (ActionsScreen)((Object)object);
        if (!this.key.equals(other.key)) {
            return false;
        }
        if (!Utils.equal((byte[])this.columnOrder, (byte[])other.columnOrder)) {
            return false;
        }
        if (!Utils.equal((byte[])this.sortColumns, (byte[])other.sortColumns)) {
            return false;
        }
        if (!Utils.equal((byte[])this.sortStatus, (byte[])other.sortStatus)) {
            return false;
        }
        if (this.showFilters != other.showFilters) {
            return false;
        }
        Vector thisColumns = this.columns.list();
        Vector thatColumns = other.columns.list();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        for (i = 0; i < thisColumns.size(); ++i) {
            if (((ActionsColumn)((Object)thisColumns.get(i))).equals(thatColumns.get(i))) continue;
            return false;
        }
        if (this.filters.size() != other.filters.size()) {
            return false;
        }
        for (i = 0; i < this.filters.size(); ++i) {
            if (this.filters.get(i).equals((Object)other.filters.get(i))) continue;
            return false;
        }
        return true;
    }
}

