/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.ResidueProperties;
import jalview.SwissprotFile;
import java.io.IOException;
import java.util.Vector;

public class Sequence {
    public String name;
    public String sequence;
    public int[] num;
    public int start;
    public int end;
    String desc;
    Vector features;
    Vector[] score;
    Vector pdbcode;
    SwissprotFile sp;

    public Sequence(Sequence sequence) {
        this.name = sequence.name;
        this.sequence = new String(sequence.getSequence());
        this.num = new int[this.sequence.length()];
        this.start = sequence.start;
        this.end = sequence.end;
        this.score = sequence.score;
        this.num = Sequence.setNums(sequence.getSequence());
    }

    public Sequence(String string, String string2, int n, int n2) {
        this.name = string;
        this.sequence = string2;
        this.num = new int[string2.length()];
        this.start = n;
        this.end = n2;
        this.score = new Vector[10];
        this.num = Sequence.setNums(string2);
    }

    public static int[] setNums(String string) {
        int[] nArray = new int[string.length()];
        int n = 0;
        while (n < string.length()) {
            try {
                nArray[n] = (Integer)ResidueProperties.aaHash.get(string.substring(n, n + 1));
            }
            catch (Exception exception) {
                System.out.println("Exception in Sequence:setNums " + n + " " + string.substring(n, n + 1));
                nArray[n] = 23;
            }
            ++n;
        }
        return nArray;
    }

    public void setScore(int n, float f, int n2) {
        if (n2 < 10 && this.score[n2] == null) {
            this.score[n2] = new Vector();
        } else {
            System.out.println("ERROR: maximum number of scores = 10 " + n2);
        }
        if (this.score[n2].size() <= n) {
            int n3 = this.score[n2].size();
            while (n3 <= n) {
                this.score[n2].addElement(null);
                ++n3;
            }
        }
        this.score[n2].setElementAt(new Double(f), n);
    }

    public void getFeatures(String string, String string2) {
        System.out.println("ark");
        if (this.features == null) {
            try {
                String string3 = this.name;
                if (string3.indexOf("/") > 0) {
                    string3 = this.name.substring(0, string3.indexOf("/"));
                }
                this.sp = new SwissprotFile("http://" + string + "wgetz?-e+[" + string2 + "-id:" + string3 + "]", "URL");
                if (this.sp == null || this.sp.sequence == null) {
                    this.sp = new SwissprotFile("http://" + string + "wgetz?-e+[" + string2 + "-acc:" + string3 + "]", "URL");
                }
                if (this.sp != null && this.sp.sequence != null) {
                    String string4 = AlignSeq.extractChars(". -", this.sequence);
                    System.out.println(string4);
                    System.out.println(this.sp.sequence.sequence);
                    System.out.println(String.valueOf(this.start) + " " + this.end);
                    System.out.println(this.sp.sequence.sequence.indexOf(string4));
                    if (this.sp.sequence.sequence.indexOf(string4) != this.start - 1) {
                        this.start = this.sp.sequence.sequence.indexOf(string4) + 1;
                        this.end = this.start + this.sequence.length() - 1;
                    }
                    if (!this.sp.id.equals("")) {
                        System.out.println("Fetched features for " + this.name);
                        this.features = this.sp.features;
                        this.pdbcode = this.sp.pdbcode;
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("Exception in fetching features " + iOException);
                return;
            }
        }
    }

    public int length() {
        return this.sequence.length();
    }

    public String getName() {
        return this.name;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public char charAt(int n) {
        if (n < this.sequence.length()) {
            return this.sequence.charAt(n);
        }
        return ' ';
    }

    public int findIndex(int n) {
        int n2 = this.start;
        int n3 = 0;
        while (n3 < this.sequence.length() && n2 <= this.end && n2 <= n) {
            String string = this.sequence.substring(n3, n3 + 1);
            if (!(string.equals(".") || string.equals("-") || string.equals(" "))) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == this.end && n2 < n) {
            return this.end + 1;
        }
        return n3;
    }

    public int findPosition(int n) {
        int n2 = 0;
        int n3 = this.start;
        while (n2 < n) {
            String string = this.sequence.substring(n2, n2 + 1);
            if (!(string.equals(".") || string.equals("-") || string.equals(" "))) {
                ++n3;
            }
            ++n2;
        }
        return n3;
    }

    public void deleteCharAt(int n, int n2) {
        if (this.score[n2].size() > n) {
            this.score[n2].removeElementAt(n);
        }
    }

    public void insertCharAt(int n, char c, int n2) {
        if (this.score[n2] != null) {
            int n3 = this.score[n2].size();
            while (n3 < n) {
                this.score[n2].addElement(new Double(0.0));
                ++n3;
            }
            this.score[n2].insertElementAt(new Double(0.0), n);
        }
    }

    public void deleteCharAt(int n) {
        this.sequence = n + 1 < this.sequence.length() ? String.valueOf(this.sequence.substring(0, n)) + this.sequence.substring(n + 1) : this.sequence.substring(0, n);
        int[] nArray = new int[this.num.length];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.num[n2];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.num.length) {
            nArray[n3 - 1] = this.num[n3];
            ++n3;
        }
        this.num[this.num.length - 1] = 23;
        this.num = nArray;
        int n4 = 0;
        while (n4 < this.score.length && this.score[n4] != null) {
            this.deleteCharAt(n, n4);
            ++n4;
        }
    }

    public void insertCharAt(int n, char c) {
        this.insertCharAt(n, c, true);
    }

    public void insertCharAt(int n, char c, boolean bl) {
        String string = new String(this.sequence);
        this.sequence = n < this.sequence.length() ? String.valueOf(string.substring(0, n)) + String.valueOf(c) + string.substring(n) : String.valueOf(string) + String.valueOf(c);
        int n2 = this.num.length + 1;
        if (bl && (this.sequence.substring(this.sequence.length() - 1).equals("-") || this.sequence.substring(this.sequence.length() - 1).equals(".") || this.sequence.substring(this.sequence.length() - 1).equals(" ")) && n < this.sequence.length() - 1) {
            n2 = this.num.length;
            this.sequence = this.sequence.substring(0, this.sequence.length() - 1);
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.num[n3];
            ++n3;
        }
        try {
            nArray[n3] = (Integer)ResidueProperties.aaHash.get(String.valueOf(c));
        }
        catch (Exception exception) {
            System.out.println("Exception in insertChar " + c);
            nArray[n3] = 23;
        }
        n3 = n + 1;
        while (n3 < n2) {
            nArray[n3] = this.num[n3 - 1];
            ++n3;
        }
        this.num = nArray;
        n3 = 0;
        while (n3 < this.score.length && this.score[n3] != null) {
            this.insertCharAt(n, c, n3);
            ++n3;
        }
    }

    public void setScore(int n, float f) {
        int n2 = 0;
        while (n2 < this.score.length && this.score[n2] != null) {
            this.setScore(n, f, n2);
            ++n2;
        }
    }
}

