/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.RandomEvent;
import gnu.java.security.prng.RandomEventListener;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class Fortuna
extends BasePRNG
implements Serializable,
RandomEventListener {
    private static final long serialVersionUID = 16435934L;
    private static final int SEED_FILE_SIZE = 64;
    private static final int NUM_POOLS = 32;
    private static final int MIN_POOL_SIZE = 64;
    private final Generator generator = new Generator(CipherFactory.getInstance("rijndael"), HashFactory.getInstance("sha-256"));
    private final IMessageDigest[] pools = new IMessageDigest[32];
    private long lastReseed;
    private int pool;
    private int pool0Count;
    private int reseedCount;
    public static final String SEED = "gnu.crypto.prng.fortuna.seed";

    public Fortuna() {
        super("fortuna");
        int i = 0;
        while (i < 32) {
            this.pools[i] = HashFactory.getInstance("sha-256");
            ++i;
        }
        this.lastReseed = 0L;
        this.pool = 0;
        this.pool0Count = 0;
        this.buffer = new byte[256];
    }

    public void setup(Map attributes) {
        this.lastReseed = 0L;
        this.reseedCount = 0;
        this.pool = 0;
        this.pool0Count = 0;
        this.generator.init(attributes);
        try {
            this.fillBlock();
        }
        catch (LimitReachedException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            ++this.reseedCount;
            byte[] cfr_ignored_0 = new byte[0];
            int i = 0;
            while (i < 32) {
                if (this.reseedCount % (1 << i) == 0) {
                    this.generator.addRandomBytes(this.pools[i].digest());
                }
                ++i;
            }
            this.lastReseed = System.currentTimeMillis();
            this.pool0Count = 0;
        }
        this.generator.nextBytes(this.buffer);
    }

    public void addRandomByte(byte b) {
        this.pools[this.pool].update(b);
        if (this.pool == 0) {
            ++this.pool0Count;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addRandomBytes(byte[] buf, int offset, int length) {
        this.pools[this.pool].update(buf, offset, length);
        if (this.pool == 0) {
            this.pool0Count += length;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addRandomEvent(RandomEvent event) {
        if (event.getPoolNumber() < 0 || event.getPoolNumber() >= this.pools.length) {
            throw new IllegalArgumentException("pool number out of range: " + event.getPoolNumber());
        }
        this.pools[event.getPoolNumber()].update(event.getSourceNumber());
        this.pools[event.getPoolNumber()].update((byte)event.getData().length);
        this.pools[event.getPoolNumber()].update(event.getData());
        if (event.getPoolNumber() == 0) {
            this.pool0Count += event.getData().length;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] seed = new byte[64];
        try {
            this.generator.nextBytes(seed);
        }
        catch (LimitReachedException shouldNeverHappen) {
            throw new Error(shouldNeverHappen);
        }
        out.write(seed);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        byte[] seed = new byte[64];
        in.readFully(seed);
        this.generator.addRandomBytes(seed);
    }

    public static class Generator
    extends BasePRNG
    implements Cloneable {
        private static final int LIMIT = 0x100000;
        private final IBlockCipher cipher;
        private final IMessageDigest hash;
        private final byte[] counter;
        private final byte[] key;
        private boolean seeded;

        public Generator(IBlockCipher cipher, IMessageDigest hash) {
            super("fortuna-generator");
            this.cipher = cipher;
            this.hash = hash;
            this.counter = new byte[cipher.defaultBlockSize()];
            this.buffer = new byte[cipher.defaultBlockSize()];
            int keysize = 0;
            Iterator it = cipher.keySizes();
            while (it.hasNext()) {
                int ks = (Integer)it.next();
                if (ks > keysize) {
                    keysize = ks;
                }
                if (keysize >= 32) break;
            }
            this.key = new byte[keysize];
        }

        public byte nextByte() {
            byte[] b = new byte[1];
            this.nextBytes(b, 0, 1);
            return b[0];
        }

        public void nextBytes(byte[] out, int offset, int length) {
            if (!this.seeded) {
                throw new IllegalStateException("generator not seeded");
            }
            int count = 0;
            do {
                int amount = Math.min(0x100000, length - count);
                try {
                    super.nextBytes(out, offset + count, amount);
                }
                catch (LimitReachedException shouldNeverHappen) {
                    throw new Error(shouldNeverHappen);
                }
                count += amount;
                int i = 0;
                while (i < this.key.length) {
                    this.fillBlock();
                    int l = Math.min(this.key.length - i, this.cipher.currentBlockSize());
                    System.arraycopy(this.buffer, 0, this.key, i, l);
                    i += this.counter.length;
                }
                this.resetKey();
            } while (count < length);
            this.fillBlock();
            this.ndx = 0;
        }

        public void addRandomByte(byte b) {
            this.addRandomBytes(new byte[]{b});
        }

        public void addRandomBytes(byte[] seed, int offset, int length) {
            this.hash.update(this.key);
            this.hash.update(seed, offset, length);
            byte[] newkey = this.hash.digest();
            System.arraycopy(newkey, 0, this.key, 0, Math.min(this.key.length, newkey.length));
            this.resetKey();
            this.incrementCounter();
            this.seeded = true;
        }

        public void fillBlock() {
            if (!this.seeded) {
                throw new IllegalStateException("generator not seeded");
            }
            this.cipher.encryptBlock(this.counter, 0, this.buffer, 0);
            this.incrementCounter();
        }

        public void setup(Map attributes) {
            this.seeded = false;
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.counter, (byte)0);
            byte[] seed = (byte[])attributes.get(Fortuna.SEED);
            if (seed != null) {
                this.addRandomBytes(seed);
            }
            this.fillBlock();
        }

        private void resetKey() {
            try {
                this.cipher.reset();
                this.cipher.init(Collections.singletonMap("gnu.crypto.cipher.key.material", this.key));
            }
            catch (InvalidKeyException ike) {
                throw new Error(ike);
            }
            catch (IllegalArgumentException iae) {
                throw new Error(iae);
            }
        }

        private void incrementCounter() {
            int i = 0;
            while (i < this.counter.length) {
                int n = i;
                this.counter[n] = (byte)(this.counter[n] + 1);
                if (this.counter[i] != 0) break;
                ++i;
            }
        }
    }
}

