/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInputStream
extends ZipInputStream {
    private Manifest manifest;
    private JarEntry firstEntry;

    public JarInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    public JarInputStream(InputStream in, boolean verify) throws IOException {
        super(in);
        this.readManifest(verify);
    }

    private void readManifest(boolean verify) throws IOException {
        this.firstEntry = (JarEntry)super.getNextEntry();
        while (this.firstEntry != null && this.firstEntry.getName().startsWith("META-INF/")) {
            if (this.firstEntry.getName().equals("META-INF/MANIFEST.MF")) {
                this.manifest = new Manifest(this);
            }
            this.firstEntry = (JarEntry)super.getNextEntry();
        }
    }

    protected ZipEntry createZipEntry(String name) {
        ZipEntry zipEntry = super.createZipEntry(name);
        JarEntry jarEntry = new JarEntry(zipEntry);
        if (this.manifest != null) {
            jarEntry.attr = this.manifest.getAttributes(name);
        }
        return jarEntry;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipEntry entry;
        if (this.firstEntry != null) {
            entry = this.firstEntry;
            this.firstEntry = null;
        } else {
            entry = super.getNextEntry();
        }
        return entry;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return super.read(buf, off, len);
    }
}

